/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import java.beans.Beans;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.gui.Activator;

public class DatasetCitationDialog
extends TitleAreaDialog {
    private Dataset dataset;

    public DatasetCitationDialog(Shell parentShell, Dataset dataset) {
        super(parentShell);
        this.dataset = dataset;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(SWTResourceManager.getColor(19));
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/citationBig.png"));
        if (!Beans.isDesignTime()) {
            this.setTitle(String.valueOf(this.dataset.getName().getValue(Activator.getLanguage())) + " - " + Activator.getPluginBundle().getString("label.citation.title"));
            this.setMessage(this.dataset.getDescription().getValue(Activator.getLanguage()));
        } else {
            this.setTitle("@Dataset@ - " + Activator.getPluginBundle().getString("label.citation.title"));
            this.setMessage("@Dataset Description@");
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblAcronym = new Label(container, 0);
        lblAcronym.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        lblAcronym.setText(Activator.getPluginBundle().getString("label.citation.text"));
        Text textCitation = new Text(container, 64);
        textCitation.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (!Beans.isDesignTime()) {
            textCitation.setText(this.dataset.getCitation().getValue(CoreCommons.LOCALE2));
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return Activator.windowsScaling(700, 500);
    }

    protected boolean isResizable() {
        return true;
    }
}

