/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.dynamics;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.core.model.aggregation.AggregationWrapper;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.aggregation.AggregationDialog;

public class ContextAggregationHandler
extends AbstractHandler
implements IHandler,
IElementUpdater {
    public static final String ID = "org.fao.fi.fishstat.gui.command.dynamic.contextual.aggregation";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session == null) {
            return null;
        }
        Object ro = session.getLastFocusEntity().getEntity();
        if (ro instanceof ReferenceObject) {
            AggregationWrapper agg;
            FSDimensionColumnDescriptor descriptor = (FSDimensionColumnDescriptor)session.getLastFocusEntity().getColumnDescriptor();
            Dimension dimension = descriptor.getDimension();
            Concept concept = ((ReferenceObject)ro).getConcept();
            AggregationWrapper aggregationWrapper = agg = session.hasAggregationRequest() ? session.getAggregationRequest() : new AggregationWrapper(session);
            if (concept.equals(dimension.getConcept())) {
                agg.getDimensionAggregation(dimension.getConcept().getAcronym()).setAggregatedDimension();
            } else {
                agg.getDimensionAggregation(dimension.getConcept().getAcronym()).setDetailedDimension();
            }
            AggregationDialog.modifyAggregation(agg);
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof EvaluationContext && ((EvaluationContext)evaluationContext).getDefaultVariable() instanceof Boolean) {
            this.setBaseEnabled((Boolean)((EvaluationContext)evaluationContext).getDefaultVariable());
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session == null) {
            return;
        }
        FocusEntity lastFocusEntity = session.getLastFocusEntity();
        if (lastFocusEntity == null) {
            return;
        }
        Object ro = lastFocusEntity.getEntity();
        if (ro != null && ro instanceof ReferenceObject) {
            FSDimensionColumnDescriptor descriptor;
            Dimension dimension;
            Concept concept = ((ReferenceObject)ro).getConcept();
            String text = String.valueOf(!concept.equals((dimension = (descriptor = (FSDimensionColumnDescriptor)session.getLastFocusEntity().getColumnDescriptor()).getDimension()).getConcept()) ? Activator.getLocalString("label.disaggregate.first.upper") : Activator.getLocalString("label.aggregate.first.upper")) + dimension.getName().getValue(Activator.getLanguage());
            element.setText(text);
        }
    }

    public boolean isHandled() {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        Object ro = session.getLastFocusEntity().getEntity();
        return ro != null && ro instanceof ReferenceObject;
    }
}

