/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.dynamics.compounds;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.handler.dynamics.AttachmentPanelHandler;

public class DatasetAttachmentsToolbarProvider
extends ExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session == null) {
            return;
        }
        Dataset ds = session.getDataset();
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        AttachmentPanelHandler attachmentHandler = new AttachmentPanelHandler();
        attachmentHandler.setID(ds.getAcronym());
        Command command = commandService.getCommand(attachmentHandler.getID());
        command.setHandler((IHandler)attachmentHandler);
        try {
            IParameter ipar = commandService.getCommand("org.fao.fi.fishstat.gui.command.dynamic.contextual.attachment").getParameter("org.fao.fi.fishstat.gui.command.dynamic.contextual.attachment.id");
            IParameter[] iparameter = new IParameter[]{ipar};
            command.define("AttachmentPanelHandler()", "custom handler for " + ds.getAcronym(), commandService.getCategory("org.eclipse.core.commands.categories.autogenerated"), iparameter);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "parametrized command", (Throwable)e));
        }
        try {
            if (ds.getCitation() != null) {
                HashMap<String, String> parameters1 = new HashMap<String, String>();
                parameters1.put("org.fao.fi.fishstat.gui.command.dynamic.contextual.attachment.id", "citation");
                CommandContributionItemParameter p1 = new CommandContributionItemParameter(serviceLocator, "", attachmentHandler.getID(), 8);
                p1.parameters = parameters1;
                p1.label = String.valueOf(ds.getName().getValue(Activator.getLanguage())) + " - " + Activator.getLocalString("label.citation.title");
                p1.icon = Activator.getImageDescriptor("icons/actions/citation.png");
                p1.tooltip = String.valueOf(ds.getName().getValue(Activator.getLanguage())) + " - " + Activator.getLocalString("label.citation.title");
                CommandContributionItem item1 = new CommandContributionItem(p1);
                item1.setVisible(true);
                additions.addContributionItem((IContributionItem)item1, null);
            }
        }
        catch (Exception e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "getCitation", (Throwable)e1));
        }
        for (Attachment attachment : ds.getAttachments()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.fao.fi.fishstat.gui.command.dynamic.contextual.attachment.id", attachment.getAcronym());
            ImageDescriptor icon = null;
            icon = attachment.getType().equals((Object)AttachmentType.BITMAP) || attachment.getType().equals((Object)AttachmentType.JPG) ? Activator.getImageDescriptor("icons/actions/map.png") : (attachment.getType().equals((Object)AttachmentType.HTML) || attachment.getType().equals((Object)AttachmentType.TEXT) ? Activator.getImageDescriptor("icons/actions/notes.png") : Activator.getImageDescriptor("icons/actions/attach.png"));
            CommandContributionItemParameter p = new CommandContributionItemParameter(serviceLocator, "", attachmentHandler.getID(), 8);
            p.parameters = parameters;
            p.label = attachment.getName().getValue(Activator.getLanguage());
            p.icon = icon;
            p.tooltip = attachment.getDescription().getValue(Activator.getLanguage());
            CommandContributionItem item = new CommandContributionItem(p);
            item.setVisible(true);
            additions.addContributionItem((IContributionItem)item, null);
        }
    }
}

