/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences;

import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class MainPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    public static final String ID = "org.fao.fi.fishstat.gui.preferences.general";
    private Button checkboxSaveWorkingSession;
    private Button checkboxJoinDataset;
    private Button chekboxLogDiagnostic;
    private Label labelDownloadFolder;

    protected Control createContents(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 8;
        gridLayout.horizontalSpacing = 8;
        composite.setLayout((Layout)gridLayout);
        this.checkboxSaveWorkingSession = new Button(composite, 32);
        this.checkboxSaveWorkingSession.setText(Activator.getLocalString("preferences.general.preferences.save.on.exit"));
        this.checkboxJoinDataset = new Button(composite, 32);
        this.checkboxJoinDataset.setText(Activator.getLocalString("preferences.general.preferences.syncro.same.dataset"));
        this.chekboxLogDiagnostic = new Button(composite, 32);
        this.chekboxLogDiagnostic.setText(Activator.getLocalString("preferences.general.logdiagnostic.text"));
        this.chekboxLogDiagnostic.setToolTipText(Activator.getLocalString("preferences.general.logdiagnostic.tooltip"));
        Label separator1 = new Label(composite, 258);
        separator1.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        Button buttonDownloadFolder = new Button(composite, 0);
        buttonDownloadFolder.setText(Activator.getLocalString("preferences.general.workspacedownload.text"));
        buttonDownloadFolder.setToolTipText(Activator.getLocalString("preferences.general.workspacedownload.tooltip"));
        buttonDownloadFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainPage.this.selectDownloadFolder(parent.getShell());
            }
        });
        this.labelDownloadFolder = new Label(composite, 0);
        Label separator2 = new Label(composite, 258);
        separator2.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.syncroPanel();
        this.validateDownloadFolder();
        return composite;
    }

    private void selectDownloadFolder(Shell parent) {
        DirectoryDialog dialog = new DirectoryDialog(parent, 4098);
        dialog.setFilterPath(this.labelDownloadFolder.getText());
        dialog.setText(Activator.getLocalString("preferences.general.workspacedownload.chooser"));
        String seletedFolder = dialog.open();
        if (seletedFolder != null) {
            this.labelDownloadFolder.setText(seletedFolder);
            this.validateDownloadFolder();
        }
    }

    private void validateDownloadFolder() {
        if (new File(this.labelDownloadFolder.getText()).exists() && new File(this.labelDownloadFolder.getText()).isDirectory()) {
            this.setValid(true);
            this.setErrorMessage(null);
        } else {
            this.setValid(false);
            this.setErrorMessage(Activator.getLocalString("preferences.general.workspacedownload.error"));
        }
    }

    private void syncroPanel() {
        this.checkboxSaveWorkingSession.setSelection(this.getPreferenceStore().getBoolean("core.persist.work.session"));
        this.checkboxJoinDataset.setSelection(this.getPreferenceStore().getBoolean("core.join.related.series"));
        this.chekboxLogDiagnostic.setSelection(this.getPreferenceStore().getBoolean("log.diagnostic.active"));
        this.labelDownloadFolder.setText(this.getPreferenceStore().getString("workspace.download.folder"));
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Activator.getLocalString("preferences.general.preferences.subtitle"));
        this.setTitle(Activator.getLocalString("preferences.general.preferences.title"));
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.checkboxSaveWorkingSession.setSelection(this.getPreferenceStore().getDefaultBoolean("core.persist.work.session"));
        this.checkboxJoinDataset.setSelection(this.getPreferenceStore().getDefaultBoolean("core.join.related.series"));
        this.chekboxLogDiagnostic.setSelection(this.getPreferenceStore().getDefaultBoolean("log.diagnostic.active"));
        this.labelDownloadFolder.setText(this.getPreferenceStore().getDefaultString("workspace.download.folder"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("core.persist.work.session", this.checkboxSaveWorkingSession.getSelection());
        this.getPreferenceStore().setValue("core.join.related.series", this.checkboxJoinDataset.getSelection());
        this.getPreferenceStore().setValue("log.diagnostic.active", this.chekboxLogDiagnostic.getSelection());
        this.getPreferenceStore().setValue("workspace.download.folder", this.labelDownloadFolder.getText());
        return super.performOk();
    }
}

