/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;

public class ConceptNameDescriptorTableViewer
extends TableViewer
implements Observer {
    private final String CONCEPT = Activator.getPluginBundle().getString("label.concept.first.upper");
    private final String NAME = Activator.getPluginBundle().getString("label.name.first.upper");
    private final String DESCRIPTION = Activator.getPluginBundle().getString("label.description.first.upper");
    private final String[] PROPERTIES = new String[]{this.CONCEPT, this.NAME, this.DESCRIPTION};
    private DimensionProperties dimProperties;
    private String source;

    public ConceptNameDescriptorTableViewer(Composite parent, int style, DimensionProperties p, String source) {
        super(parent, style);
        this.dimProperties = p;
        this.source = source;
        this.initComponents();
    }

    private void initComponents() {
        this.addSelectionChangedListener(event -> this.refresh());
        this.setContentProvider((IContentProvider)new TableContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.setInput(this.dimProperties);
        Table table = this.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gd_tblDimensionDescriptor = new GridData(4, 4, true, true, 1, 1);
        table.setLayoutData((Object)gd_tblDimensionDescriptor);
        table.setHeaderBackground(SWTResourceManager.getColor(250, 250, 250));
        TableColumn tclConcept = new TableColumn(table, 0);
        tclConcept.setWidth(120);
        tclConcept.setText(String.valueOf(this.CONCEPT) + "   ");
        tclConcept.setResizable(true);
        TableColumn tclName = new TableColumn(table, 0);
        tclName.setWidth(110);
        tclName.setText(String.valueOf(this.NAME) + "   ");
        tclConcept.setResizable(true);
        TableColumn tclDescription = new TableColumn(table, 0);
        tclDescription.setWidth(330);
        tclDescription.setText(String.valueOf(this.DESCRIPTION) + "   ");
        tclConcept.setResizable(true);
        this.setColumnProperties(this.PROPERTIES);
        if (this.dimProperties != null) {
            this.dimProperties.addObserver((Observer)this);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.refresh(true);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.dimProperties != null) {
            this.dimProperties.deleteObserver((Observer)this);
        }
        super.handleDispose(event);
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DimensionProperties) {
                if (ConceptNameDescriptorTableViewer.this.source.equals("Dimensions")) {
                    return ((DimensionProperties)inputElement).getDescriptors().toArray(new ConceptProperties[0]);
                }
                if (ConceptNameDescriptorTableViewer.this.source.equals("select")) {
                    return ((DimensionProperties)inputElement).getSelectors().toArray(new ConceptProperties[0]);
                }
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ConceptProperties) {
                Concept concept = ((ConceptProperties)element).getConcept();
                Attribute attribute = ((ConceptProperties)element).getAttribute();
                switch (columnIndex) {
                    case 0: {
                        return CoreUtils.getCurrentLangName((Object)concept, (String)Activator.getLanguage());
                    }
                    case 1: {
                        return CoreUtils.getCurrentLangName((Object)attribute, (String)Activator.getLanguage());
                    }
                    case 2: {
                        return CoreUtils.getCurrentLang((MultilingualString)attribute.getDescription(), (String)Activator.getLanguage());
                    }
                }
                return "";
            }
            return "";
        }
    }
}

