/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.calcmesaures;

import java.beans.Beans;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.FAOMeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinitionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.composites.FunctionSkipParameters;
import org.fao.fi.fishstat.gui.components.widgets.FunctionsViewerFactory;
import org.fao.fi.fishstat.gui.core.model.functions.CalculatedMeasureDefinitionWrapper;
import org.fao.fi.fishstat.gui.core.model.functions.ParameterWrapper;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;
import org.fao.fi.fishstat.gui.properties.dataset.calcmesaures.FunctionParametersPanel;

public class CalculatedMeasureEditorDialog
extends TitleAreaDialog {
    private static final int INSERT_MODE = 1;
    private static final int UPDATE_MODE = 2;
    CalculatedMeasuresProperties calculatedMeasureProperties;
    CalculatedMeasureDefinitionWrapper calculatedMeasureWrapper;
    private int mode;
    private Combo combo;
    private ComboViewer comboViewer;
    private Text txtColumnName;
    private Group grpFunctionParameters;
    private FunctionSkipParameters skipParametersPanel;
    private FunctionParametersPanel functionParametersPanel;
    private Text txtFunctionDescription;

    public CalculatedMeasureEditorDialog(Shell parentShell, CalculatedMeasuresProperties calculatedMeasureProperties, CalculatedMeasureDefinitionWrapper calculatedMeasureWrapper) {
        super(parentShell);
        this.mode = calculatedMeasureWrapper == null ? 1 : 2;
        this.calculatedMeasureProperties = calculatedMeasureProperties;
        this.calculatedMeasureWrapper = calculatedMeasureWrapper;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(1));
        this.setTitle(Activator.getLocalString("calculated.columns.dialog.title"));
        this.setMessage(Activator.getLocalString("calculated.columns.dialog.subtitle"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData gridData8 = new GridData(1808);
        gridData8.widthHint = 440;
        container.setLayoutData((Object)gridData8);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblColumnName = new Label(container, 0);
        lblColumnName.setForeground(ComponentsCommons.getColor((int)10));
        lblColumnName.setFont(ComponentsCommons.getFont((String)"Tahoma", (int)8, (int)1));
        GridData gridData9 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData9.widthHint = 125;
        lblColumnName.setLayoutData((Object)gridData9);
        lblColumnName.setText(Activator.getLocalString("label.column.name"));
        this.txtColumnName = new Text(container, 2048);
        GridData gridData10 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData10.widthHint = 241;
        this.txtColumnName.setLayoutData((Object)gridData10);
        Label lblFunction = new Label(container, 0);
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData.heightHint = 15;
        gridData.widthHint = 125;
        lblFunction.setLayoutData((Object)gridData);
        lblFunction.setFont(ComponentsCommons.getFont((String)"Tahoma", (int)8, (int)1));
        lblFunction.setForeground(ComponentsCommons.getColor((int)10));
        lblFunction.setText(Activator.getLocalString("label.function.first.upper"));
        if (Beans.isDesignTime()) {
            this.comboViewer = new ComboViewer(container, 8);
        } else {
            this.comboViewer = (ComboViewer)FunctionsViewerFactory.instance((Composite)container, (int)2056, (String)Activator.getLanguage()).getViewer(ComboViewer.class);
            this.comboViewer.setSelection((ISelection)new StructuredSelection(this.comboViewer.getElementAt(0)));
            this.comboViewer.addSelectionChangedListener(event -> {
                this.functionParametersPanel.setVisible(false);
                this.functionParametersPanel.dispose();
                Function selection = (Function)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement();
                this.txtFunctionDescription.setText(selection.getDescription().getValue(Activator.getLanguage()));
                this.functionParametersPanel = this.calculatedMeasureWrapper != null && selection.equals(this.calculatedMeasureWrapper.getMeasure().getFunction()) ? new FunctionParametersPanel((Composite)this.grpFunctionParameters, 0, this.calculatedMeasureWrapper.getExtraParameters()) : new FunctionParametersPanel((Composite)this.grpFunctionParameters, 0, selection);
                this.grpFunctionParameters.layout(true);
                if (this.mode == 1) {
                    this.txtColumnName.setText(this.disambiguateColumnName((Function)this.comboViewer.getElementAt(this.combo.getSelectionIndex())));
                }
            });
        }
        this.combo = this.comboViewer.getCombo();
        GridData gridData7 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData7.widthHint = 216;
        this.combo.setLayoutData((Object)gridData7);
        new Label(container, 0);
        this.txtFunctionDescription = new Text(container, 2632);
        this.txtFunctionDescription.setEditable(false);
        GridData gtTxtFunctionDescription = new GridData(4, 0x1000000, true, false, 1, 1);
        gtTxtFunctionDescription.heightHint = 140;
        this.txtFunctionDescription.setLayoutData((Object)gtTxtFunctionDescription);
        Group grpParameters = new Group(container, 0);
        grpParameters.setForeground(ComponentsCommons.getColor((int)10));
        grpParameters.setText(Activator.getLocalString("label.parameters.first.upper"));
        GridData gridData6 = new GridData(4, 4, false, true, 2, 1);
        gridData6.widthHint = 484;
        gridData6.heightHint = 116;
        grpParameters.setLayoutData((Object)gridData6);
        grpParameters.setLayout((Layout)new GridLayout(4, false));
        this.skipParametersPanel = new FunctionSkipParameters((Composite)grpParameters, 0);
        new Label((Composite)grpParameters, 0);
        this.grpFunctionParameters = new Group((Composite)grpParameters, 0);
        this.grpFunctionParameters.setText(Activator.getLocalString("label.function.parameters"));
        this.grpFunctionParameters.setLayout((Layout)new FillLayout(512));
        GridData gdParametersGroup = new GridData(4, 4, true, true, 1, 1);
        gdParametersGroup.heightHint = 116;
        this.grpFunctionParameters.setLayoutData((Object)gdParametersGroup);
        Function selection = (Function)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement();
        this.txtFunctionDescription.setText(selection.getDescription().getValue(Activator.getLanguage()));
        this.functionParametersPanel = this.calculatedMeasureWrapper != null && this.calculatedMeasureWrapper.getExtraParameters() != null ? new FunctionParametersPanel((Composite)this.grpFunctionParameters, 0, this.calculatedMeasureWrapper.getExtraParameters()) : new FunctionParametersPanel((Composite)this.grpFunctionParameters, 0, selection);
        this.txtColumnName.setEnabled(this.mode == 1);
        if (this.mode == 1) {
            this.txtColumnName.setText(this.disambiguateColumnName((Function)this.comboViewer.getElementAt(this.combo.getSelectionIndex())));
        }
        if (this.mode == 2) {
            this.syncroPanel();
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return Activator.windowsScaling(630, 600);
    }

    protected void syncroPanel() {
        Map params;
        CalculatedMeasureDefinition definition = this.calculatedMeasureWrapper.getMeasure();
        this.txtColumnName.setText(definition.getName());
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object[])new Function[]{definition.getFunction()}));
        this.txtFunctionDescription.setText(((Function)new StructuredSelection((Object[])new Function[]{definition.getFunction()}).getFirstElement()).getDescription().getValue(Activator.getLanguage()));
        Set skipStatus = definition.getSkipStatus();
        if (skipStatus != null) {
            this.skipParametersPanel.setValue(0, skipStatus.contains(FAOMeasureStatus.MISSING));
            this.skipParametersPanel.setValue(1, skipStatus.contains(FAOMeasureStatus.ESTIMATE));
            this.skipParametersPanel.setValue(2, skipStatus.contains(FAOMeasureStatus.ESTIMATE));
            this.skipParametersPanel.setValue(3, skipStatus.contains(FAOMeasureStatus.ZERO));
        }
        if ((params = definition.getParameters()) == null) {
            this.functionParametersPanel.setVisible(false);
        } else {
            this.functionParametersPanel.setVisible(true);
            this.functionParametersPanel.syncroPanel();
        }
    }

    protected boolean chkData() {
        if (this.mode == 1) {
            if (this.txtColumnName.getText() == null || this.txtColumnName.getText().equals("")) {
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 33);
                messageBox.setMessage(Activator.getLocalString("message.error.function.column.cannot.empty"));
                messageBox.open();
                this.txtColumnName.setFocus();
                return false;
            }
            if (this.txtColumnName.getText() != null && !this.txtColumnName.getText().equals("") && this.calculatedMeasureProperties.isUsedName(this.txtColumnName.getText())) {
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 33);
                messageBox.setMessage(Activator.getLocalString("message.error.function.column.already.used"));
                messageBox.open();
                this.txtColumnName.setFocus();
                return false;
            }
        }
        if (!this.functionParametersPanel.isAllValid()) {
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 33);
            messageBox.setMessage(Activator.getLocalString("message.error.function.column.invalid.param"));
            messageBox.open();
            return false;
        }
        return true;
    }

    protected void applyData() {
        if (this.mode == 1) {
            this.calculatedMeasureWrapper = new CalculatedMeasureDefinitionWrapper(this.calculatedMeasureProperties, CalculatedMeasureDefinitionFactory.create((String)this.txtColumnName.getText()));
        }
        this.calculatedMeasureWrapper.getMeasure().setFunction((Function)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement());
        HashSet<MeasureStatus> skipStatus = new HashSet<MeasureStatus>();
        if (this.skipParametersPanel.getValue(0)) {
            skipStatus.add(FAOMeasureStatus.MISSING);
        }
        if (this.skipParametersPanel.getValue(1)) {
            skipStatus.add(FAOMeasureStatus.ESTIMATE);
        }
        if (this.skipParametersPanel.getValue(2)) {
            skipStatus.add(FAOMeasureStatus.ESTIMATE);
        }
        if (this.skipParametersPanel.getValue(3)) {
            skipStatus.add(FAOMeasureStatus.ZERO);
        }
        this.calculatedMeasureWrapper.getMeasure().setSkipStatus(skipStatus);
        if (!this.functionParametersPanel.isDisposed()) {
            this.functionParametersPanel.applyData();
            HashMap<Parameter, String> parameterMap = new HashMap<Parameter, String>();
            ParameterWrapper[] parameterWrapperArray = this.functionParametersPanel.getParameterWrappers();
            int n = parameterWrapperArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterWrapper wr = parameterWrapperArray[n2];
                parameterMap.put(wr.getParameter(), wr.getValue());
                ++n2;
            }
            this.calculatedMeasureWrapper.getMeasure().setParameters(parameterMap);
        }
        if (this.mode == 1) {
            this.calculatedMeasureProperties.addMeasureDefinition(this.calculatedMeasureWrapper);
        }
        this.calculatedMeasureProperties.setChanged();
        this.calculatedMeasureProperties.notifyObservers();
    }

    protected void setValidParams(boolean valid) {
        this.getButton(0).setEnabled(valid);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.chkData()) {
                this.applyData();
                this.calculatedMeasureProperties.getTimeSeriesProperties().getDatasetProperties().addAction(new Integer[]{33});
                this.calculatedMeasureProperties.notifyObservers();
                super.buttonPressed(buttonId);
            }
        } else if (buttonId == 1) {
            super.buttonPressed(buttonId);
        }
    }

    private String disambiguateColumnName(Function function) {
        String colName = CoreUtils.getCurrentLang((MultilingualString)function.getName(), (String)Activator.getLanguage());
        while (this.calculatedMeasureProperties.isUsedName(colName)) {
            colName = String.valueOf(colName) + "_1";
        }
        return colName;
    }

    protected boolean isResizable() {
        return true;
    }
}

