/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.columns.dimensions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.properties.dataset.ConceptNameDescriptorTableViewer;
import org.fao.fi.fishstat.gui.properties.dataset.DimensionEditorDialog;

public class DimensionDisplayComposite
extends Composite {
    private DimensionProperties dimensionProperties;
    private ConceptNameDescriptorTableViewer tbwDimensionDescriptor;

    public DimensionDisplayComposite(Composite parent, int style, DimensionProperties p) {
        super(parent, style);
        this.dimensionProperties = p;
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.verticalIndent = 10;
        parent.setLayoutData((Object)layoutData);
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 10;
        this.setLayout((Layout)gridLayout);
        Label slbDimension = new Label((Composite)this, 0);
        slbDimension.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
        slbDimension.setFont(ComponentsCommons.getFont((String)"", (int)10, (int)1));
        slbDimension.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        GridData gridData2 = new GridData(4, 4, false, false, 1, 1);
        gridData2.horizontalAlignment = 4;
        gridData2.horizontalSpan = 2;
        slbDimension.setLayoutData((Object)gridData2);
        slbDimension.setText(String.valueOf(Activator.getPluginBundle().getString("label.dimension.first.upper")) + ":  " + CoreUtils.getCurrentLangName((Object)this.dimensionProperties.getDimension(), (String)Activator.getLanguage()));
        this.tbwDimensionDescriptor = new ConceptNameDescriptorTableViewer(this, 0x10010800, this.dimensionProperties, "Dimensions");
        Table table = this.tbwDimensionDescriptor.getTable();
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        table.setLayoutData((Object)gridData);
        this.tbwDimensionDescriptor.addDoubleClickListener(event -> {
            ConceptProperties dcp = (ConceptProperties)((IStructuredSelection)this.tbwDimensionDescriptor.getSelection()).getFirstElement();
            new DimensionEditorDialog(this.getShell(), this.dimensionProperties, dcp, true).open();
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gdComposite = new GridData(4, 4, false, true);
        composite.setLayoutData((Object)gdComposite);
        Button newButton = new Button(composite, 0);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new DimensionEditorDialog(DimensionDisplayComposite.this.getShell(), DimensionDisplayComposite.this.dimensionProperties, null, true).open();
            }
        });
        GridData gdNewButton = new GridData(4, 4, false, true);
        gdNewButton.horizontalIndent = 10;
        gdNewButton.verticalIndent = 5;
        newButton.setLayoutData((Object)gdNewButton);
        newButton.setText(Activator.getPluginBundle().getString("label.new.first.upper.dots"));
        Button editButton = new Button(composite, 0);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConceptProperties dcp = (ConceptProperties)((IStructuredSelection)DimensionDisplayComposite.this.tbwDimensionDescriptor.getSelection()).getFirstElement();
                if (dcp == null) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getPluginBundle().getString("label.empty.selection"), (String)Activator.getPluginBundle().getString("columns.dimensions.preference.page.empty.selection.warning.message"));
                } else {
                    new DimensionEditorDialog(DimensionDisplayComposite.this.getShell(), DimensionDisplayComposite.this.dimensionProperties, dcp, true).open();
                }
            }
        });
        GridData gdEditButton = new GridData(4, 4, false, true);
        gdEditButton.horizontalIndent = 10;
        gdEditButton.verticalIndent = 5;
        editButton.setLayoutData((Object)gdNewButton);
        editButton.setText(Activator.getPluginBundle().getString("label.edit.first.upper.dots"));
        Button removeButton = new Button(composite, 0);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = DimensionDisplayComposite.this.tbwDimensionDescriptor.getTable().getSelectionIndex();
                if (idx != -1) {
                    DimensionDisplayComposite.this.dimensionProperties.removeDescriptor(idx);
                    DimensionDisplayComposite.this.dimensionProperties.notifyObservers();
                }
            }
        });
        GridData gdRemoveButton = new GridData(4, 4, false, true);
        gdRemoveButton.horizontalIndent = 10;
        gdRemoveButton.verticalIndent = 5;
        removeButton.setLayoutData((Object)gdRemoveButton);
        removeButton.setText(Activator.getPluginBundle().getString("label.remove.first.upper.dots"));
    }
}

