/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views;

import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.gui.Activator;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.util.PropertiesManager;

public class PDFviewerComposite
extends Composite {
    private SwingController pdfController;
    private JPanel viewerComponentPanel;
    private boolean initialized = false;

    public PDFviewerComposite(Composite parent, int style) {
        super(parent, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)this);
        this.pdfController = new SwingController();
        Properties icepdfDefaults = new Properties();
        icepdfDefaults.setProperty("application.toolbar.show.annotation", "false");
        icepdfDefaults.setProperty("application.toolbar.show.fit", "false");
        icepdfDefaults.setProperty("application.toolbar.show.forms", "false");
        icepdfDefaults.setProperty("application.toolbar.show.rotate", "false");
        icepdfDefaults.setProperty("application.toolbar.show.tool", "false");
        icepdfDefaults.setProperty("application.statusbar", "false");
        icepdfDefaults.setProperty("application.statusbar.show.viewmode.singlePage", "false");
        icepdfDefaults.setProperty("application.statusbar.show.viewmode.singlePageContinuous", "true");
        icepdfDefaults.setProperty("application.statusbar.show.viewmode.doublePage", "false");
        icepdfDefaults.setProperty("application.statusbar.show.viewmode.doublePageContinuous", "false");
        icepdfDefaults.setProperty("application.toolbar.show.utility.save", "true");
        icepdfDefaults.setProperty("application.toolbar.show.utility.print", "true");
        icepdfDefaults.setProperty("application.toolbar.show.utility.search", "true");
        icepdfDefaults.setProperty("application.toolbar.show.utility.open", "false");
        icepdfDefaults.setProperty("application.showLocalStorageDialogs", "false");
        PropertiesManager pman = new PropertiesManager(System.getProperties(), icepdfDefaults, ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
        SwingViewBuilder factory = new SwingViewBuilder(this.pdfController, pman);
        this.pdfController.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(this.pdfController.getDocumentViewController()));
        this.viewerComponentPanel = factory.buildViewerPanel();
        frame.add(this.viewerComponentPanel);
        frame.pack();
        frame.setVisible(true);
        ComponentKeyBinding.install((SwingController)this.pdfController, (JComponent)this.viewerComponentPanel);
    }

    public void openPDFdocument(final String filePath) {
        if (this.pdfController == null) {
            return;
        }
        Job job = new Job("Opening PDF file " + filePath){

            protected IStatus run(IProgressMonitor monitor) {
                PDFviewerComposite.this.pdfController.openDocument(filePath);
                PDFviewerComposite.this.pdfController.setDocumentToolMode(4);
                PDFviewerComposite.this.pdfController.setPageViewMode(2, true);
                PDFviewerComposite.this.initialized = true;
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public boolean setFocus() {
        return this.initialized;
    }

    protected void textExtraction(Document doc, int pagNumber) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter fileWriter = new FileWriter(new File("C:\\PDF Extracted text\\Page" + (pagNumber + 1) + ".txt"));){
                PageText pageText = doc.getPageText(pagNumber);
                if (pageText != null && pageText.getPageLines() != null) {
                    fileWriter.write(pageText.toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "writing to file", (Throwable)ex));
        }
    }
}

