/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.workspaces;

import java.beans.Beans;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.workspaces.WorkspacesInstaller;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationAdvisor;
import org.fao.fi.fishstat.gui.components.composites.WorkspaceMetadataPanel;
import org.fao.fi.fishstat.gui.components.widgets.WorkspacesTableViewer;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspaceWizard;

public class WorkspacesBrowserDialog
extends TitleAreaDialog {
    private WorkspacesTableViewer workSpacesTableViewer;
    private WorkspaceMetadataPanel workspaceMetadataPanel;
    private WorkspaceModel wsToDelete;
    private Button btnOpenWorkspace;
    private Button btnImportWorkspace;
    private Button btnDeleteWorkspace;
    private Button btnDownloadWorkspace;

    public WorkspacesBrowserDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Activator.getPluginBundle().getString("workspaces.management.dialog.title"));
        this.setMessage(Activator.getPluginBundle().getString("workspaces.management.dialog.subtitle"));
        WorkspacesManager workspacesManager = CoreCommons.getWorkspacesManager();
        parent.setBackground(SWTResourceManager.getColor(1));
        parent.setBackgroundMode(2);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackgroundMode(2);
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 128, false, false));
        if (Beans.isDesignTime()) {
            this.workSpacesTableViewer = (WorkspacesTableViewer)new Composite(container, 0);
            this.workSpacesTableViewer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        } else {
            this.workSpacesTableViewer = ApplicationAdvisor.getAutoUpdate() == null ? new WorkspacesTableViewer(workspacesManager, new ArrayList(), container, 65536, Activator.getLanguage()) : new WorkspacesTableViewer(workspacesManager, ApplicationAdvisor.getAutoUpdate().getAutoupdateWorkspaces(), container, 65536, Activator.getLanguage());
        }
        Table workSpacesTable = this.workSpacesTableViewer.getTableViewer().getTable();
        workSpacesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspacesBrowserDialog.this.syncButtons((IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getTableViewer().getSelection());
            }
        });
        this.workSpacesTableViewer.getTableViewer().addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1) {
                if (selection.getFirstElement() instanceof WorkspaceModel) {
                    WorkspaceModel metadata = (WorkspaceModel)selection.getFirstElement();
                    this.openSelectedWorkspace(metadata);
                }
                if (selection.getFirstElement() instanceof AutoUpdateWks) {
                    this.downloadWorkspace(selection);
                }
            }
        });
        workSpacesTable.setForeground(SWTResourceManager.getColor(25, 25, 112));
        workSpacesTable.setHeaderVisible(true);
        workSpacesTable.setBackground(SWTResourceManager.getColor(248, 251, 255));
        GridData gdTable = new GridData(16384, 4, true, false, 1, 1);
        workSpacesTable.setLayoutData((Object)gdTable);
        Composite composite = new Composite(container, 0);
        RowLayout rl_composite = new RowLayout(512);
        rl_composite.marginBottom = 7;
        rl_composite.marginTop = 7;
        rl_composite.marginRight = 10;
        rl_composite.marginLeft = 10;
        rl_composite.spacing = 5;
        composite.setLayout((Layout)rl_composite);
        composite.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        this.btnDownloadWorkspace = new Button(composite, 0);
        this.btnDownloadWorkspace.setText(Activator.getPluginBundle().getString("workspaces.management.dialog.button.download"));
        this.btnDownloadWorkspace.setLayoutData((Object)new RowData(100, -1));
        this.btnDownloadWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspacesBrowserDialog.this.downloadWorkspace((IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getTableViewer().getSelection());
            }
        });
        this.btnOpenWorkspace = new Button(composite, 0);
        this.btnOpenWorkspace.setText(Activator.getPluginBundle().getString("workspaces.management.dialog.button.open"));
        this.btnOpenWorkspace.setLayoutData((Object)new RowData(100, -1));
        this.btnOpenWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                if (!WorkspacesBrowserDialog.this.workSpacesTableViewer.getTableViewer().getSelection().isEmpty() && (selection = (IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getTableViewer().getSelection()).size() == 1) {
                    WorkspacesBrowserDialog.this.openSelectedWorkspace((WorkspaceModel)selection.getFirstElement());
                }
            }
        });
        this.btnDeleteWorkspace = new Button(composite, 0);
        this.btnDeleteWorkspace.setText(Activator.getPluginBundle().getString("workspaces.management.dialog.button.delete"));
        this.btnDeleteWorkspace.setLayoutData((Object)new RowData(100, -1));
        this.btnDeleteWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                if (!WorkspacesBrowserDialog.this.workSpacesTableViewer.getTableViewer().getSelection().isEmpty() && (selection = (IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getTableViewer().getSelection()).size() == 1) {
                    WorkspacesBrowserDialog.this.wsToDelete = (WorkspaceModel)selection.getFirstElement();
                    try {
                        MessageDialog dlgUpdateFWS = new MessageDialog(Display.getCurrent().getActiveShell(), Activator.getPluginBundle().getString("workspaces.management.dialog.remove.title"), null, MessageFormat.format(Activator.getPluginBundle().getString("workspaces.management.dialog.remove.message"), WorkspacesBrowserDialog.this.wsToDelete.getName(Activator.getLanguage()), WorkspacesBrowserDialog.this.wsToDelete.getVersion().toString()), 3, new String[]{Activator.getPluginBundle().getString("workspaces.management.dialog.ask.delete"), Activator.getPluginBundle().getString("workspaces.management.dialog.ask.cancel")}, 0);
                        if (dlgUpdateFWS.open() == 0) {
                            WorkspacesBrowserDialog.this.setWsToDelete(WorkspacesBrowserDialog.this.wsToDelete);
                            WorkspacesInstaller installer = new WorkspacesInstaller(CoreCommons.getWorkspacesManager());
                            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), () -> installer.removeWorkspace(WorkspacesBrowserDialog.this.getWsToDelete()));
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.management.dialog.removed.title"), (String)MessageFormat.format(Activator.getPluginBundle().getString("workspaces.management.dialog.removed.message"), WorkspacesBrowserDialog.this.wsToDelete.getName(Activator.getLanguage())));
                            WorkspacesBrowserDialog.this.syncButtons(null);
                        }
                    }
                    catch (Exception e3) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "error deleting workspace", (Throwable)e3));
                    }
                }
            }
        });
        this.btnImportWorkspace = new Button(composite, 0);
        this.btnImportWorkspace.setText(Activator.getPluginBundle().getString("workspaces.management.dialog.button.import"));
        this.btnImportWorkspace.setLayoutData((Object)new RowData(100, -1));
        this.btnImportWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspacesBrowserDialog.this.importWorkspace();
            }
        });
        this.workspaceMetadataPanel = new WorkspaceMetadataPanel(container, 0, Activator.getLanguage());
        GridLayout gridLayout = (GridLayout)this.workspaceMetadataPanel.getLayout();
        gridLayout.horizontalSpacing = 12;
        gridLayout.marginWidth = 7;
        gridLayout.marginHeight = 5;
        this.workspaceMetadataPanel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        if (workspacesManager.getNumberOfWorkspaces() >= 1 || ApplicationAdvisor.getAutoUpdate() != null && !ApplicationAdvisor.getAutoUpdate().getAutoupdateWorkspaces().isEmpty()) {
            int defaultselection = this.getDefaultSelection();
            workSpacesTable.select(defaultselection);
            this.workspaceMetadataPanel.setMetadata(this.workSpacesTableViewer.getTableViewer().getElementAt(defaultselection));
            this.workspaceMetadataPanel.setVisible(true);
            this.syncButtons((IStructuredSelection)this.workSpacesTableViewer.getTableViewer().getSelection());
        } else {
            this.workspaceMetadataPanel.setVisible(false);
            this.syncButtons(null);
        }
        workSpacesTable.forceFocus();
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    private int getDefaultSelection() {
        int i = 0;
        while (i < 10) {
            Object element = this.workSpacesTableViewer.getTableViewer().getElementAt(i);
            if (element == null) {
                return 0;
            }
            if (element instanceof WorkspaceModel && ((WorkspaceModel)element).getAcronym().startsWith("FAO_FI_GLOBAL")) {
                return i;
            }
            if (element instanceof AutoUpdateWks && ((AutoUpdateWks)element).getAcronym().startsWith("FAO_FI_GLOBAL")) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackground(SWTResourceManager.getColor(1));
        newShell.setBackgroundMode(2);
        super.configureShell(newShell);
        newShell.setText(Activator.getPluginBundle().getString("workspaces.management.dialog.bartitle"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, JFaceResources.getString((String)IDialogConstants.CLOSE_LABEL), true);
    }

    protected Point getInitialSize() {
        return Activator.windowsScaling(600, 530);
    }

    public void openSelectedWorkspace(WorkspaceModel metadata) {
        this.setReturnCode(0);
        this.close();
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.fao.fi.fishstat.gui.dataset.switch.workspace.parameter.id", metadata.getWsBaseDir().getAbsolutePath());
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            Command cmd = commandService.getCommand("org.fao.fi.fishstat.gui.dynamic.switch.workspace");
            ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)cmd, parameters);
            handlerService.executeCommand(parameterizedCommand, null);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "error opening workspace", (Throwable)e));
        }
    }

    public void importWorkspace() {
        this.setReturnCode(0);
        this.close();
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        try {
            cmdService.getCommand("org.fao.fi.fishstat.gui.tools.import.workspace").getHandler().execute(new ExecutionEvent());
        }
        catch (ExecutionException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "error importing workspace", (Throwable)e1));
        }
    }

    public void downloadWorkspace(IStructuredSelection selection) {
        if (selection.size() == 1 && selection.getFirstElement() instanceof AutoUpdateWks) {
            this.setReturnCode(0);
            this.close();
            if (Display.getDefault().getActiveShell().isDisposed()) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "downloadWorkspace(): shell is disposed"));
            } else {
                InstallNewWorkspaceWizard wizard = new InstallNewWorkspaceWizard((AutoUpdateWks)selection.getFirstElement());
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.open();
            }
        }
    }

    public WorkspaceModel getWsToDelete() {
        return this.wsToDelete;
    }

    public void setWsToDelete(WorkspaceModel wsToDelete) {
        this.wsToDelete = wsToDelete;
    }

    public void syncButtons(IStructuredSelection selection) {
        if (selection == null) {
            this.btnOpenWorkspace.setEnabled(false);
            this.btnDeleteWorkspace.setEnabled(false);
            this.btnImportWorkspace.setEnabled(true);
            this.btnDownloadWorkspace.setEnabled(false);
            this.workspaceMetadataPanel.setMetadata(null);
            this.workspaceMetadataPanel.setVisible(false);
            return;
        }
        if (selection.size() == 1) {
            if (selection.getFirstElement() instanceof WorkspaceModel) {
                this.btnDownloadWorkspace.setEnabled(false);
                this.btnOpenWorkspace.setEnabled(true);
                this.btnImportWorkspace.setEnabled(true);
                this.btnDeleteWorkspace.setEnabled(true);
            }
            if (selection.getFirstElement() instanceof AutoUpdateWks) {
                this.btnOpenWorkspace.setEnabled(false);
                this.btnDeleteWorkspace.setEnabled(false);
                this.btnImportWorkspace.setEnabled(true);
                this.btnDownloadWorkspace.setEnabled(true);
            }
            this.workspaceMetadataPanel.setMetadata(selection.getFirstElement());
            this.workspaceMetadataPanel.setVisible(true);
        } else {
            this.workspaceMetadataPanel.setVisible(false);
        }
    }
}

