/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.management.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.daosupport.exceptions.DAOException;
import org.fao.fi.fishstat.data.common.api.exceptions.ReflectionException;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.common.ddlutils.DdlUtilsHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.impl.AttributeImpl;
import org.fao.fi.fishstat.data.reference.api.impl.ConceptImpl;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;
import org.fao.fi.fishstat.data.reference.api.impl.RelationshipImpl;
import org.fao.fi.fishstat.data.reference.api.management.ReferenceMetadataManagementService;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.AttributeDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.ConceptDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.RelationshipDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.exceptions.ReferenceManagementException;

public class ReferenceMetadataManagementServiceImpl
implements ReferenceMetadataManagementService {
    private static final String CUSTOM_GROUP_EN = "Custom groups";
    private static final String CUSTOM_GROUP_FR = "Groupes personnalis\u00e9s";
    private static final String CUSTOM_GROUP_ES = "Grupos personalizados";
    private static final Map<String, String> CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES = new HashMap<String, String>();
    private static final MultilingualString CUSTOM_GROUP_RELATIONSHIP_NAME;
    private static final Map<String, String> CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES;
    private static final MultilingualString CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION;

    static {
        CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES.put("en", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES.put("fr", CUSTOM_GROUP_FR);
        CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES.put("es", CUSTOM_GROUP_ES);
        CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES.put("ar", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES.put("zh", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES.put("ru", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_NAME = new MultilingualString(CUSTOM_GROUP_RELATIONSHIP_NAME_VALUES);
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES = new HashMap<String, String>();
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES.put("en", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES.put("fr", CUSTOM_GROUP_FR);
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES.put("es", CUSTOM_GROUP_ES);
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES.put("ar", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES.put("zh", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES.put("ru", CUSTOM_GROUP_EN);
        CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION = new MultilingualString(CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION_VALUES);
    }

    @Override
    public Concept createConcept(ConceptDescriptor descriptor) throws ReferenceManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Concept descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Concept acronym can not be null");
            }
            Concept existing = ReferenceServiceFactory.getService().getConcept(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Concept with acronym: " + descriptor.getAcronym() + " already exists: " + existing.getName());
            }
            Concept concept = this.addConceptEntry(descriptor);
            Relationship customGroupRelationship = null;
            try {
                customGroupRelationship = this.addCustomGroupRelationshipEntry(concept);
            }
            catch (Exception e) {
                this.removeConceptEntry(concept);
                throw new ReferenceManagementException("Unable to add default custom group relationship: " + e.getMessage(), e);
            }
            try {
                this.createConceptTables(concept);
            }
            catch (Exception e) {
                this.removeRelationshipEntry(customGroupRelationship);
                this.removeConceptEntry(concept);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to create concept tables: " + e.getMessage(), e);
            }
            return concept;
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new concept", e);
        }
    }

    private Relationship addCustomGroupRelationshipEntry(Concept concept) throws ReferenceManagementException {
        try {
            GenericDAO relationshipDAO = ReferenceServiceHelper.getRmdRelationshipDao();
            Class c = ReferenceServiceHelper.getRmdRelationshipDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object relationshipDTO = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(relationshipDTO, (String)relationshipDAO.generateId());
            Commons.setDTOAttribute(relationshipDTO, (String)"PARENT_ID", (Object)CustomGroupFactory.getConcept().getId().stringValue(), String.class);
            Commons.setDTOAttribute(relationshipDTO, (String)"CHILD_ID", (Object)concept.getId().stringValue(), String.class);
            Commons.setDTOAttribute(relationshipDTO, (String)"ACRONYM", (Object)("CUSTOM_GROUP_" + concept.getAcronym()), String.class);
            Commons.setMultilingualDTOAttribute(relationshipDTO, (String)"NAME", (MultilingualString)CUSTOM_GROUP_RELATIONSHIP_NAME);
            Commons.setMultilingualDTOAttribute(relationshipDTO, (String)"DESCRIPTION", (MultilingualString)CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION);
            relationshipDAO.insert(relationshipDTO);
            return new RelationshipImpl(relationshipDTO);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add default custom group relationship entry for: " + concept.getAcronym(), e);
        }
    }

    private Collection<Attribute> addAttributeEntries(Collection<AttributeDescriptor> attributeDescriptors) throws ReferenceManagementException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (AttributeDescriptor attribute_descriptor : attributeDescriptors) {
            attributes.add(this.addAttributeEntry(attribute_descriptor));
        }
        return attributes;
    }

    private Attribute addAttributeEntry(AttributeDescriptor descriptor) throws ReferenceManagementException {
        try {
            GenericDAO attributeDAO = ReferenceServiceHelper.getRmdAttributeDao();
            Class c = ReferenceServiceHelper.getRmdAttributeDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object attributeDTO = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(attributeDTO, (String)attributeDAO.generateId());
            Commons.setDTOAttribute(attributeDTO, (String)"ACRONYM", (Object)descriptor.getAcronym(), String.class);
            Commons.setDTOAttribute(attributeDTO, (String)"CONCEPT_ID", (Object)descriptor.getConceptId().stringValue(), String.class);
            Commons.setDTOAttribute(attributeDTO, (String)"CODE", (Object)(descriptor.isCodeAttribute() ? (short)1 : 0), Short.class);
            Commons.setDTOAttribute(attributeDTO, (String)"NAME", (Object)(descriptor.isNameAttribute() ? (short)1 : 0), Short.class);
            Commons.setDTOAttribute(attributeDTO, (String)"ATTRIBUTE_TYPE", (Object)descriptor.getType().toString(), String.class);
            Commons.setDTOAttribute(attributeDTO, (String)"ATTRIBUTE_SIZE", (Object)descriptor.getSize(), Short.class);
            Commons.setDTOAttribute(attributeDTO, (String)"ATTRIBUTE_SCALE", (Object)descriptor.getScale(), Short.class);
            Commons.setMultilingualDTOAttribute(attributeDTO, (String)"NAME", (MultilingualString)descriptor.getName());
            Commons.setMultilingualDTOAttribute(attributeDTO, (String)"DESCRIPTION", (MultilingualString)descriptor.getDescription());
            attributeDAO.insert(attributeDTO);
            return new AttributeImpl(attributeDTO);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add attribute entry for: " + descriptor.getAcronym(), e);
        }
    }

    private Concept addConceptEntry(ConceptDescriptor descriptor) throws ReferenceManagementException {
        try {
            GenericDAO conceptDAO = ReferenceServiceHelper.getRmdConceptDao();
            Class c = ReferenceServiceHelper.getRmdConceptDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object conceptDTO = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(conceptDTO, (String)conceptDAO.generateId());
            Commons.setDTOAttribute(conceptDTO, (String)"ACRONYM", (Object)descriptor.getAcronym(), String.class);
            Commons.setMultilingualDTOAttribute(conceptDTO, (String)"NAME", (MultilingualString)descriptor.getName());
            Commons.setMultilingualDTOAttribute(conceptDTO, (String)"DESCRIPTION", (MultilingualString)descriptor.getDescription());
            VersionHelper.setVersion(conceptDTO, (Version)descriptor.getVersion());
            Commons.setDTOAttribute(conceptDTO, (String)"SORT_ORDER", (Object)descriptor.getSortorder(), Integer.class);
            conceptDAO.insert(conceptDTO);
            return new ConceptImpl(conceptDTO);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add concept entry for: " + descriptor.getAcronym(), e);
        }
    }

    private void createConceptTables(Concept concept) throws ReferenceManagementException {
        try {
            Database model = DdlUtilsHelper.getDatabase();
            this.createReferenceObjectTable(concept.getAcronym(), model);
            this.createCustomGroupRelationshipTable(concept, model);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create reference tables for: " + concept.getAcronym(), e);
        }
    }

    private void createReferenceObjectTable(String conceptAcronym, Database model) throws ReferenceManagementException {
        try {
            Table table = new Table();
            table.setSchema("FISHSTAT");
            table.setName("REF_" + conceptAcronym.toUpperCase(Locale.ENGLISH));
            Column id = new Column();
            id.setName("ID");
            id.setTypeCode(AttributeType.STRING.getJdbcType());
            id.setSize(String.valueOf(20));
            id.setPrimaryKey(true);
            table.addColumn(id);
            model.addTable(table);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create reference objects table for: " + conceptAcronym, e);
        }
    }

    private void createCustomGroupRelationshipTable(Concept concept, Database model) throws ReferenceManagementException {
        try {
            Concept customGroup = ReferenceServiceFactory.getService().getConcept("CUSTOM_GROUP");
            RelationshipDescriptor relationshipDescriptor = DescriptorsFactory.createRelationshipDescriptor("CUSTOM_GROUP_" + concept.getAcronym(), CUSTOM_GROUP_RELATIONSHIP_NAME, CUSTOM_GROUP_RELATIONSHIP_DESCRIPTION, customGroup.getId(), concept.getId(), null, null);
            this.createRelationshipTable(relationshipDescriptor.getAcronym(), customGroup, concept, model);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create custom group relationship table for: " + concept.getAcronym(), e);
        }
    }

    private void createRelationshipTable(String relationshipAcronym, Concept parent, Concept child, Database model) throws ReferenceManagementException {
        try {
            Table table = new Table();
            table.setSchema("FISHSTAT");
            table.setName("REL_" + relationshipAcronym.toUpperCase(Locale.ENGLISH));
            Column id = new Column();
            id.setName("ID");
            id.setTypeCode(AttributeType.STRING.getJdbcType());
            id.setSize(String.valueOf(20));
            id.setPrimaryKey(true);
            Column parentID = new Column();
            parentID.setName("PARENT_ID");
            parentID.setTypeCode(AttributeType.STRING.getJdbcType());
            parentID.setSize(String.valueOf(20));
            Column childID = new Column();
            childID.setName("CHILD_ID");
            childID.setTypeCode(AttributeType.STRING.getJdbcType());
            childID.setSize(String.valueOf(20));
            table.addColumns(Arrays.asList(id, parentID, childID));
            Table parenTable = model.findTable("REF_" + parent.getAcronym().toUpperCase(Locale.ENGLISH));
            Column parentTableID = parenTable.findColumn("ID");
            Table childTable = model.findTable("REF_" + child.getAcronym().toUpperCase(Locale.ENGLISH));
            Column childTableID = childTable.findColumn("ID");
            Reference parentIDref = new Reference(parentID, parentTableID);
            ForeignKey parentIDfk = new ForeignKey(String.valueOf(table.getName()) + "_PARENT_FK");
            parentIDfk.setForeignTable(parenTable);
            parentIDfk.addReference(parentIDref);
            parentIDfk.setAutoIndexPresent(true);
            parentIDfk.setOnDelete(CascadeActionEnum.CASCADE);
            parentIDfk.setOnUpdate(CascadeActionEnum.CASCADE);
            Reference childIDref = new Reference(childID, childTableID);
            ForeignKey childIDfk = new ForeignKey(String.valueOf(table.getName()) + "_CHILD_FK");
            childIDfk.setForeignTable(childTable);
            childIDfk.addReference(childIDref);
            childIDfk.setAutoIndexPresent(true);
            childIDfk.setOnDelete(CascadeActionEnum.CASCADE);
            childIDfk.setOnUpdate(CascadeActionEnum.CASCADE);
            table.addForeignKeys(Arrays.asList(parentIDfk, childIDfk));
            IndexColumn parentIDidxColumn = new IndexColumn(parentID);
            IndexColumn childIDidxColumn = new IndexColumn(childID);
            NonUniqueIndex parentChildIDidx = new NonUniqueIndex();
            parentChildIDidx.setName(String.valueOf(table.getName()) + "_IDX");
            parentChildIDidx.addColumn(parentIDidxColumn);
            parentChildIDidx.addColumn(childIDidxColumn);
            table.addIndex((Index)parentChildIDidx);
            model.addTable(table);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to create reference relationship table for: " + relationshipAcronym, e);
        }
    }

    @Override
    public Relationship createRelationship(RelationshipDescriptor descriptor) throws ReferenceManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Relationship descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Relationship acronym can not be null");
            }
            Concept parent = ReferenceServiceFactory.getService().getConcept(descriptor.getParentConceptId());
            Concept child = ReferenceServiceFactory.getService().getConcept(descriptor.getChildConceptId());
            if (parent == null || child == null) {
                throw new IllegalArgumentException("Relationship parent/child can not be null");
            }
            Relationship existing = ReferenceServiceFactory.getService().getRelationship(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Relationship with acronym: " + descriptor.getAcronym() + " already exists: " + existing.getName());
            }
            Relationship relationship = this.addRelationshipEntry(descriptor);
            try {
                Database model = DdlUtilsHelper.getDatabase();
                this.createRelationshipTable(descriptor.getAcronym(), parent, child, model);
                DdlUtilsHelper.alterDatabase((Database)model);
                DdlUtilsHelper.reloadDatabase();
                RegistryFactory.getRegistry((Object)parent).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                RegistryFactory.getRegistry((Object)child).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.RELATIONSHIP_CHANGE);
            }
            catch (Exception e) {
                this.removeRelationshipEntry(relationship);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to create reference relationship for: " + descriptor.getAcronym(), e);
            }
            return relationship;
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new relationship", e);
        }
    }

    private Relationship addRelationshipEntry(RelationshipDescriptor descriptor) throws ReferenceManagementException {
        try {
            GenericDAO relationshipDAO = ReferenceServiceHelper.getRmdRelationshipDao();
            Class c = ReferenceServiceHelper.getRmdRelationshipDTOClass();
            Constructor constructor = c.getConstructor(new Class[0]);
            Object relationshipDTO = constructor.newInstance(new Object[0]);
            Commons.setDTOIdentifier(relationshipDTO, (String)relationshipDAO.generateId());
            Commons.setDTOAttribute(relationshipDTO, (String)"ACRONYM", (Object)descriptor.getAcronym(), String.class);
            Commons.setMultilingualDTOAttribute(relationshipDTO, (String)"NAME", (MultilingualString)descriptor.getName());
            Commons.setMultilingualDTOAttribute(relationshipDTO, (String)"DESCRIPTION", (MultilingualString)descriptor.getDescription());
            Commons.setDTOAttribute(relationshipDTO, (String)"SORT_ORDER", (Object)descriptor.getSortorder(), Integer.class);
            Commons.setDTOAttribute(relationshipDTO, (String)"PARENT_ID", (Object)descriptor.getParentConceptId().stringValue(), String.class);
            Commons.setDTOAttribute(relationshipDTO, (String)"CHILD_ID", (Object)descriptor.getChildConceptId().stringValue(), String.class);
            VersionHelper.setVersion(relationshipDTO, (Version)descriptor.getVersion());
            relationshipDAO.insert(relationshipDTO);
            return new RelationshipImpl(relationshipDTO);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to add relationship entry for: " + descriptor.getAcronym(), e);
        }
    }

    @Override
    public Attribute createAttribute(AttributeDescriptor descriptor) throws ReferenceManagementException {
        try {
            if (descriptor == null) {
                throw new IllegalArgumentException("Attribute descriptor can not be null");
            }
            if (descriptor.getAcronym() == null) {
                throw new IllegalArgumentException("Attribute acronym can not be null");
            }
            if (descriptor.getType() == null) {
                throw new IllegalArgumentException("Attribute type can not be null");
            }
            if (descriptor.getConceptId() == null) {
                throw new IllegalArgumentException("Concept can not be null");
            }
            if ((descriptor.getType().equals((Object)AttributeType.STRING) || descriptor.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) && descriptor.getSize() <= 0) {
                throw new IllegalArgumentException("Positive size must be specified");
            }
            Concept concept = ReferenceServiceFactory.getService().getConcept(descriptor.getConceptId());
            if (concept == null) {
                throw new IllegalArgumentException("Concept can not be found");
            }
            Attribute existing = concept.getAttribute(descriptor.getAcronym());
            if (existing != null) {
                throw new IllegalArgumentException("Concept attribute with acronym: " + descriptor.getAcronym() + " already defined: " + existing.getName());
            }
            Attribute attribute = this.addAttributeEntry(descriptor);
            try {
                Database model = DdlUtilsHelper.getDatabase();
                this.addAttributeColumn(model, descriptor, concept.getAcronym());
                DdlUtilsHelper.alterDatabase((Database)model);
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE);
            }
            catch (Exception e) {
                this.removeAttributeEntry(attribute);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to add attribute column: " + e.getLocalizedMessage(), e);
            }
            return attribute;
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new attribute", e);
        }
    }

    @Override
    public void createAttributes(Set<AttributeDescriptor> descriptors) throws ReferenceManagementException {
        try {
            Database model = DdlUtilsHelper.getDatabase();
            for (AttributeDescriptor descriptor : descriptors) {
                if (descriptor == null) {
                    throw new IllegalArgumentException("Attribute descriptor can not be null");
                }
                if (descriptor.getAcronym() == null) {
                    throw new IllegalArgumentException("Attribute acronym can not be null");
                }
                if (descriptor.getType() == null) {
                    throw new IllegalArgumentException("Attribute type can not be null");
                }
                if (descriptor.getConceptId() == null) {
                    throw new IllegalArgumentException("Concept can not be null");
                }
                if ((descriptor.getType().equals((Object)AttributeType.STRING) || descriptor.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) && descriptor.getSize() <= 0) {
                    throw new IllegalArgumentException("Positive size must be specified");
                }
                Concept concept = ReferenceServiceFactory.getService().getConcept(descriptor.getConceptId());
                if (concept == null) {
                    throw new IllegalArgumentException("Concept can not be found");
                }
                Attribute existing = concept.getAttribute(descriptor.getAcronym());
                if (existing != null) {
                    throw new IllegalArgumentException("Concept attribute with acronym: " + descriptor.getAcronym() + " already defined: " + existing.getName());
                }
                Attribute attribute = this.addAttributeEntry(descriptor);
                try {
                    this.addAttributeColumn(model, descriptor, concept.getAcronym());
                    RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                    RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE);
                }
                catch (Exception e) {
                    this.removeAttributeEntry(attribute);
                    DdlUtilsHelper.reloadDatabase();
                    throw new ReferenceManagementException("Unable to add attribute column: " + e.getLocalizedMessage(), e);
                }
            }
            DdlUtilsHelper.alterDatabase((Database)model);
            DdlUtilsHelper.reloadDatabase();
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Exception caught creating a new attribute", e);
        }
    }

    private ConceptDescriptor removeConceptEntry(Concept concept) throws DAOException, ReflectionException {
        ConceptDescriptor removed = DescriptorsFactory.createConceptDescriptor(concept);
        GenericDAO conceptDAO = ReferenceServiceHelper.getRmdConceptDao();
        Object conceptDTO = conceptDAO.findById(concept.getId().stringValue());
        conceptDAO.delete(Commons.getDTOPk((Object)conceptDTO));
        return removed;
    }

    private Collection<AttributeDescriptor> removeConceptAttributeEntries(Concept concept) throws DAOException, ReflectionException {
        ArrayList<AttributeDescriptor> removed = new ArrayList<AttributeDescriptor>();
        for (Attribute attribute : concept.getAttributes()) {
            if (attribute.getAcronym().equals("ID")) continue;
            removed.add(this.removeAttributeEntry(attribute));
        }
        return removed;
    }

    private RelationshipDescriptor removeRelationshipEntry(Relationship relationship) throws DAOException, ReflectionException {
        RelationshipDescriptor descriptor = DescriptorsFactory.createRelationshipDescriptor(relationship);
        GenericDAO relationshipDAO = ReferenceServiceHelper.getRmdRelationshipDao();
        Object relationshipDTO = relationshipDAO.findById(relationship.getId().stringValue());
        relationshipDAO.delete(Commons.getDTOPk((Object)relationshipDTO));
        return descriptor;
    }

    private void removeConceptReferenceTable(String conceptAcronym, Database model) {
        Table table = model.findTable("REF_" + conceptAcronym);
        model.removeTable(table);
    }

    @Override
    public void removeAttribute(Attribute attribute) throws ReferenceManagementException {
        try {
            if (attribute == null) {
                throw new IllegalArgumentException("Attribute can not be null");
            }
            if (attribute.getAcronym().equals("ID")) {
                throw new IllegalArgumentException("Can not remove ID attribute");
            }
            Concept concept = attribute.getConcept();
            AttributeDescriptor descriptor = this.removeAttributeEntry(attribute);
            try {
                this.removeAttributeColumn(concept.getAcronym(), descriptor.getAcronym());
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
                RegistryFactory.getRegistry((Object)concept).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.REFERENCE_OBJECT_CHANGE);
            }
            catch (Exception e) {
                this.addAttributeEntry(descriptor);
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to remove attribute column: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to remove reference attribute: " + attribute, e);
        }
    }

    private void removeAttributeColumn(String conceptAcronym, String attributeAcronym) throws Exception {
        Database model = DdlUtilsHelper.getDatabase();
        Table table = model.findTable("REF_" + conceptAcronym);
        Column toBeRemoved = table.findColumn(attributeAcronym);
        if (toBeRemoved != null) {
            List<Index> indices = Arrays.asList(table.getIndices());
            for (Index index : indices) {
                if (!index.hasColumn(toBeRemoved)) continue;
                table.removeIndex(index);
            }
            table.removeColumn(toBeRemoved);
            DdlUtilsHelper.alterDatabase((Database)model);
        }
    }

    private void addAttributeColumn(Database model, AttributeDescriptor descriptor, String conceptAcronym) {
        Table table = model.findTable("REF_" + conceptAcronym, false);
        if (table != null) {
            ArrayList<UniqueIndex> indices = new ArrayList<UniqueIndex>();
            if (descriptor.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                for (String language : MultilingualString.LANGUAGES) {
                    Column column = new Column();
                    column.setName(String.valueOf(descriptor.getAcronym().toUpperCase(Locale.ENGLISH)) + "_" + language.toUpperCase(Locale.ENGLISH));
                    column.setDescription(descriptor.getDescription().getValue(language));
                    column.setTypeCode(descriptor.getType().getJdbcType());
                    column.setSize(descriptor.getSize() == 0 ? null : String.valueOf(descriptor.getSize()));
                    column.setScale((int)descriptor.getScale());
                    table.addColumn(column);
                }
            } else {
                Column column = new Column();
                column.setName(descriptor.getAcronym().toUpperCase(Locale.ENGLISH));
                column.setDescription(descriptor.getDescription().getValue("en"));
                column.setTypeCode(descriptor.getType().getJdbcType());
                column.setSize(descriptor.getSize() == 0 ? null : String.valueOf(descriptor.getSize()));
                column.setScale((int)descriptor.getScale());
                if (descriptor.isCodeAttribute()) {
                    UniqueIndex index = new UniqueIndex();
                    index.setName("UNQ_" + table.getName() + "_" + column.getName());
                    IndexColumn indexColumn = new IndexColumn(column);
                    index.addColumn(indexColumn);
                    indices.add(index);
                }
                table.addColumn(column);
            }
            if (!indices.isEmpty()) {
                table.addIndices(indices);
            }
        }
    }

    private AttributeDescriptor removeAttributeEntry(Attribute attribute) throws DAOException, ReflectionException {
        AttributeDescriptor removed = DescriptorsFactory.createAttributeDescriptor(attribute);
        GenericDAO attributeDAO = ReferenceServiceHelper.getRmdAttributeDao();
        Object attributeDTO = attributeDAO.findById(attribute.getId().stringValue());
        attributeDAO.delete(Commons.getDTOPk((Object)attributeDTO));
        return removed;
    }

    @Override
    public void removeConcept(Concept concept) throws ReferenceManagementException {
        try {
            if (concept == null) {
                throw new IllegalArgumentException("Concept can not be null");
            }
            Collection<RelationshipDescriptor> relationshipDescriptors = this.removeRelationshipEntries(concept.getRelationships());
            Collection<AttributeDescriptor> attributeDescriptors = null;
            try {
                attributeDescriptors = this.removeConceptAttributeEntries(concept);
            }
            catch (Exception e) {
                this.addRelationshipEntries(relationshipDescriptors);
                throw new ReferenceManagementException("Unable to remove concept attribute metadata entries: " + e.getMessage(), e);
            }
            ConceptDescriptor conceptDescriptor = null;
            try {
                conceptDescriptor = this.removeConceptEntry(concept);
            }
            catch (Exception e) {
                this.addRelationshipEntries(relationshipDescriptors);
                this.addAttributeEntries(attributeDescriptors);
                throw new ReferenceManagementException("Unable to remove concept metadata entry: " + e.getMessage(), e);
            }
            try {
                Database model = DdlUtilsHelper.getDatabase();
                for (RelationshipDescriptor relationship_descriptor : relationshipDescriptors) {
                    this.removeRelationshipTable(relationship_descriptor.getAcronym(), model);
                }
                this.removeConceptReferenceTable(conceptDescriptor.getAcronym(), model);
                DdlUtilsHelper.alterDatabase((Database)model);
            }
            catch (Exception e) {
                DdlUtilsHelper.reloadDatabase();
                throw new ReferenceManagementException("Unable to remove concept table(s): " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to remove reference concept: " + concept, e);
        }
    }

    private void addRelationshipEntries(Collection<RelationshipDescriptor> relationshipDescriptors) throws ReferenceManagementException {
        for (RelationshipDescriptor descriptor : relationshipDescriptors) {
            this.addRelationshipEntry(descriptor);
        }
    }

    private Collection<RelationshipDescriptor> removeRelationshipEntries(Collection<Relationship> relationships) throws DAOException, ReflectionException {
        ArrayList<RelationshipDescriptor> removed = new ArrayList<RelationshipDescriptor>();
        for (Relationship relationship : relationships) {
            removed.add(this.removeRelationshipEntry(relationship));
        }
        return removed;
    }

    @Override
    public void removeRelationship(Relationship relationship) throws ReferenceManagementException {
        try {
            if (relationship == null) {
                throw new IllegalArgumentException("Relationship can not be null");
            }
            Concept parent = relationship.getParentConcept();
            Concept child = relationship.getChildConcept();
            Database model = DdlUtilsHelper.getDatabase();
            this.removeRelationshipTable(relationship.getAcronym(), model);
            this.removeRelationshipEntry(relationship);
            DdlUtilsHelper.alterDatabase((Database)model);
            RegistryFactory.getRegistry((Object)parent).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.CONCEPT_CHANGE);
            RegistryFactory.getRegistry((Object)child).fireAndRegisterStructuralChangeEvent(StructuralChangeEvent.RELATIONSHIP_CHANGE);
        }
        catch (Exception e) {
            throw new ReferenceManagementException("Unable to remove relationship: " + relationship, e);
        }
    }

    private void removeRelationshipTable(String relationshipAcronym, Database model) {
        Table table = model.findTable("REL_" + relationshipAcronym);
        model.removeTable(table);
    }
}

