/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.multilingual;

import java.util.Locale;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.multilingual.MultilingualWidgetValueProperty;

public class MultilingualEditor
extends Composite {
    private FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private ModifyListener modifyListener;
    private MultilingualStringWrapper instance;
    private CTabFolder tabFolder;
    private CTabItem[] tabitems;
    private Text[] textboxes;
    private boolean editable = true;
    int langSize = 0;

    public MultilingualEditor(Composite parent, int style, MultilingualStringWrapper value, boolean editable) {
        super(parent, style);
        this.instance = value;
        this.editable = editable;
        this.langSize = MultilingualString.LANGUAGES.size();
        this.textboxes = new Text[this.langSize];
        this.tabitems = new CTabItem[this.langSize];
        this.initComponents();
    }

    protected void checkSubclass() {
    }

    private void initComponents() {
        this.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder((Composite)this, 0);
        this.tabFolder.setSimple(false);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setSelectionForeground(ComponentsCommons.getColor(0, 0, 128));
        this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(22), Display.getCurrent().getSystemColor(32), Display.getCurrent().getSystemColor(32)}, new int[]{50, 100});
        this.tabFolder.setBorderVisible(true);
        int i = 0;
        while (i < this.textboxes.length) {
            final int idx = i;
            this.tabitems[i] = new CTabItem(this.tabFolder, 0);
            this.tabitems[i].setText((String)MultilingualString.LANGUAGES.get(i));
            this.textboxes[i] = new Text((Composite)this.tabFolder, super.getStyle());
            this.textboxes[i].setEditable(this.editable);
            if (this.modifyListener != null) {
                this.textboxes[i].addModifyListener(this.modifyListener);
            }
            this.textboxes[i].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultilingualEditor.this.getInstance().setValue((String)MultilingualString.LANGUAGES.get(idx), ((Text)e.getSource()).getText());
                }
            });
            this.tabitems[i].setControl((Control)this.textboxes[i]);
            ++i;
        }
        this.tabFolder.setSelection(this.tabitems[0]);
    }

    public void setEditable(boolean editable) {
        Text[] textArray = this.textboxes;
        int n = this.textboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Text textbox = textArray[n2];
            textbox.setEditable(editable);
            ++n2;
        }
    }

    public void setEnabled(boolean enabled) {
        Text[] textArray = this.textboxes;
        int n = this.textboxes.length;
        int n2 = 0;
        while (n2 < n) {
            Text textbox = textArray[n2];
            textbox.setEditable(enabled);
            ++n2;
        }
    }

    public void setModifyListener(ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public MultilingualStringWrapper getInstance() {
        return this.instance;
    }

    public void setValue(MultilingualString value) {
        int i = 0;
        while (i < MultilingualString.LANGUAGES.size()) {
            this.textboxes[i].setText(value.getValue((String)MultilingualString.LANGUAGES.get(i)));
            ++i;
        }
    }

    public void setValue(String lang, String value) {
        int idx = MultilingualString.LANGUAGES.indexOf(lang);
        this.instance.setValue(lang, value);
        this.textboxes[idx].setText(value == null ? "" : value);
    }

    public void setValue(Locale locale, String value) {
        int idx = MultilingualString.LANGUAGES.indexOf(locale.getLanguage());
        this.instance.setValue(locale, value);
        this.textboxes[idx].setText(value);
    }

    public int getLangSize() {
        return this.langSize;
    }

    public String getText(String locale) {
        if (MultilingualString.LANGUAGES.contains(locale)) {
            return this.textboxes[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText();
        }
        return null;
    }

    public boolean hasText(String locale) {
        if (MultilingualString.LANGUAGES.contains(locale)) {
            return this.textboxes[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText() != null && !this.textboxes[MultilingualString.LANGUAGES.lastIndexOf(locale)].getText().equals("");
        }
        return false;
    }

    public <T> void dataBinding(DataBindingContext bindingContext, Class<T> class1, String attribName, Object attribute) {
        ISWTObservableValue text = MultilingualWidgetValueProperty.newInstance().observe((Widget)this);
        IObservableValue value = PojoProperties.value(class1, (String)attribName).observe(attribute);
        bindingContext.bindValue((IObservableValue)text, value);
    }
}

