/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.providers;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.model.functions.ParameterWrapper;

public class FunctionParametersProvidersFactory {
    private static FunctionParametersContentProvider contentProvider;
    private static FunctionParametersLabelProvider labelProvider;
    private static FunctionParametersSorter sorter;

    public static FunctionParametersContentProvider getContentProvider() {
        if (contentProvider == null) {
            contentProvider = new FunctionParametersContentProvider();
        }
        return contentProvider;
    }

    public static FunctionParametersLabelProvider getLabelProvider(String lang) {
        if (labelProvider == null) {
            labelProvider = new FunctionParametersLabelProvider(lang);
        }
        return labelProvider;
    }

    public static FunctionParametersSorter getSorter(String lang) {
        if (sorter == null) {
            sorter = new FunctionParametersSorter(lang);
        }
        return sorter;
    }

    private static class FunctionParametersContentProvider
    implements IStructuredContentProvider {
        private FunctionParametersContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Function) {
                try {
                    Parameter[] parameters = ((Function)inputElement).getParameters().toArray(new Parameter[0]);
                    Object[] result = new ParameterWrapper[parameters.length];
                    int i = 0;
                    while (i < parameters.length) {
                        result[i] = new ParameterWrapper(parameters[i], null);
                        ++i;
                    }
                    return result;
                }
                catch (ReferenceServiceException e) {
                    ComponentsCommons.showExceptionWithStack(e);
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FunctionParametersLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private String lang;

        public FunctionParametersLabelProvider(String lang) {
            this.lang = lang;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ParameterWrapper) {
                if (columnIndex == 0) {
                    return CoreUtils.getCurrentLangName((Object)((ParameterWrapper)element).getParameter(), (String)this.lang);
                }
                if (columnIndex == 1 && ((ParameterWrapper)element).hasValue()) {
                    return ((ParameterWrapper)element).getValue();
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof ParameterWrapper) {
                return CoreUtils.getCurrentLangName((Object)((ParameterWrapper)element).getParameter(), (String)this.lang);
            }
            return null;
        }
    }

    private static class FunctionParametersSorter
    extends ViewerComparator {
        private String lang;

        public FunctionParametersSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Concept && e2 instanceof Concept) {
                Concept c1 = (Concept)e1;
                if (c1.getAcronym().equals("CUSTOM_GROUP")) {
                    return -1;
                }
                Concept c2 = (Concept)e2;
                if (c2.getAcronym().equals("CUSTOM_GROUP")) {
                    return 1;
                }
                return CoreUtils.getCurrentLangName((Object)c1, (String)this.lang).compareTo(CoreUtils.getCurrentLangName((Object)c2, (String)this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

