/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.util.Vector;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;

public class DimensionsComboViewer
extends ComboViewer {
    Dataset dataset = null;
    private String lang;
    Vector<String> extra_entries = null;

    public DimensionsComboViewer(Composite parent, int style, Dataset d, String lang) {
        super(parent, style);
        this.lang = lang;
        this.dataset = d;
        this.extra_entries = new Vector(0);
        this.setContentProvider((IContentProvider)new DimensionsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DimensionsLabelProvider(this.lang));
        if (d != null) {
            this.setInput(d);
            this.setSelection((ISelection)new StructuredSelection(this.getElementAt(0)));
        }
    }

    public void addExtraEntry(String e) {
        this.extra_entries.add(e);
    }

    class DimensionsContentProvider
    implements IStructuredContentProvider {
        DimensionsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Vector<String> result = new Vector<String>(5);
            try {
                result.addAll(DimensionsComboViewer.this.dataset.getDimensions());
                result.addAll(DimensionsComboViewer.this.extra_entries);
                return result.toArray();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class DimensionsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private String lang;

        public DimensionsLabelProvider(String lang) {
            this.lang = lang;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Dimension) {
                return ((Dimension)element).getName().getValue(this.lang);
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "#ERROR#";
        }
    }

    class DimensionsSorter
    extends ViewerComparator {
        private String lang;

        public DimensionsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object c1, Object c2) {
            if (c1 instanceof String && c2 instanceof Dimension) {
                return 1;
            }
            if (c1 instanceof Dimension && c2 instanceof String) {
                return -1;
            }
            if (c1 instanceof String && c2 instanceof String) {
                return super.compare(viewer, c1, c2);
            }
            String s1 = ((Dimension)c1).getName().getValue(this.lang);
            String s2 = ((Dimension)c2).getName().getValue(this.lang);
            return super.compare(viewer, (Object)s1, (Object)s2);
        }
    }
}

