/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.beans.Beans;
import java.util.Vector;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class TimeSegmentComboViewer
extends ComboViewer {
    Timeseries timeseries = null;
    TimeResolution timeResolution = null;
    Vector<String> extra_entries = null;

    public TimeSegmentComboViewer(Composite parent, int style) {
        super(parent, style);
    }

    public TimeSegmentComboViewer(Composite parent, int style, Timeseries t) {
        super(parent, style);
        this.timeseries = t;
        if (!Beans.isDesignTime()) {
            this.timeResolution = t.getTimeResolution();
        }
        this.extra_entries = new Vector(0);
        this.setContentProvider((IContentProvider)new TimeSegmentContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TimeSegmentLabelProvider());
        this.setComparator(new TimeSegmentSorter());
        this.setInput(t);
        if (!Beans.isDesignTime()) {
            this.setSelection((ISelection)new StructuredSelection(this.getElementAt(0)));
        }
    }

    public void addExtraEntry(String e) {
        this.extra_entries.add(e);
    }

    class TimeSegmentContentProvider
    implements IStructuredContentProvider {
        TimeSegmentContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Vector<String> result = new Vector<String>(TimeSegmentComboViewer.this.timeseries.getObservationPeriods().size());
            try {
                result.addAll(TimeSegmentComboViewer.this.timeseries.getObservationPeriods());
                result.addAll(TimeSegmentComboViewer.this.extra_entries);
                return result.toArray();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TimeSegmentLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        TimeSegmentLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ObservationPeriod && TimeSegmentComboViewer.this.timeResolution.equals((Object)TimeResolution.YEAR)) {
                return "Year " + ((ObservationPeriod)element).toString().substring(1);
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "#ERROR#";
        }
    }

    class TimeSegmentSorter
    extends ViewerComparator {
        TimeSegmentSorter() {
        }

        public int compare(Viewer viewer, Object c1, Object c2) {
            if (c1 instanceof String && c2 instanceof ObservationPeriod) {
                return 1;
            }
            if (c1 instanceof ObservationPeriod && c2 instanceof String) {
                return -1;
            }
            if (c1 instanceof String && c2 instanceof String) {
                return super.compare(viewer, c1, c2);
            }
            String s1 = ((ObservationPeriod)c1).toString();
            String s2 = ((ObservationPeriod)c2).toString();
            return super.compare(viewer, (Object)s1, (Object)s2);
        }
    }
}

