/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.beans.Beans;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModelImpl;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;

public class WorkspacesTableViewer
extends Composite
implements Observer {
    private final String lang;
    private final WorkspacesManager workspacesManager;
    private final List<AutoUpdateWks> autoUpdateWks;
    private TableViewer tv;

    public WorkspacesTableViewer(WorkspacesManager workspacesManager, List<AutoUpdateWks> updateWks, Composite parent, int style, String lang) {
        super(parent, style);
        this.tv = new TableViewer((Composite)this, style);
        this.autoUpdateWks = updateWks;
        this.workspacesManager = workspacesManager;
        this.lang = lang;
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tv, 0);
        TableColumn tblcName = tableViewerColumn.getColumn();
        tblcName.setText(ComponentsActivator.getDefault().getLocalString("workspaces.tableviewer.workspace.select"));
        if (!Beans.isDesignTime()) {
            this.workspacesManager.addObserver((Observer)this);
            this.tv.setContentProvider((IContentProvider)new WorkspacesContentProvider());
            this.tv.setLabelProvider((IBaseLabelProvider)new WorkspacesLabelProvider());
            this.tv.setComparator((ViewerComparator)new WorkspacesSorter());
            this.tv.setInput((Object)CoreCommons.getWorkspacesManager());
        }
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)tblcName, (ColumnLayoutData)new ColumnWeightData(100));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.setLayout((Layout)tableColumnLayout);
        this.tv.refresh();
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        if (!this.tv.getTable().isDisposed()) {
            this.tv.setInput((Object)this.workspacesManager);
        }
    }

    public TableViewer getTableViewer() {
        return this.tv;
    }

    class WorkspacesContentProvider
    implements IStructuredContentProvider {
        WorkspacesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> list = new ArrayList<Object>();
            List wksList = WorkspacesTableViewer.this.workspacesManager.getDeployedWorkspaces();
            for (WorkspaceModel awks : wksList) {
                list.add(awks);
            }
            if (WorkspacesTableViewer.this.autoUpdateWks != null && !WorkspacesTableViewer.this.autoUpdateWks.isEmpty()) {
                for (AutoUpdateWks updateWks : WorkspacesTableViewer.this.autoUpdateWks) {
                    if (this.foundThisWorkspace(updateWks)) continue;
                    list.add(updateWks);
                }
            }
            return list.toArray();
        }

        private boolean foundThisWorkspace(AutoUpdateWks updateWks) {
            for (WorkspaceModel awks : WorkspacesTableViewer.this.workspacesManager.getDeployedWorkspaces()) {
                if (!awks.getAcronym().equals(updateWks.getAcronym()) || awks.getVersion().compareTo(new VersionId(updateWks.getVersion())) != 0) continue;
                return true;
            }
            return false;
        }
    }

    class WorkspacesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        WorkspacesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof WorkspaceModelImpl) {
                return ((WorkspaceModelImpl)element).getName(WorkspacesTableViewer.this.lang);
            }
            if (element instanceof AutoUpdateWks) {
                return ((AutoUpdateWks)element).getDescription();
            }
            return null;
        }

        public String getText(Object element) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof AutoUpdateWks) {
                return Display.getCurrent().getSystemColor(3);
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }

    private class WorkspacesSorter
    extends ViewerComparator {
        private WorkspacesSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String o1 = null;
            String o2 = null;
            if (e1 instanceof AutoUpdateWks && e2 instanceof WorkspaceModelImpl) {
                return -1;
            }
            if (e1 instanceof WorkspaceModelImpl && e2 instanceof AutoUpdateWks) {
                return 1;
            }
            if (e1 instanceof WorkspaceModelImpl && e2 instanceof WorkspaceModelImpl) {
                if (((WorkspaceModel)e1).getAcronym().equals(((WorkspaceModel)e2).getAcronym())) {
                    o2 = ((WorkspaceModel)e1).getVersion().toString();
                    o1 = ((WorkspaceModel)e2).getVersion().toString();
                } else {
                    o1 = ((WorkspaceModel)e1).getAcronym();
                    o2 = ((WorkspaceModel)e2).getAcronym();
                }
                return o1.compareTo(o2);
            }
            if (e1 instanceof AutoUpdateWks && e2 instanceof AutoUpdateWks) {
                o1 = ((AutoUpdateWks)e1).getAcronym();
                o2 = ((AutoUpdateWks)e2).getAcronym();
                return o1.compareTo(o2);
            }
            return 0;
        }
    }
}

