/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.tables;

import java.beans.Beans;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.providers.PeriodsSettingsFactory;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;

public class PeriodsSettingsTableViewer
extends Composite
implements Observer {
    private TimeSeriesProperties properties;
    private String lang;
    private Table table;
    private TableViewer tableViewer;
    private Button[] checks = null;
    private TableEditor[] editors_checks = null;
    private Button btnAll;
    private Button btnNone;
    private Button btnSelect;
    private Button btnDeselect;

    public PeriodsSettingsTableViewer(Composite parent, int style, TimeSeriesProperties properties, String lang) {
        super(parent, 0);
        this.lang = lang;
        this.properties = properties;
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(ComponentsCommons.getColor(255, 255, 255));
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.horizontalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        this.tableViewer = new TableViewer((Composite)this, 67586);
        this.table = this.tableViewer.getTable();
        TableViewerColumn periodColumnVisible = new TableViewerColumn(this.tableViewer, 0);
        periodColumnVisible.getColumn().setText("");
        periodColumnVisible.getColumn().setWidth(20);
        TableViewerColumn periodColumn = new TableViewerColumn(this.tableViewer, 0);
        periodColumn.getColumn().setText(ComponentsActivator.getDefault().getLocalString("label.period.first.upper"));
        periodColumn.getColumn().setWidth(306);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setForeground(ComponentsCommons.getColor(10));
        GridData gridData = new GridData(4, 4, false, true, 4, 1);
        gridData.heightHint = 272;
        this.table.setLayoutData((Object)gridData);
        if (!Beans.isDesignTime()) {
            this.tableViewer.setContentProvider((IContentProvider)PeriodsSettingsFactory.getContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)PeriodsSettingsFactory.getLabelProvider(this.lang));
            this.tableViewer.setInput((Object)this.properties);
            this.tableViewer.setComparator((ViewerComparator)PeriodsSettingsFactory.getSorter());
            this.tableViewer.refresh();
            this.tableViewer.setSelection(this.getLastYear(this.tableViewer), true);
            this.adaptTable();
        }
        this.btnAll = new Button((Composite)this, 0x800000);
        this.btnAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeriodsSettingsTableViewer.this.setAllChecks(true);
            }
        });
        GridData gridData_1 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.btnAll.setLayoutData((Object)gridData_1);
        this.btnAll.setText(ComponentsActivator.getDefault().getLocalString("label.all.first.upper"));
        this.btnNone = new Button((Composite)this, 0x800000);
        this.btnNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeriodsSettingsTableViewer.this.setAllChecks(false);
            }
        });
        GridData gridData_2 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.btnNone.setLayoutData((Object)gridData_2);
        this.btnNone.setText(ComponentsActivator.getDefault().getLocalString("label.none.first.upper"));
        this.btnSelect = new Button((Composite)this, 0x800000);
        this.btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selIdx;
                int[] nArray = selIdx = PeriodsSettingsTableViewer.this.tableViewer.getTable().getSelectionIndices();
                int n = selIdx.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    PeriodsSettingsTableViewer.this.checks[s].setSelection(true);
                    ++n2;
                }
            }
        });
        GridData gridData_3 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.btnSelect.setLayoutData((Object)gridData_3);
        this.btnSelect.setText(ComponentsActivator.getDefault().getLocalString("label.check.selection"));
        this.btnDeselect = new Button((Composite)this, 0x800000);
        this.btnDeselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selIdx;
                int[] nArray = selIdx = PeriodsSettingsTableViewer.this.tableViewer.getTable().getSelectionIndices();
                int n = selIdx.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    PeriodsSettingsTableViewer.this.checks[s].setSelection(false);
                    ++n2;
                }
            }
        });
        GridData gridData_4 = new GridData(4, 0x1000000, true, false, 1, 1);
        this.btnDeselect.setLayoutData((Object)gridData_4);
        this.btnDeselect.setText(ComponentsActivator.getDefault().getLocalString("label.uncheck.selection"));
    }

    private ISelection getLastYear(TableViewer tableViewer) {
        Object lastYear = tableViewer.getElementAt(tableViewer.getTable().getItemCount() - 1);
        return new StructuredSelection(lastYear);
    }

    private void adaptTable() {
        int size = this.table.getItemCount();
        this.checks = new Button[size];
        this.editors_checks = new TableEditor[size];
        int i = 0;
        while (i < size) {
            TableItem item = this.table.getItem(i);
            this.checks[i] = new Button((Composite)this.table, 32);
            this.checks[i].computeSize(-1, this.table.getItemHeight());
            this.checks[i].setBackground(ComponentsCommons.getColor(1));
            this.checks[i].setForeground(ComponentsCommons.getColor(10));
            this.checks[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
            this.editors_checks[i] = new TableEditor(this.table);
            this.editors_checks[i].grabHorizontal = true;
            this.editors_checks[i].minimumHeight = this.checks[i].getSize().y;
            this.editors_checks[i].minimumWidth = this.checks[i].getSize().x;
            this.editors_checks[i].setEditor((Control)this.checks[i], item, 0);
            ++i;
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    public void setAllChecks(boolean value) {
        Button[] buttonArray = this.checks;
        int n = this.checks.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.setSelection(value);
            ++n2;
        }
    }

    public void setCheckList(List<ObservationPeriod> list, boolean value) {
        int i = 0;
        while (i < this.tableViewer.getTable().getItemCount()) {
            if (list.contains(this.tableViewer.getElementAt(i))) {
                this.checks[i].setSelection(value);
            } else {
                this.checks[i].setSelection(!value);
            }
            ++i;
        }
    }

    public List<ObservationPeriod> getCheckSelection() {
        LinkedList<ObservationPeriod> result = new LinkedList<ObservationPeriod>();
        int i = 0;
        while (i < this.checks.length) {
            if (this.checks[i].getSelection()) {
                result.add((ObservationPeriod)this.tableViewer.getElementAt(i));
            }
            ++i;
        }
        return result;
    }
}

