/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.automenu;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete - event.topics=org/eclipse/e4/ui/LifeCycle/appShutdownStarted"})
public class MenuStartupService
implements EventHandler {
    public static final int DELAY_SECONDS = 30;
    private static boolean isRunning = true;

    public void handleEvent(Event event) {
        if (event.getTopic().equals("org/eclipse/e4/ui/LifeCycle/appStartupComplete")) {
            this.startupTipJob();
        }
        if (event.getTopic().equals("org/eclipse/e4/ui/LifeCycle/appShutdownStarted")) {
            this.shutdownTipJob();
        }
        if (event.getTopic().equals("org/fao/fi/fishstat/automenu/disable")) {
            this.shutdownTipJob();
        }
    }

    private void startupTipJob() {
        Job menuJob = new Job(MenuStartupService.class.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MenuStartupService.this.jobLoop(monitor);
                }
                catch (InterruptedException interruptedException) {}
                monitor.done();
                isRunning = false;
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return MenuStartupService.class.equals(family);
            }
        };
        menuJob.setSystem(true);
        menuJob.setUser(false);
        menuJob.schedule();
    }

    private void shutdownTipJob() {
        if (isRunning) {
            isRunning = false;
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void jobLoop(IProgressMonitor monitor) throws InterruptedException {
        int i = 0;
        while (i < 300) {
            if (!isRunning) {
                return;
            }
            TimeUnit.MILLISECONDS.sleep(100L);
            if (!isRunning) {
                return;
            }
            ++i;
        }
        this.openManageWorkspaces();
    }

    private void openManageWorkspaces() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            ECommandService commandService = (ECommandService)PlatformUI.getWorkbench().getService(ECommandService.class);
            EHandlerService handlerService = (EHandlerService)PlatformUI.getWorkbench().getService(EHandlerService.class);
            ParameterizedCommand command = commandService.createCommand("org.fao.fi.fishstat.gui.tools.browse.workspaces", null);
            handlerService.executeHandler(command);
        });
    }

    public static void automenuStop() {
        isRunning = false;
    }
}

