/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.management.descriptors.impl;

import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DimensionDescriptor;

public class DimensionDescriptorImpl
implements DimensionDescriptor {
    private String acronym;
    private MultilingualString name;
    private MultilingualString description;
    private Concept concept;
    private Attribute attribute;
    private boolean observedMeasure;
    private boolean hasNote;

    public DimensionDescriptorImpl(String acronym, MultilingualString name, MultilingualString description, Concept concept, Attribute attribute, boolean observedMeasure, boolean hasNote) {
        if (concept == null) {
            throw new IllegalArgumentException("Concept can not be null");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("Concept attribute can not be null");
        }
        if (!concept.equals(attribute.getConcept())) {
            throw new IllegalArgumentException("Not a concept attribute [" + attribute.getAcronym() + "]");
        }
        if (!attribute.isCodeAttribute()) {
            throw new IllegalArgumentException("Not a code attribute [" + attribute.getAcronym() + "]");
        }
        this.acronym = acronym;
        this.name = name;
        this.description = description;
        this.concept = concept;
        this.attribute = attribute;
        this.observedMeasure = observedMeasure;
        this.hasNote = hasNote;
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public MultilingualString getDescription() {
        return this.description;
    }

    @Override
    public MultilingualString getName() {
        return this.name;
    }

    @Override
    public boolean isObservedMeasure() {
        return this.observedMeasure;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    @Override
    public void setConcept(Concept concept) {
        this.concept = concept;
    }

    @Override
    public void setDescription(MultilingualString description) {
        this.description = description;
    }

    @Override
    public void setName(MultilingualString name) {
        this.name = name;
    }

    @Override
    public void setObservedMeasure(boolean value) {
        this.observedMeasure = value;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean hasNote() {
        return this.hasNote;
    }

    @Override
    public void setHasNote(boolean value) {
        this.hasNote = value;
    }
}

