/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.concept;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CompareInteger;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.concept.ConceptAttributeModel;
import org.fao.fi.fishstat.core.model.concept.ConceptAttributeModelImpl;
import org.fao.fi.fishstat.core.model.concept.ConceptModel;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.model.persistence.ReferencePersistenceService;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class ConceptModelImpl
implements ConceptModel,
PropertyChangeListener {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected Concept instance;
    protected String acronym;
    protected Integer sortorder;
    protected MultilingualStringWrapper name;
    protected MultilingualStringWrapper description;
    protected List<ConceptAttributeModel> attributes;
    protected boolean isSystemConcept = false;

    public ConceptModelImpl() {
        this.initNewConceptMoodel();
    }

    public ConceptModelImpl(Concept concept, boolean clone) {
        if (!clone) {
            this.instance = concept;
        }
        this.attributes = new LinkedList<ConceptAttributeModel>();
        this.syncInstance(concept);
        Collection coll = concept.getAttributes();
        for (Attribute att : coll) {
            this.attributes.add(new ConceptAttributeModelImpl(this, att));
        }
        this.isSystemConcept = CoreCommons.getWorkspaceSystemEntities().isSystemConcept(concept);
    }

    private void syncInstance(Concept concept) {
        this.acronym = concept.getAcronym();
        this.name = new MultilingualStringWrapper("name", concept.getName(), this);
        this.description = new MultilingualStringWrapper("description", concept.getDescription(), this);
        this.sortorder = concept.getSortorder();
    }

    public Concept getInstance() {
        return this.instance;
    }

    @Override
    public void setInstance(Concept instance) {
        this.instance = instance;
        for (ConceptAttributeModel attribute : this.attributes) {
            attribute.setInstance(instance.getAttribute(attribute.getAcronym()));
        }
    }

    @Override
    public boolean isNative() {
        return this.instance != null;
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        String oldAcronym = this.acronym;
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", oldAcronym, acronym);
    }

    @Override
    public Integer getSortorder() {
        return this.sortorder;
    }

    @Override
    public void setSortorder(Integer sortorder) {
        Integer oldSortorder = this.sortorder;
        this.sortorder = sortorder;
        this.propertyChangeSupport.firePropertyChange("sortorder", oldSortorder, sortorder);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        MultilingualStringWrapper oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldName, name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        MultilingualStringWrapper oldDescription = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldDescription, description);
    }

    @Override
    public Collection<ConceptAttributeModel> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getAttributesSize() {
        return this.attributes != null ? this.attributes.size() : 0;
    }

    @Override
    public boolean isSynchronised() {
        if (this.instance == null) {
            return false;
        }
        if (!this.instance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!CompareInteger.compare(this.sortorder, this.instance.getSortorder())) {
            return false;
        }
        if (!this.instance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.instance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (this.instance.getAttributes().size() != this.attributes.size()) {
            return false;
        }
        for (ConceptAttributeModel attribute : this.attributes) {
            if (attribute.isSynchronised() && attribute.isNative()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAttribute(String acronym) {
        for (ConceptAttributeModel attributeModel : this.attributes) {
            if (!attributeModel.getAcronym().equals(acronym)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConceptAttributeModel getAttribute(String acronym) {
        for (ConceptAttributeModel attributeModel : this.attributes) {
            if (!attributeModel.getAcronym().equals(acronym)) continue;
            return attributeModel;
        }
        return null;
    }

    @Override
    public void addAttribute(ConceptAttributeModel attribute) {
        int oldSize = this.attributes.size();
        this.attributes.add(attribute);
        this.propertyChangeSupport.firePropertyChange("attributes_size", oldSize, oldSize + 1);
    }

    @Override
    public void removeAttribute(ConceptAttributeModel attribute) {
        if (this.attributes.contains(attribute)) {
            int oldSize = this.attributes.size();
            this.attributes.remove(attribute);
            this.propertyChangeSupport.firePropertyChange("attributes_size", oldSize, oldSize - 1);
        }
    }

    @Override
    public boolean isSystemConcept() {
        return this.isSystemConcept;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public ConceptAttributeModel createNewAttribute() {
        return new ConceptAttributeModelImpl(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public static String getNewConceptAcronym() {
        String base = "NEW_CONCEPT";
        int i = 0;
        while (i <= 100) {
            if (ReferenceServiceFactory.getService().getConcept(String.valueOf(base) + "_" + i) == null) {
                return String.valueOf(base) + "_" + i;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        ReferencePersistenceService service = PersistenceServiceFactory.getReferenceService();
        service.setMonitor(progressMonitor);
        this.setInstance(service.persistConcept(this));
    }

    private void initNewConceptMoodel() {
        this.acronym = ConceptModelImpl.getNewConceptAcronym();
        this.name = new MultilingualStringWrapper();
        this.description = new MultilingualStringWrapper();
        this.attributes = new LinkedList<ConceptAttributeModel>();
        this.attributes.add(this.createIDAttribute());
    }

    private ConceptAttributeModel createIDAttribute() {
        ConceptAttributeModelImpl res = new ConceptAttributeModelImpl(this);
        res.acronym = "ID";
        res.idAttribute = true;
        res.scale = 0;
        res.size = (short)20;
        MultilingualString mlsName = new MultilingualString();
        mlsName.setValue("en", "Identifier");
        mlsName.setValue("fr", "Identifiant");
        mlsName.setValue("es", "Identificador");
        res.name = new MultilingualStringWrapper(mlsName);
        MultilingualString mlsDescription = new MultilingualString();
        mlsDescription.setValue("en", "Identifier");
        mlsDescription.setValue("fr", "Identifiant");
        mlsDescription.setValue("es", "Identificador");
        res.description = new MultilingualStringWrapper(mlsDescription);
        res.type = AttributeType.STRING;
        res.codeAttribute = true;
        res.nameAttribute = false;
        return res;
    }
}

