/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.customgroups;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModel;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class CustomGroupModelImpl
implements CustomGroupModel,
PropertyChangeListener {
    private CustomGroup instance;
    private MultilingualStringWrapper name;
    private MultilingualStringWrapper description;
    private ConceptSelection selection;
    private Concept membersConcept;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public CustomGroupModelImpl(Concept membersConcept) {
        this.membersConcept = membersConcept;
        this.name = new MultilingualStringWrapper("name", this);
        this.description = new MultilingualStringWrapper("description", this);
        this.selection = new ConceptSelection(membersConcept);
    }

    @Override
    public boolean isAlreadyDefined() {
        return this.instance != null;
    }

    @Override
    public Identifier getId() {
        if (this.instance != null) {
            return this.instance.getId();
        }
        return null;
    }

    public void setInstance(CustomGroup instance) {
        this.instance = instance;
    }

    @Override
    public CustomGroup getInstance() {
        return this.instance;
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public ConceptSelection getSelection() {
        if (this.selection == null) {
            this.selection = new ConceptSelection(this.membersConcept);
            if (this.instance != null) {
                this.selection.addIncludes(this.instance.getMembers());
            }
        }
        return this.selection;
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public Concept getMembersConcept() {
        return this.membersConcept;
    }

    @Override
    public void setMembersConcept(Concept membersConcept) {
        this.membersConcept = membersConcept;
    }

    @Override
    public CustomGroupModelImpl createCopy(String prefix) throws Exception {
        CustomGroupModelImpl result = new CustomGroupModelImpl(this.membersConcept);
        result.name = new MultilingualStringWrapper();
        result.description = new MultilingualStringWrapper();
        int i = 0;
        while (i < MultilingualString.LANGUAGES.size()) {
            result.name.setValue((String)MultilingualString.LANGUAGES.get(i), String.valueOf(prefix) + this.name.getValue((String)MultilingualString.LANGUAGES.get(i)));
            result.description.setValue((String)MultilingualString.LANGUAGES.get(i), String.valueOf(prefix) + this.description.getValue((String)MultilingualString.LANGUAGES.get(i)));
            ++i;
        }
        if (this.instance != null) {
            result.selection = new ConceptSelection(this.membersConcept);
            result.selection.addIncludes(this.instance.getMembers());
        }
        return result;
    }

    @Override
    public boolean isNative() {
        return this.instance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.instance == null) {
            return this.isEmpty();
        }
        if (!this.instance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.instance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (!this.instance.getMembersConcept().equals(this.membersConcept)) {
            return false;
        }
        return this.instance.getMembers().equals(this.getSelection().getIncludes());
    }

    @Override
    public void persistModel(IProgressMonitor monitor) throws Exception {
        if (this.isNative() && !this.instance.getMembersConcept().equals(this.membersConcept)) {
            this.instance = null;
        }
        if (this.instance == null) {
            this.instance = CustomGroupFactory.create((MultilingualString)this.name.getInstance(), (MultilingualString)this.description.getInstance(), (Concept)this.membersConcept);
        }
        if (this.instance.getMembersConcept().equals(this.membersConcept)) {
            this.pairReferences();
        }
    }

    private boolean isEmpty() {
        return this.getMembersConcept() == null && this.getSelection().isNothingIncluded() && this.getName().isEmpty() && this.getDescription().isEmpty();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void pairReferences() throws Exception {
        if (!this.instance.getMembers().equals(this.selection.getIncludes())) {
            this.instance.cleanMembers();
            for (ReferenceObject reference : this.selection.getIncludes()) {
                this.instance.addMember(reference);
            }
        }
    }

    @Override
    public CustomGroupModelImpl clone() {
        CustomGroupModelImpl clone = new CustomGroupModelImpl(this.membersConcept);
        clone.selection = this.selection.clone();
        clone.name = this.name.clone();
        clone.description = this.description.clone();
        return clone;
    }
}

