/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.reference.relationship;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.model.reference.relationship.ReferenceRelationshipModel;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class ReferenceRelationshipModelImpl
extends Observable
implements ReferenceRelationshipModel,
PropertyChangeListener {
    public static final int STRUCTURE_MODIFICATION = 1;
    public static final int CONTENT_MODIFICATION = 2;
    private Relationship conceptRelationship;
    private Map<ReferenceObject, Set<ReferenceObject>> children;
    private Map<ReferenceObject, Set<ReferenceObject>> parents;

    public ReferenceRelationshipModelImpl(Relationship conceptRelationship) {
        this.conceptRelationship = conceptRelationship;
        this.parents = new HashMap<ReferenceObject, Set<ReferenceObject>>();
        this.children = new HashMap<ReferenceObject, Set<ReferenceObject>>();
        this.initChildren();
    }

    @Override
    public void addChild(ReferenceObject parent, ReferenceObject child) {
        if (this.parents.containsKey(parent)) {
            this.children.get(parent).add(child);
            this.parents.get(child).add(parent);
        }
    }

    @Override
    public Set<ReferenceObject> getChildren(ReferenceObject parent) {
        return this.children.get(parent);
    }

    @Override
    public Set<ReferenceObject> getParents(ReferenceObject child) {
        return this.parents.get(child);
    }

    @Override
    public Collection<ReferenceObject> getAllParents() {
        return this.children.keySet();
    }

    @Override
    public Collection<ReferenceObject> getAllChildren() {
        return this.conceptRelationship.getChildConcept().getObjects();
    }

    @Override
    public void moveChild(ReferenceObject from, ReferenceObject to, ReferenceObject child) {
        if (from != null) {
            this.children.get(from).remove(child);
            this.parents.get(child).remove(from);
        }
        if (to != null) {
            this.children.get(to).add(child);
            this.parents.get(child).add(to);
        }
        this.setChanged();
    }

    @Override
    public boolean hasChildren(ReferenceObject parent) {
        return this.children.containsKey(parent) && this.children.get(parent) != null && this.children.get(parent).size() > 0;
    }

    @Override
    public boolean hasParents(ReferenceObject child) {
        return this.parents.containsKey(child) && this.parents.get(child) != null && this.parents.get(child).size() > 0;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isSynchronised() {
        return false;
    }

    @Override
    public Relationship getInstance() {
        return this.conceptRelationship;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.setChanged();
        this.notifyObservers(2);
    }

    private void initChildren() {
        for (ReferenceObject parent : this.conceptRelationship.getParents()) {
            this.children.put(parent, this.conceptRelationship.getChildren(parent));
        }
        for (ReferenceObject child : this.conceptRelationship.getChildren()) {
            this.parents.put(child, this.conceptRelationship.getParents(child));
        }
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        this.conceptRelationship.removeAll();
        for (ReferenceObject referenceObject : this.getAllParents()) {
            this.conceptRelationship.addChildren(referenceObject, this.children.get(referenceObject));
        }
    }
}

