/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.register;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEventListenerRegistry;

public class RegistryFactory {
    private static Map<Object, StructuralChangeEventListenerRegistry> register = Collections.synchronizedMap(new WeakHashMap());

    public static StructuralChangeEventListenerRegistry getRegistry(Object key) {
        if (register.get(key) == null) {
            register.put(key, new StructuralChangeEventListenerRegistry());
        }
        return register.get(key);
    }

    public static void fireStructuralChangeEvents() {
        for (Map.Entry<Object, StructuralChangeEventListenerRegistry> entry : register.entrySet()) {
            entry.getValue().fireRegisteredStructuralChangeEvents();
        }
    }

    public static void fireStructuralChangeEvent(StructuralChangeEvent event) {
        for (Map.Entry<Object, StructuralChangeEventListenerRegistry> entry : register.entrySet()) {
            entry.getValue().fireStructuralChangeEvent(event);
        }
    }
}

