/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.management.descriptors.impl;

import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.exceptions.VersionException;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.TimeseriesDescriptor;

public class TimeseriesDescriptorImpl
implements TimeseriesDescriptor {
    private Dataset dataset;
    private DataSource datasource;
    private Map<Attribute, String> attributes;
    private String acronym;
    private MultilingualString name;
    private MultilingualString description;
    private TimeResolution resolution;
    private ObservationPeriod firstObservationPeriod;
    private ObservationPeriod lastObservationPeriod;
    private Version version;

    public TimeseriesDescriptorImpl(Dataset dataset, DataSource datasource, String acronym, MultilingualString name, MultilingualString description, TimeResolution resolution, ObservationPeriod firstObservationPeriod, ObservationPeriod lastObservationPeriod, Map<Attribute, String> attributes, Version version) {
        this.dataset = dataset;
        this.datasource = datasource;
        this.attributes = attributes;
        this.acronym = acronym;
        this.name = name;
        this.description = description;
        this.resolution = resolution;
        this.firstObservationPeriod = firstObservationPeriod;
        this.lastObservationPeriod = lastObservationPeriod;
        this.version = version;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public MultilingualString getDescription() {
        return this.description;
    }

    @Override
    public MultilingualString getName() {
        return this.name;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    @Override
    public void setDescription(MultilingualString description) {
        this.description = description;
    }

    @Override
    public void setName(MultilingualString name) {
        this.name = name;
    }

    @Override
    public ObservationPeriod getFirstObservationPeriod() {
        return this.firstObservationPeriod;
    }

    @Override
    public ObservationPeriod getLastObservationPeriod() {
        return this.lastObservationPeriod;
    }

    @Override
    public List<ObservationPeriod> getObservationPeriods() {
        return TimeseriesServiceHelper.calculateObservationPeriods((ObservationPeriod)this.getFirstObservationPeriod(), (ObservationPeriod)this.getLastObservationPeriod(), (TimeResolution)this.getTimeResolution());
    }

    @Override
    public TimeResolution getTimeResolution() {
        return this.resolution;
    }

    @Override
    public void setFirstObservationPeriod(ObservationPeriod period) {
        this.firstObservationPeriod = period;
    }

    @Override
    public void setLastObservationPeriod(ObservationPeriod period) {
        this.lastObservationPeriod = period;
    }

    @Override
    public void setTimeResolution(TimeResolution resolution) {
        this.resolution = resolution;
    }

    @Override
    public Map<Attribute, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<Attribute, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public DataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.datasource = dataSource;
    }

    public Version getVersion() throws VersionException {
        return this.version;
    }

    public void setVersion(Version version) throws VersionException {
        this.version = version;
    }
}

