/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceService;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class CoreCache
extends Thread {
    private static HashMap<String, Set<ReferenceObject>> relationshipChildren = new HashMap(200, 50.0f);
    private static HashMap<Identifier, Integer> timeSeriesSize = new HashMap(20, 5.0f);
    private static HashMap<Identifier, Timeseries> timeSeriesRegistry = new HashMap(20, 5.0f);
    private ReferenceService referenceService = ReferenceServiceFactory.getService();
    private static Vector<Concept> concepts;

    public static boolean isPredefined(ReferenceObject o) {
        return o.equals(ReferenceObject.ALL) || o.equals(ReferenceObject.OTHERS) || o.equals(ReferenceObject.UNKNOWN);
    }

    public CoreCache() {
        super("FistatJ reference data cache system");
        concepts = new Vector(10);
    }

    @Override
    public void run() {
        for (Concept concept : concepts) {
            CoreCache.preLoadCache(concept);
        }
    }

    public static void reloadCache() {
        relationshipChildren = new HashMap(200, 50.0f);
        for (Concept concept : concepts) {
            CoreCache.preLoadCache(concept);
        }
    }

    public void addConcept(String acronym) {
        if (this.referenceService == null) {
            this.referenceService = ReferenceServiceFactory.getService();
        }
        concepts.add(this.referenceService.getConcept(acronym));
    }

    public void addConcept(Concept concept) {
        concepts.add(concept);
    }

    public static void preLoadCache(Concept concept) {
        for (Relationship relationship : concept.getParentRelationships()) {
            for (ReferenceObject parent : relationship.getParents()) {
                String key = String.valueOf(relationship.getId().toString()) + "-" + parent.getId().toString();
                if (relationshipChildren.containsKey(key)) continue;
                relationshipChildren.put(key, relationship.getChildren(parent));
            }
        }
    }

    public static Set<ReferenceObject> getChildren(Relationship rel, ReferenceObject ro) {
        String key = String.valueOf(rel.getId().toString()) + "-" + ro.getId().toString();
        if (!relationshipChildren.containsKey(key)) {
            relationshipChildren.put(key, rel.getChildren(ro));
        }
        return relationshipChildren.get(key);
    }

    public static int getTimeseriesSize(Timeseries timeseries) {
        if (!timeSeriesSize.containsKey(timeseries.getId())) {
            timeSeriesSize.put(timeseries.getId(), timeseries.getRowCount());
        }
        return timeSeriesSize.get(timeseries.getId());
    }

    public static Timeseries getTimeseries(Identifier id) {
        return timeSeriesRegistry.get(id);
    }

    public static void preLoadTimeseriesSizes() throws Exception {
        for (Dataset dataset : CoreCommons.getTimeseriesservice().getDatasets()) {
            for (Timeseries timeseries : dataset.getTimeseries()) {
                timeSeriesSize.put(timeseries.getId(), timeseries.getRowCount());
                timeSeriesRegistry.put(timeseries.getId(), timeseries);
            }
        }
    }
}

