/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.attachment;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.attachment.AttachmentModel;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.model.persistence.TimeseriesPersistenceService;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;

public class AttachmentModelImpl
implements AttachmentModel,
Cloneable,
PropertyChangeListener {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Attachment originalInstance;
    private Dataset dataset;
    private String acronym;
    private MultilingualStringWrapper name = new MultilingualStringWrapper("name", this);
    private MultilingualStringWrapper description = new MultilingualStringWrapper("description", this);
    private MultilingualStringWrapper fileName = new MultilingualStringWrapper("fileName", this);
    private AttachmentType type;
    private String mimeType;

    public AttachmentModelImpl(Attachment datasetAttachment) {
        this.originalInstance = datasetAttachment;
        this.syncInstance(datasetAttachment);
    }

    public AttachmentModelImpl() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public MultilingualStringWrapper getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(MultilingualStringWrapper fileName) {
        this.fileName = fileName;
        this.propertyChangeSupport.firePropertyChange("fileName", this.fileName, this.fileName);
    }

    @Override
    public AttachmentType getType() {
        return this.type;
    }

    @Override
    public void setType(AttachmentType type) {
        this.type = type;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.originalInstance == null) {
            return false;
        }
        if (!this.originalInstance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.originalInstance.getFileName().equals((Object)this.fileName.getInstance())) {
            return false;
        }
        if (!this.originalInstance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.originalInstance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        return this.originalInstance.getType().equals((Object)this.type);
    }

    @Override
    public Attachment getInstance() {
        return this.originalInstance;
    }

    public void setInstance(Attachment instance) {
        this.originalInstance = instance;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        TimeseriesPersistenceService service = PersistenceServiceFactory.getTimeseriesService();
        service.setMonitor(progressMonitor);
        this.mapMimeType();
        this.setInstance(service.persistAttachment(this));
    }

    private void mapMimeType() {
        if (this.type.equals((Object)AttachmentType.BITMAP)) {
            this.mimeType = "image/bmp";
            return;
        }
        for (Map.Entry aType : AttachmentType.TYPES_MIMETYPES.entrySet()) {
            if (!this.type.toString().equals(aType.getValue())) continue;
            this.mimeType = (String)aType.getKey();
            return;
        }
        this.mimeType = "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    protected AttachmentModelImpl clone() throws CloneNotSupportedException {
        AttachmentModelImpl res = new AttachmentModelImpl();
        if (this.acronym != null) {
            res.acronym = new String(this.acronym);
        }
        if (this.dataset != null) {
            res.dataset = this.dataset;
        }
        if (this.description != null) {
            res.description = this.description.clone();
        }
        if (this.fileName != null) {
            res.fileName = this.fileName.clone();
        }
        if (this.mimeType != null) {
            res.mimeType = new String(this.mimeType);
        }
        if (this.name != null) {
            res.name = this.name.clone();
        }
        if (this.type != null) {
            res.type = AttachmentType.valueOf((String)this.type.toString());
        }
        return res;
    }

    private void syncInstance(Attachment datasetAttachment) {
        if (datasetAttachment != null) {
            this.acronym = datasetAttachment.getAcronym();
            this.dataset = datasetAttachment.getDataset();
            this.name = new MultilingualStringWrapper("name", datasetAttachment.getName(), this);
            this.description = new MultilingualStringWrapper("description", datasetAttachment.getDescription(), this);
            this.fileName = new MultilingualStringWrapper("fileName", datasetAttachment.getFileName(), this);
            this.mimeType = datasetAttachment.getMimeType();
            this.type = AttachmentType.valueOf((String)datasetAttachment.getType().toString());
        }
    }
}

