/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.exchange.reference;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.fao.fi.fishstat.core.model.exchange.reference.ReferenceStructure;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructureElement;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;

public class ReferenceStructureImpl
implements ReferenceStructure {
    private Concept concept;
    private int protocol;
    private String datasource;
    private List<TimeSeriesStructureElement> elements;
    private HashMap<String, TimeSeriesStructureElement> dimensionsMap;

    public ReferenceStructureImpl(Concept concept) {
        this.concept = concept;
        this.elements = new LinkedList<TimeSeriesStructureElement>();
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public int getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }

    @Override
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    @Override
    public List<TimeSeriesStructureElement> getElements() {
        return this.elements;
    }

    @Override
    public void addElement(TimeSeriesStructureElement element) {
        element.setIdx(this.elements.size());
        this.elements.add(element);
        if (element.getType() == 10) {
            this.dimensionsMap.put(this.createKey(element.getConcept(), element.getAttribute(), element.getLn()), element);
        }
    }

    @Override
    public TimeSeriesStructureElement getElement(int idx) {
        return this.elements.get(idx);
    }

    @Override
    public TimeSeriesStructureElement getDimensionElement(Concept concept, Attribute attribute) {
        return this.dimensionsMap.get(this.createKey(concept, attribute, null));
    }

    @Override
    public boolean hasDimensionElement(Concept concept, Attribute attribute) {
        return this.dimensionsMap.containsKey(this.createKey(concept, attribute, null));
    }

    @Override
    public TimeSeriesStructureElement getDimensionElement(Concept concept, Attribute attribute, String lang) {
        return this.dimensionsMap.get(this.createKey(concept, attribute, lang));
    }

    @Override
    public boolean hasDimensionElement(Concept concept, Attribute attribute, String lang) {
        return this.dimensionsMap.containsKey(this.createKey(concept, attribute, lang));
    }

    private String createKey(Concept concept, Attribute attribute, String lang) {
        StringBuffer res = new StringBuffer();
        res.append(concept != null ? concept.getAcronym() : "");
        res.append("-");
        res.append(attribute != null ? attribute.getAcronym() : "");
        res.append("-");
        res.append(lang != null ? lang : "");
        return res.toString();
    }
}

