/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.reference;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.model.reference.ReferenceObjectModel;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class ReferenceObjectModelImpl
extends Observable
implements ReferenceObjectModel {
    private ReferenceObject instance;
    private Concept concept;
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public ReferenceObjectModelImpl(Concept concept) {
        this.concept = concept;
    }

    public ReferenceObjectModelImpl(ReferenceObject referenceObject) {
        this.instance = referenceObject;
        this.concept = referenceObject.getConcept();
        this.syncInstance(referenceObject);
    }

    @Override
    public void setAttributeValue(String acronym, Object val) {
        this.setAttributeValue(acronym, val, true);
    }

    private void setAttributeValue(String acronym, Object val, boolean notification) {
        this.attributes.put(acronym, val);
        this.setChanged();
        if (notification) {
            this.notifyObservers();
        }
    }

    @Override
    public void setAttributeValue(Attribute attribute, Object val) {
        this.setAttributeValue(attribute, val, true);
    }

    private void setAttributeValue(Attribute attribute, Object val, boolean notification) {
        this.attributes.put(attribute.getAcronym(), val);
        this.setChanged();
        if (notification) {
            this.notifyObservers();
        }
    }

    @Override
    public Object getAttributeValue(String acronym) {
        return this.attributes.get(acronym);
    }

    @Override
    public Object getAttributeValue(Attribute attribute) {
        return this.attributes.get(attribute.getAcronym());
    }

    @Override
    public boolean hasAttributeValue(String acronym) {
        return this.attributes.containsKey(acronym) && this.attributes.get(acronym) != null;
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public ReferenceObject getInstance() {
        return this.instance;
    }

    @Override
    public boolean isNative() {
        return this.instance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.instance == null) {
            return false;
        }
        for (Attribute attribute : this.instance.getAttributes().keySet()) {
            if (this.instance.getAttribute(attribute) == null && this.getAttributeValue(attribute) != null) {
                return false;
            }
            if (this.instance.getAttribute(attribute) != null && this.getAttributeValue(attribute) == null) {
                return false;
            }
            if (this.instance.getAttribute(attribute) == null || this.getAttributeValue(attribute) == null || this.instance.getAttribute(attribute).equals(this.getAttributeValue(attribute))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setInstance(ReferenceObject instance) {
        if (!instance.getConcept().equals(this.concept)) {
            throw new Error("Concept inconsistence");
        }
        this.instance = instance;
    }

    @Override
    public Object[] getAttributes() {
        return this.attributes.values().toArray();
    }

    private void syncInstance(ReferenceObject instance) {
        for (Attribute attribute : instance.getConcept().getAttributes()) {
            if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                this.setAttributeValue(attribute.getAcronym(), (Object)new MultilingualString((MultilingualString)instance.getAttribute(attribute)), false);
                continue;
            }
            this.setAttributeValue(attribute.getAcronym(), instance.getAttribute(attribute), false);
        }
        this.notifyObservers();
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) {
    }
}

