/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.validators;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.model.validators.AcronymValidatorModel;

public class ConceptAttributeAcronymValidator
implements IValidator<String> {
    private AcronymValidatorModel attributeEditorPanel;

    public ConceptAttributeAcronymValidator(AcronymValidatorModel attributeEditorPanel) {
        this.attributeEditorPanel = attributeEditorPanel;
    }

    public IStatus validate(String value) {
        if (value == null || !(value instanceof String) || value.toString().isEmpty()) {
            return ValidationStatus.error((String)"The Acronym is mandatory");
        }
        if (value.toString().length() < 2) {
            return ValidationStatus.error((String)"The Acronym minimum length is 2");
        }
        if (this.attributeEditorPanel.isDuplicateAcronym(value.toString())) {
            return ValidationStatus.error((String)"This Acronym is already used");
        }
        return Status.OK_STATUS;
    }
}

