/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;

public class FAOMeasureStatus {
    public static final String STATUS_OFFICIAL = "A";
    public static final String STATUS_BREAK = "B";
    public static final String STATUS_ESTIMATE = "E";
    public static final String STATUS_FORCAST = "F";
    public static final String STATUS_EXPERIMENTAL = "G";
    public static final String STATUS_IMPUTED = "I";
    public static final String STATUS_NOTCOLLECTED = "L";
    public static final String STATUS_MISSING = "M";
    public static final String STATUS_NEGLIGIBLE = "N";
    public static final String STATUS_ZERO = "O";
    public static final String STATUS_PROVISIONAL = "P";
    public static final String STATUS_SUPPRESSED = "Q";
    public static final String STATUS_STRIKE = "S";
    public static final String STATUS_UNRELIABLE = "U";
    public static final String STATUS_UNVALIDATED = "V";
    public static final String STATUS_MANDATED = "X";
    public static final String STATUS_DISPLAY_OFFICIAL = " ";
    public static final String STATUS_DISPLAY_OFFICIAL2 = "";
    public static final String STATUS_DISPLAY_BLANK = "[blank]";
    public static final String STATUS_DISPLAY_ZERO = "...";
    public static final String STATUS_FIGIS_MISSING = ".";
    public static final String STATUS_FIGIS_NEGLIGIBLE = "0";
    public static final String STATUS_FIGIS_ZERO = "-";
    public static final String STATUS_FIGIS_ESTIMATE = "F";
    public static final MeasureStatus EMPTY = new MeasureStatus("");
    public static final MeasureStatus OFFICIAL = new MeasureStatus("A");
    public static final MeasureStatus BREAK = new MeasureStatus("B");
    public static final MeasureStatus ESTIMATE = new MeasureStatus("E");
    public static final MeasureStatus FORCAST = new MeasureStatus("F");
    public static final MeasureStatus EXPERIMENTAL = new MeasureStatus("G");
    public static final MeasureStatus IMPUTED = new MeasureStatus("I");
    public static final MeasureStatus NOTCOLLECTED = new MeasureStatus("L");
    public static final MeasureStatus MISSING = new MeasureStatus("M");
    public static final MeasureStatus NEGLIGIBLE = new MeasureStatus("N");
    public static final MeasureStatus ZERO = new MeasureStatus("O");
    public static final MeasureStatus PROVISIONAL = new MeasureStatus("P");
    public static final MeasureStatus SUPPRESSED = new MeasureStatus("Q");
    public static final MeasureStatus STRIKE = new MeasureStatus("S");
    public static final MeasureStatus UNRELIABLE = new MeasureStatus("U");
    public static final MeasureStatus UNVALIDATED = new MeasureStatus("V");
    public static final MeasureStatus MANDATED = new MeasureStatus("X");
    private static Map<String, MeasureStatus> ALL_MEASURES = new HashMap<String, MeasureStatus>();
    private static List<String> VALID_STATUS = new ArrayList<String>();
    private static List<String> ZERO_STATUS = new ArrayList<String>();

    public static Map<String, MeasureStatus> getAllSymbols() {
        if (ALL_MEASURES.isEmpty()) {
            ALL_MEASURES.put(STATUS_OFFICIAL, OFFICIAL);
            ALL_MEASURES.put(STATUS_BREAK, BREAK);
            ALL_MEASURES.put(STATUS_ESTIMATE, ESTIMATE);
            ALL_MEASURES.put("F", FORCAST);
            ALL_MEASURES.put(STATUS_EXPERIMENTAL, EXPERIMENTAL);
            ALL_MEASURES.put(STATUS_IMPUTED, IMPUTED);
            ALL_MEASURES.put(STATUS_NOTCOLLECTED, NOTCOLLECTED);
            ALL_MEASURES.put(STATUS_MISSING, MISSING);
            ALL_MEASURES.put(STATUS_NEGLIGIBLE, NEGLIGIBLE);
            ALL_MEASURES.put(STATUS_ZERO, ZERO);
            ALL_MEASURES.put(STATUS_PROVISIONAL, PROVISIONAL);
            ALL_MEASURES.put(STATUS_SUPPRESSED, SUPPRESSED);
            ALL_MEASURES.put(STATUS_STRIKE, STRIKE);
            ALL_MEASURES.put(STATUS_UNRELIABLE, UNRELIABLE);
            ALL_MEASURES.put(STATUS_UNVALIDATED, UNVALIDATED);
            ALL_MEASURES.put(STATUS_MANDATED, MANDATED);
        }
        return ALL_MEASURES;
    }

    public static MeasureStatus getMeasure(String status) throws TimeseriesServiceException {
        MeasureStatus measure = FAOMeasureStatus.getAllSymbols().get(status);
        if (measure == null) {
            throw new TimeseriesServiceException("MeasureStatus is not valid=" + status);
        }
        return measure;
    }

    public static List<String> getValidStatus() {
        if (VALID_STATUS.isEmpty()) {
            VALID_STATUS.add(STATUS_OFFICIAL);
            VALID_STATUS.add(STATUS_BREAK);
            VALID_STATUS.add(STATUS_ESTIMATE);
            VALID_STATUS.add("F");
            VALID_STATUS.add(STATUS_EXPERIMENTAL);
            VALID_STATUS.add(STATUS_IMPUTED);
            VALID_STATUS.add(STATUS_NOTCOLLECTED);
            VALID_STATUS.add(STATUS_MISSING);
            VALID_STATUS.add(STATUS_NEGLIGIBLE);
            VALID_STATUS.add(STATUS_ZERO);
            VALID_STATUS.add(STATUS_PROVISIONAL);
            VALID_STATUS.add(STATUS_SUPPRESSED);
            VALID_STATUS.add(STATUS_STRIKE);
            VALID_STATUS.add(STATUS_UNRELIABLE);
            VALID_STATUS.add(STATUS_UNVALIDATED);
            VALID_STATUS.add(STATUS_MANDATED);
        }
        return VALID_STATUS;
    }

    public static List<String> getZeroValueStatus() {
        if (ZERO_STATUS.isEmpty()) {
            ZERO_STATUS.add(STATUS_NOTCOLLECTED);
            ZERO_STATUS.add(STATUS_MISSING);
            ZERO_STATUS.add(STATUS_NEGLIGIBLE);
            ZERO_STATUS.add(STATUS_ZERO);
            ZERO_STATUS.add(STATUS_SUPPRESSED);
        }
        return ZERO_STATUS;
    }

    public static boolean isValidStatus(String status) {
        if (status == null) {
            return true;
        }
        return FAOMeasureStatus.getValidStatus().contains(status);
    }

    public static boolean isZeroValueStatus(String status) {
        if (status == null) {
            return true;
        }
        return FAOMeasureStatus.getZeroValueStatus().contains(status);
    }
}

