/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Versioned;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;

public interface Timeseries
extends Versioned {
    public Identifier getId();

    public String getAcronym() throws TimeseriesServiceException;

    public MultilingualString getName() throws TimeseriesServiceException;

    public void setName(MultilingualString var1) throws TimeseriesServiceException;

    public MultilingualString getDescription() throws TimeseriesServiceException;

    public void setDescription(MultilingualString var1) throws TimeseriesServiceException;

    public DataSource getDataSource() throws TimeseriesServiceException;

    public void setDataSource(DataSource var1) throws TimeseriesServiceException;

    public Dataset getDataset() throws TimeseriesServiceException;

    public ObservationSeries getTotals(ReferenceObject var1) throws TimeseriesServiceException;

    public Map<Attribute, String> getAttributes() throws TimeseriesServiceException;

    public List<ObservationSeries> getObservations() throws TimeseriesServiceException;

    public void filter(Selection var1) throws TimeseriesServiceException;

    public void select(String var1, Object[] var2) throws TimeseriesServiceException;

    public void aggregate(Selection var1) throws TimeseriesServiceException;

    public void aggregate(TopCriteria var1, ObservationPeriod var2) throws TimeseriesServiceException;

    public void aggregate(TopCriteria var1, CalculatedMeasureDefinition var2) throws TimeseriesServiceException;

    public void reset();

    public boolean compatible(ObservationSeries var1) throws TimeseriesServiceException;

    public void add(ObservationSeries var1) throws TimeseriesServiceException;

    public void add(List<ObservationSeries> var1) throws TimeseriesServiceException;

    public void update(ObservationSeries var1) throws TimeseriesServiceException;

    public void remove(ObservationSeries var1) throws TimeseriesServiceException;

    public void clean() throws TimeseriesServiceException;

    public TimeResolution getTimeResolution() throws TimeseriesServiceException;

    public ObservationPeriod getFirstObservationPeriod() throws TimeseriesServiceException;

    public ObservationPeriod getLastObservationPeriod() throws TimeseriesServiceException;

    public List<ObservationPeriod> getObservationPeriods() throws TimeseriesServiceException;

    public CalculatedMeasureDefinition getCalculatedMeasureDefinition(String var1) throws TimeseriesServiceException;

    public void addCalculatedMeasureDefinition(CalculatedMeasureDefinition var1) throws TimeseriesServiceException;

    public void addCalculatedMeasureDefinitions(Collection<CalculatedMeasureDefinition> var1) throws TimeseriesServiceException;

    public void removeCalculatedMeasureDefinition(String var1) throws TimeseriesServiceException;

    public void removeCalculatedMeasureDefinition(CalculatedMeasureDefinition var1) throws TimeseriesServiceException;

    public void removeCalculatedMeasureDefinitions(Collection<CalculatedMeasureDefinition> var1) throws TimeseriesServiceException;

    public Collection<CalculatedMeasureDefinition> getCalculatedMeasureDefinitions();

    public void sort(ObservationPeriod var1) throws TimeseriesServiceException;

    public void sort(CalculatedMeasureDefinition var1) throws TimeseriesServiceException;

    public Collection<ReferenceObject> getReferencedObjects(Dimension var1) throws TimeseriesServiceException;

    public Collection<ReferenceObject> getAllReferencedObjects(Dimension var1) throws TimeseriesServiceException;

    public int getRowCount() throws TimeseriesServiceException;

    public ObservationSeries create() throws TimeseriesServiceException;

    public void createGandTotals() throws TimeseriesServiceException;

    public List<ReferenceObject> getObsMeasures();
}

