/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.DimensionNote;

public class DimensionNoteImpl
implements DimensionNote,
Serializable {
    private static final long serialVersionUID = 1L;
    private Dataset dataset;
    private Dimension dimension;
    private Map<Integer, String> notesText = new HashMap<Integer, String>();

    public DimensionNoteImpl(Dataset dataset, Dimension dimension) {
        this.dataset = dataset;
        this.dimension = dimension;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public String getAcronym() {
        return "NOTE_" + this.dataset.getAcronym().toUpperCase(Locale.ENGLISH) + "_" + this.dimension.getAcronym().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public String getNoteString(ReferenceObject ro) {
        Long ebxID = (Long)ro.getAttribute("EBXID");
        if (ebxID == null) {
            return null;
        }
        return this.notesText.get((int)ebxID.longValue());
    }

    @Override
    public void setNoteString(Map<Integer, String> notesText) {
        this.notesText = notesText;
    }
}

