/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.util.Map;
import org.apache.commons.collections15.map.ListOrderedMap;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.impl.MeasureImpl;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class GenericObservationSeries
implements ObservationSeries {
    private Timeseries timeseries;
    private MultiReferenceObject multiKey;
    private ListOrderedMap<ObservationPeriod, Measure> measures;
    private ListOrderedMap<CalculatedMeasureDefinition, Measure> calculatedMeasures;

    public GenericObservationSeries(Timeseries timeseries) {
        this.timeseries = timeseries;
        this.multiKey = null;
        this.initMeasures();
    }

    public GenericObservationSeries(ObservationSeries series) {
        this.timeseries = series.getTimeseries();
        this.multiKey = new MultiReferenceObject(series.getKeys());
        this.measures = new ListOrderedMap();
        this.measures.putAll(series.getMeasures());
    }

    @Override
    public Map<ObservationPeriod, Measure> getMeasures() {
        return this.measures;
    }

    @Override
    public void setMeasures(Map<ObservationPeriod, Measure> measures) {
        this.clearMeasures();
        this.measures.putAll(measures);
    }

    private void clearMeasures() {
        if (this.measures != null) {
            this.measures.clear();
        }
    }

    public String toString() {
        return TimeseriesServiceHelper.seriesToString(this);
    }

    @Override
    public Measure getMeasure(ObservationPeriod period) {
        if (period == null) {
            throw new IllegalArgumentException("Observation period can not be null");
        }
        return (Measure)this.measures.get((Object)period);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.multiKey == null ? 0 : this.multiKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObservationSeries)) {
            return false;
        }
        ObservationSeries other = (ObservationSeries)obj;
        return !(this.multiKey == null ? other.getKeys() != null : !this.multiKey.equals((Object)other.getKeys()));
    }

    @Override
    public Map<CalculatedMeasureDefinition, Measure> getCalculatedMeasures() {
        return this.calculatedMeasures();
    }

    @Override
    public Timeseries getTimeseries() {
        return this.timeseries;
    }

    @Override
    public void resetCalculatedMeasures() {
        if (this.calculatedMeasures != null) {
            this.calculatedMeasures.clear();
            this.calculatedMeasures = null;
        }
    }

    private ListOrderedMap<CalculatedMeasureDefinition, Measure> calculatedMeasures() {
        if (this.calculatedMeasures == null) {
            this.calculatedMeasures = TimeseriesServiceHelper.evaluateCalculatedMeasures(this);
        }
        return this.calculatedMeasures;
    }

    @Override
    public Measure getCalculatedMeasure(CalculatedMeasureDefinition definition) {
        return (Measure)this.calculatedMeasures().get((Object)definition);
    }

    @Override
    public Measure getCalculatedMeasure(int index) {
        return (Measure)this.calculatedMeasures().getValue(index);
    }

    @Override
    public ReferenceObject getKey(Concept dimension) {
        return (ReferenceObject)this.multiKey.asMap().get(dimension);
    }

    @Override
    public ReferenceObject getKey(int index) {
        if (this.multiKey == null) {
            return null;
        }
        return this.multiKey.elementAt(index);
    }

    @Override
    public Measure getMeasure(int index) {
        return (Measure)this.measures.getValue(index);
    }

    @Override
    public MultiReferenceObject getKeys() {
        return this.multiKey;
    }

    @Override
    public void setKeys(MultiReferenceObject keys) {
        this.multiKey = keys;
    }

    @Override
    public void setMeasure(ObservationPeriod period, Measure measure) {
        this.measures.put((Object)period, (Object)measure);
    }

    @Override
    public void setMeasure(int index, Measure measure) {
        this.measures.put((Object)((ObservationPeriod)this.measures.get(index)), (Object)measure);
    }

    private void initMeasures() {
        this.measures = new ListOrderedMap();
    }

    public void zeroMeasures() {
        for (ObservationPeriod period : this.getTimeseries().getObservationPeriods()) {
            MeasureImpl m = new MeasureImpl();
            m.setStatus(null);
            this.measures.put((Object)period, (Object)m);
        }
    }
}

