/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.text.DecimalFormat;
import org.fao.fi.fishstat.data.timeseries.api.FAOMeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;

public class MeasureImpl
implements Measure {
    private double value;
    private MeasureStatus status;
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");

    public MeasureImpl() {
        this.value = 0.0;
        this.status = FAOMeasureStatus.ZERO;
    }

    public MeasureImpl(Measure measure) {
        this.value = measure.getValue();
        this.status = measure.getStatus();
    }

    public MeasureImpl(double value, MeasureStatus status) {
        this.value = value;
        this.status = status;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(FORMAT.format(this.getValue())).append("[").append(this.getStatus()).append("]");
        return buffer.toString();
    }

    @Override
    public int compareTo(Measure other) {
        return Double.compare(this.value, other.getValue());
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeasureImpl)) {
            return false;
        }
        MeasureImpl other = (MeasureImpl)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    @Override
    public MeasureStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(MeasureStatus status) {
        this.status = status;
    }
}

