/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.status;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.FAOMeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculator;

public class MeasureStatusCalculatorFAO
implements MeasureStatusCalculator {
    private static final Set<String> STATUSES_ZERO = new HashSet<String>(Arrays.asList("L", "M", "N", "O", "Q"));
    private Map<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>> statusMap = new HashMap<MultiReferenceObject, Map<ObservationPeriod, DoubleValue>>();

    public MeasureStatusCalculatorFAO() {
        this.reset();
    }

    @Override
    public void reset() {
        this.statusMap.clear();
    }

    @Override
    public void calculate(ObservationSeries aggregated, ObservationSeries series) throws Exception {
        Map<ObservationPeriod, Measure> series_measures = series.getMeasures();
        Map<ObservationPeriod, Measure> aggregated_measures = aggregated.getMeasures();
        MultiReferenceObject multikey = aggregated.getKeys();
        Map<ObservationPeriod, DoubleValue> status_row = this.statusMap.get(multikey);
        if (status_row == null) {
            status_row = new HashMap<ObservationPeriod, DoubleValue>();
            this.statusMap.put(multikey, status_row);
        }
        for (ObservationPeriod period : series.getTimeseries().getObservationPeriods()) {
            Measure observation_measure = series_measures.get(period);
            Measure aggregated_measure = aggregated_measures.get(period);
            DoubleValue value = status_row.computeIfAbsent(period, k -> new DoubleValue());
            this.aggregate(aggregated_measure, observation_measure, value);
        }
    }

    private void aggregate(Measure aggregated, Measure measure, DoubleValue value) throws Exception {
        if (aggregated == null || measure == null) {
            throw new IllegalArgumentException("Measure can not be null");
        }
        MeasureStatus aggregated_symbol = aggregated.getStatus();
        MeasureStatus measure_symbol = measure.getStatus();
        if (aggregated_symbol == null || measure_symbol == null) {
            measure_symbol = FAOMeasureStatus.OFFICIAL;
        }
        value.addValue(measure.getValue(), measure_symbol);
        aggregated.setStatus(value.getStatus());
    }

    final class DoubleValue {
        public int num_zero = 0;
        public int num_N = 0;
        public int num_M = 0;
        public int num_non_zero = 0;
        public int num_P = 0;
        public int num_X = 0;
        public int num_A = 0;
        public double value_non_zero = 0.0;
        public double value_A = 0.0;

        DoubleValue() {
        }

        public void addValue(double value, MeasureStatus flag) {
            if (flag == null) {
                // empty if block
            }
            if (STATUSES_ZERO.contains(flag.toString())) {
                if (Double.compare(value, 0.0) != 0) {
                    // empty if block
                }
                ++this.num_zero;
                if (FAOMeasureStatus.NEGLIGIBLE.equals(flag)) {
                    ++this.num_N;
                }
                if (FAOMeasureStatus.MISSING.equals(flag)) {
                    ++this.num_M;
                }
            } else {
                ++this.num_non_zero;
                this.value_non_zero += value;
                if (FAOMeasureStatus.OFFICIAL.equals(flag)) {
                    ++this.num_A;
                    this.value_A += value;
                } else if (FAOMeasureStatus.PROVISIONAL.equals(flag)) {
                    ++this.num_P;
                } else if (FAOMeasureStatus.MANDATED.equals(flag)) {
                    ++this.num_X;
                }
            }
        }

        public MeasureStatus getStatus() {
            if (this.num_zero != 0 || this.num_non_zero == 0) {
                // empty if block
            }
            if (this.num_N > 0 && (this.num_non_zero == 0 || this.value_non_zero == 0.0)) {
                return new MeasureStatus("N");
            }
            if (this.num_non_zero == 0) {
                if (this.num_M == this.num_zero) {
                    return new MeasureStatus("M");
                }
                return new MeasureStatus("O");
            }
            if (this.num_P == this.num_non_zero) {
                return new MeasureStatus("P");
            }
            if (this.num_X == this.num_non_zero) {
                return new MeasureStatus("X");
            }
            if (this.num_A == this.num_non_zero) {
                return new MeasureStatus("A");
            }
            if (this.value_A > 0.0 && this.value_A / this.value_non_zero >= 0.6666666666666666) {
                return new MeasureStatus("A");
            }
            return new MeasureStatus("E");
        }
    }

    final class DoubleValueOld {
        double total = 0.0;
        double official = 0.0;
        boolean isAllSameFlags = false;
        MeasureStatus statusFlag = null;

        DoubleValueOld() {
        }

        public MeasureStatus getStatus() {
            return this.statusFlag;
        }

        public void addValue(double value, MeasureStatus measure_symbol) {
            this.total += value;
            if (measure_symbol.equals(FAOMeasureStatus.OFFICIAL)) {
                this.official += value;
            }
            if (this.statusFlag == null) {
                this.statusFlag = measure_symbol;
                this.isAllSameFlags = true;
            } else {
                if (measure_symbol.equals(this.statusFlag)) {
                    this.isAllSameFlags = measure_symbol.equals(FAOMeasureStatus.MISSING) || measure_symbol.equals(FAOMeasureStatus.PROVISIONAL) || measure_symbol.equals(FAOMeasureStatus.MANDATED);
                }
                if (FAOMeasureStatus.isZeroValueStatus(measure_symbol.toString())) {
                    this.statusFlag = measure_symbol.equals(FAOMeasureStatus.NEGLIGIBLE) || this.statusFlag.equals(FAOMeasureStatus.NEGLIGIBLE) ? FAOMeasureStatus.NEGLIGIBLE : (measure_symbol.equals(FAOMeasureStatus.ZERO) && this.statusFlag.equals(FAOMeasureStatus.ZERO) ? FAOMeasureStatus.ZERO : (measure_symbol.equals(FAOMeasureStatus.MISSING) && this.statusFlag.equals(FAOMeasureStatus.MISSING) ? FAOMeasureStatus.MISSING : FAOMeasureStatus.ESTIMATE));
                } else if (!this.isAllSameFlags) {
                    this.statusFlag = FAOMeasureStatus.ESTIMATE;
                }
                if (this.total > 0.0 && this.official >= this.total / 3.0 * 2.0) {
                    this.statusFlag = FAOMeasureStatus.OFFICIAL;
                }
            }
        }
    }
}

