/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.api;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class JdbcResourceManager {
    public static final String DERBY_JDBC_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DEFAULT_JDBC_USER = "FISHSTAT";
    public static final String DEFAULT_JDBC_PASSWORD = "";
    public static final String DEFAULT_JDBC_SCHEMA = "FISHSTAT";
    public static final String DEFAULT_JDBC_DAO_JAR_URL = null;
    public static final String DB_ACRONYM = "EMBEDDED_DB";
    public static final String JDBC_DERBY_URL_PREFIX = "jdbc:derby:";
    public static final String JDBC_DERBY_DB_CREATION_URL_POSTFIX = ";create=true";
    public static final String WS_JAR_FILE_NAME = "fishstatj-jdbc-dao.jar";
    public static final String JDBC_URL_PROPERTY = "fishstat.jdbc.url";
    public static final String JDBC_DRIVER_PROPERTY = "fishstat.jdbc.driver";
    public static final String JDBC_USER_PROPERTY = "fishstat.jdbc.user";
    public static final String JDBC_PASSWORD_PROPERTY = "fishstat.jdbc.password";
    public static final String JDBC_DAO_JAR_URL_PROPERTY = "fishstat.jdbc.dao.jar.url";
    public static final String JDBC_SCHEMA_PROPERTY = "fishstat.jdbc.schema";
    private static Driver driver = null;

    public static synchronized String getJdbcUrl() {
        return System.getProperty(JDBC_URL_PROPERTY);
    }

    public static synchronized void setJdbcUrl(String url) {
        System.setProperty(JDBC_URL_PROPERTY, url);
    }

    public static synchronized String getJdbcDriver() {
        return System.getProperty(JDBC_DRIVER_PROPERTY, DERBY_JDBC_EMBEDDED_DRIVER);
    }

    public static synchronized void setJdbcDriver(String driverClassName) {
        System.setProperty(JDBC_DRIVER_PROPERTY, driverClassName);
    }

    public static synchronized String getJdbcUser() {
        return System.getProperty(JDBC_USER_PROPERTY, "FISHSTAT");
    }

    public static synchronized void setJdbcUser(String user) {
        System.setProperty(JDBC_USER_PROPERTY, user);
    }

    public static synchronized String getJdbcPassword() {
        return System.getProperty(JDBC_PASSWORD_PROPERTY, DEFAULT_JDBC_PASSWORD);
    }

    public static synchronized void setJdbcPassword(String password) {
        System.setProperty(JDBC_PASSWORD_PROPERTY, password);
    }

    public static String getJdbcDaoJarUrl() {
        return System.getProperty(JDBC_DAO_JAR_URL_PROPERTY, DEFAULT_JDBC_DAO_JAR_URL);
    }

    public static void setJdbcDaoJarUrl(String jar) {
        System.setProperty(JDBC_DAO_JAR_URL_PROPERTY, jar);
    }

    public static String getJdbcSchema() {
        return System.getProperty(JDBC_SCHEMA_PROPERTY, "FISHSTAT");
    }

    public static void setJdbcSchema(String schema) {
        System.setProperty(JDBC_SCHEMA_PROPERTY, schema);
    }

    public static void closeDriver() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {
            System.out.println("Derby database shutdown executed OK.");
        }
    }

    public static synchronized Connection getConnection() throws SQLException {
        Connection connection = null;
        if (driver == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                System.out.println(String.valueOf(new Date().toString()) + ": loading JDBC driver: " + JdbcResourceManager.getJdbcDriver() + " using: " + loader);
                Class.forName(JdbcResourceManager.getJdbcDriver());
            }
            catch (Exception e) {
                System.out.println("Failed to initialise JDBC driver");
                e.printStackTrace();
            }
        }
        if (connection == null || !connection.isValid(0)) {
            connection = DriverManager.getConnection(JdbcResourceManager.getJdbcUrl(), JdbcResourceManager.getJdbcUser(), JdbcResourceManager.getJdbcPassword());
        }
        return connection;
    }

    public static void close(Connection conn) {
        try {
            if (!JdbcResourceManager.getJdbcDriver().equals(DERBY_JDBC_EMBEDDED_DRIVER) && conn != null) {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public static void close(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }
}

