/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.firestorm;

import com.codefutures.common.progress.NullProgressListener;
import com.codefutures.common.progress.ProgressListener;
import com.codefutures.firestorm.api.codegen.ProviderOptions;
import com.codefutures.firestorm.api.database.DbImportConfig;
import com.codefutures.firestorm.api.database.DbVendorCatalog;
import com.codefutures.firestorm.api.database.DbVendorPlugin;
import com.codefutures.firestorm.api.jdbc.JdbcDriverHelper;
import com.codefutures.firestorm.codegen.jdbc.J2seProviderOptions;
import com.codefutures.firestorm.codegen.jdbc.JdbcCodeGenModule;
import com.codefutures.firestorm.config.dom.FireStormConfig;
import com.codefutures.firestorm.config.dom.JdbcDataSourceConfig;
import com.codefutures.firestorm.config.dom.JdbcDataSourcesConfig;
import com.codefutures.firestorm.config.dom.JdbcDriverConfig;
import com.codefutures.firestorm.config.dom.JdbcDriversConfig;
import com.codefutures.firestorm.config.parser.ConfigParser;
import com.codefutures.firestorm.project.dom.Database;
import com.codefutures.firestorm.project.dom.Project;
import com.codefutures.firestorm.project.metawizard.CreateFinderWizard;
import com.codefutures.firestorm.project.parser.xml4j.ProjectParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.JdbcResourceManager;
import org.fao.fi.fishstat.data.common.firestorm.FileListing;
import org.fao.fi.fishstat.data.common.firestorm.exceptions.FirestormException;
import org.fao.fi.fishstat.data.common.utils.JarResources;

public class FireStormHelper {
    private static final String GENERATED_BASE_DIR = "generated";
    private static final String GENERATED_SRC_DIR = "src";
    private static final String GENERATED_CLASS_DIR = "class";
    private static final String JAVA_SUFFIX = ".java";
    private static final String JAVAC_DESTINATION_OPTION = "-d";
    private static final int BUFFER_SIZE = 10240;
    private static final String PROJECT_NAME = "FishStatJ";
    public static final String HOME_DIR_PROPERTY = "fishstat.firestorm.home.dir";
    public static final String PRJ_DEST_FILE_PROPERTY = "fishstat.firestorm.prj.file";
    public static final String SRC_DEST_DIR_PROPERTY = "fishstat.firestorm.src.dir";
    public static final String CLASS_DEST_DIR_PROPERTY = "fishstat.firestorm.class.dir";
    public static final String DSNAME_PROPERTY = "fishstat.firestorm.dsname";
    public static final String CONFIG_FILE_PROPERTY = "fishstat.firestorm.config.file";
    public static final String SRC_BASE_PACKAGE_PROPERTY = "fishstat.firestorm.src.package";
    public static final String LOGGING_STRATEGY_PROPERTY = "fishstat.firestorm.logging";
    public static final int NO_LOGGING = 1;
    public static final int SYSTEM_OUT_LOGGING = 2;
    public static final int LOG4J_LOGGING = 3;
    public static final String FIRESTORM = "firestorm";
    public static final String FIRESTORM_HOME = String.valueOf(Commons.TMP_DIR) + "firestorm";
    private static final String DEFAULT_DSNAME_PROPERTY = "FishStatJ";
    private static final String DEFAULT_PRJ_DEST_FILE_PROPERTY = "fishstatj-prj.xml";
    private static final String DEFAULT_SRC_DEST_DIR_PROPERTY = String.valueOf(Commons.TMP_DIR) + "generated" + File.separator + "src";
    private static final String DEFAULT_CLASS_DEST_DIR_PROPERTY = String.valueOf(Commons.TMP_DIR) + "generated" + File.separator + "class";
    private static final String DEFAULT_CONFIG_FILE_PROPERTY = "fishstatj-config.xml";
    private static final String DEFAULT_SRC_BASE_PACKAGE_PROPERTY = "org.fao.fi.fishstat.data.generated";
    private static final String DEFAULT_LOGGING_STRATEGY_PROPERTY = String.valueOf(1);
    private FireStormConfig firestormConfig;
    private DbImportConfig dbImportConfig;
    private String home;
    private String prjDest;
    private String srcDest;
    private String classDest;
    private String dsname;
    private String config;
    private String srcBasePackage;
    private int loggingStrategy = 0;
    private static FireStormHelper helper;

    private DbImportConfig getImportConfig() {
        if (this.dbImportConfig == null) {
            this.dbImportConfig = new DbImportConfig();
            this.dbImportConfig.setJdbcDatasourceName(this.getDsname());
            this.dbImportConfig.setCreateFindAll(true);
            this.dbImportConfig.setCreateFinderForEachFk(false);
            this.dbImportConfig.setCreateFindersForEachColumn(true);
            this.dbImportConfig.setPreferObjects(true);
            this.dbImportConfig.setImportTables(true);
            this.dbImportConfig.setImportViews(false);
            this.dbImportConfig.setImportProcedures(false);
            this.dbImportConfig.setImportNew(false);
            this.dbImportConfig.setOverwriteExisting(true);
            this.dbImportConfig.setRemoveDeleted(true);
            this.dbImportConfig.setJdbcSchemaName(JdbcResourceManager.getJdbcSchema());
            this.dbImportConfig.setVerbose(true);
        }
        return this.dbImportConfig;
    }

    private FireStormConfig getFireStormConfig() throws Exception {
        if (this.firestormConfig == null) {
            File configFile = new File(this.getConfig());
            if (configFile.exists() && !configFile.isDirectory()) {
                this.firestormConfig = ConfigParser.loadFireStormConfig((File)configFile);
            } else {
                this.firestormConfig = new FireStormConfig();
                JdbcDataSourceConfig jdbcDataSourceConfig = new JdbcDataSourceConfig(this.getDsname());
                jdbcDataSourceConfig.setJdbcDriverName(JdbcResourceManager.getJdbcDriver());
                jdbcDataSourceConfig.setJdbcUrl(JdbcResourceManager.getJdbcUrl());
                jdbcDataSourceConfig.setUserId(JdbcResourceManager.getJdbcUser());
                jdbcDataSourceConfig.setPassword(JdbcResourceManager.getJdbcPassword());
                JdbcDataSourcesConfig jdbcDataSourceConfigs = new JdbcDataSourcesConfig();
                jdbcDataSourceConfigs.addDataSource(jdbcDataSourceConfig);
                this.firestormConfig.setJdbcDataSourcesConfig(jdbcDataSourceConfigs);
                JdbcDriverConfig jdbcDriverConfig = new JdbcDriverConfig(JdbcResourceManager.getJdbcDriver());
                jdbcDriverConfig.setDriverClassName(JdbcResourceManager.getJdbcDriver());
                File location = new File(Class.forName(JdbcResourceManager.getJdbcDriver()).getProtectionDomain().getCodeSource().getLocation().toURI());
                if (location.exists() && location.isFile()) {
                    String jdbc_driver_path = location.getAbsolutePath();
                    System.out.println("JDBC driver path: " + jdbc_driver_path);
                    jdbcDriverConfig.setClasspath(new String[]{jdbc_driver_path});
                    JdbcDriversConfig jdbcDriversConfig = new JdbcDriversConfig();
                    jdbcDriversConfig.addDriver(jdbcDriverConfig);
                    this.firestormConfig.setJdbcDriversConfig(jdbcDriversConfig);
                } else {
                    throw new Exception("Error in resolving JDBC driver path");
                }
            }
        }
        return this.firestormConfig;
    }

    private Database importDataSource() throws Exception {
        Connection conn = JdbcDriverHelper.getConnection((FireStormConfig)this.getFireStormConfig(), (String)this.getImportConfig().getJdbcDatasourceName());
        DbVendorPlugin dbPlugin = DbVendorCatalog.findBestPluginForDatabase((Connection)conn);
        Database db = dbPlugin.reverseEngineer(conn, null, JdbcResourceManager.getJdbcSchema(), null, this.getImportConfig(), null);
        CreateFinderWizard.createDefaultFinders((Database)db);
        return db;
    }

    private FireStormHelper() {
    }

    private Project getFireStormProject() throws FirestormException {
        try {
            Database db = this.importDataSource();
            Project project = new Project();
            project.setName("FishStatJ");
            project.setDatabase(db);
            project.setDbImportConfig(this.getImportConfig());
            return project;
        }
        catch (Exception e) {
            throw new FirestormException("Failed to import schema", e);
        }
    }

    public static FireStormHelper instance() {
        if (helper == null) {
            helper = new FireStormHelper();
        }
        return helper;
    }

    public void generateJdbcDAO() throws FirestormException {
        try {
            this.setHome();
            J2seProviderOptions options = new J2seProviderOptions();
            options.setAppName("FishStatJ");
            options.setDaoStrategy(1);
            options.setOutputFile(new File(this.getSrcDest()));
            options.setDeleteFiles(true);
            options.setGenerateSampleCode(false);
            options.setOverwriteResourceManager(true);
            options.setRootPackageName(this.getSrcBasePackage());
            options.setLogging(this.getLoggingStrategy());
            JdbcCodeGenModule generator = new JdbcCodeGenModule();
            generator.generate(false, null, false, true, false, false, false, this.getDsname(), this.getFireStormConfig(), this.getFireStormProject(), (ProviderOptions)options, (ProgressListener)new NullProgressListener());
        }
        catch (Exception e) {
            throw new FirestormException("Failed to generate JDBC-DAO support layer", e);
        }
    }

    public void compileJdbcDAO() throws FirestormException {
        try {
            ByteArrayOutputStream error = new ByteArrayOutputStream();
            JavaCompiler compiler = FireStormHelper.getJavaCompiler();
            List<String> arguments = this.buildJavacArguments();
            int compilationResult = compiler.run(null, System.out, error, arguments.toArray(new String[arguments.size()]));
            if (compilationResult != 0) {
                throw new RuntimeException("Compilation failed: " + ((Object)error).toString());
            }
        }
        catch (Exception e) {
            throw new FirestormException("Failed to build JDBC-DAO support layer", e);
        }
    }

    private List<String> buildJavacArguments() throws Exception {
        List<File> sources = FileListing.getFileListing(new File(String.valueOf(this.getSrcDest()) + File.separator + GENERATED_SRC_DIR));
        ArrayList<String> arguments = new ArrayList<String>();
        System.out.println("java.class.path=" + System.getProperty("java.class.path"));
        arguments.add("-cp");
        arguments.add(System.getProperty("java.class.path"));
        arguments.add(JAVAC_DESTINATION_OPTION);
        File destination = new File(this.getClassDest());
        if (!destination.exists()) {
            if (!destination.mkdir()) {
                throw new Exception("Unable to create directory: " + destination.getPath());
            }
        } else {
            List<File> class_files = FileListing.getFileListing(destination);
            if (class_files != null) {
                for (File class_file : class_files) {
                    if (class_file.delete()) continue;
                    throw new Exception("Unable to delete class file: " + class_file.getPath());
                }
            }
        }
        arguments.add(new File(this.getClassDest()).getCanonicalPath());
        for (File source : sources) {
            String absolute_path = source.getCanonicalPath();
            if (!absolute_path.endsWith(JAVA_SUFFIX)) continue;
            arguments.add(absolute_path);
        }
        System.out.println("arguments=" + ((Object)arguments).toString());
        return arguments;
    }

    private static JavaCompiler getJavaCompiler() throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new Exception("getSystemJavaCompiler() returns null");
        }
        return compiler;
    }

    public void fire() throws Exception {
        this.generateJdbcDAO();
        this.compileJdbcDAO();
        this.buildJdbcDAOJar();
    }

    public void buildJdbcDAOJar() throws FirestormException {
        try {
            File archive_file = new File(new URL(JdbcResourceManager.getJdbcDaoJarUrl()).toURI());
            File class_dir = new File(this.getClassDest());
            File[] to_be_jared = FileListing.getFileListing(class_dir).toArray(new File[0]);
            byte[] buffer = new byte[10240];
            FileOutputStream stream = new FileOutputStream(archive_file);
            JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
            int i = 0;
            while (i < to_be_jared.length) {
                if (to_be_jared[i] != null && to_be_jared[i].exists() && !to_be_jared[i].isDirectory()) {
                    int nRead;
                    String entry_name = to_be_jared[i].getAbsolutePath().substring(class_dir.getAbsolutePath().length() + 1).replace(File.separator, "/");
                    JarEntry entry = new JarEntry(entry_name);
                    entry.setTime(to_be_jared[i].lastModified());
                    out.putNextEntry(entry);
                    FileInputStream in = new FileInputStream(to_be_jared[i]);
                    while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                        out.write(buffer, 0, nRead);
                    }
                    in.close();
                }
                ++i;
            }
            out.close();
            stream.close();
        }
        catch (Exception e) {
            throw new FirestormException("Failed to build JDBC-DAO support layer JAR", e);
        }
    }

    public void dumpSchema() throws FirestormException {
        try {
            ProjectParser parser = new ProjectParser(this.getFireStormConfig());
            parser.writeProject(this.getFireStormProject(), new File(this.getProjectDest()));
        }
        catch (Exception e) {
            throw new FirestormException("Unable to dump the DB model", e);
        }
    }

    public String getHome() {
        if (this.home == null) {
            this.setHome();
        }
        return this.home;
    }

    public void setHome() {
        if (this.home == null) {
            try {
                URL home_url = this.getClass().getClassLoader().getResource(FIRESTORM);
                JarResources.copyResourcesRecursively(home_url, new File(Commons.TMP_DIR));
                File dir = new File(FIRESTORM_HOME);
                this.home = dir.getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.setProperty("home", this.home);
            System.out.println("Firestorm home set: " + this.home);
        }
    }

    public void setHome(URL seed_url) {
        if (this.home == null) {
            try {
                JarResources.copyResourcesRecursively(seed_url, new File(Commons.TMP_DIR));
                File dir = new File(FIRESTORM_HOME);
                this.home = dir.getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.setProperty("home", this.home);
            System.out.println("Firestorm home set: " + this.home);
        }
    }

    public String getDsname() {
        if (this.dsname == null) {
            this.dsname = System.getProperty(DSNAME_PROPERTY, "FishStatJ");
        }
        return this.dsname;
    }

    public void setDsname(String dsname) {
        this.dsname = dsname;
    }

    public String getSrcDest() {
        if (this.srcDest == null) {
            this.srcDest = System.getProperty(SRC_DEST_DIR_PROPERTY, DEFAULT_SRC_DEST_DIR_PROPERTY);
        }
        return this.srcDest;
    }

    public void setSrcDest(String dest) {
        this.srcDest = dest;
    }

    public int getLoggingStrategy() {
        if (this.loggingStrategy == 0) {
            this.loggingStrategy = Integer.valueOf(System.getProperty(LOGGING_STRATEGY_PROPERTY, DEFAULT_LOGGING_STRATEGY_PROPERTY));
        }
        return this.loggingStrategy;
    }

    public void setLoggingStrategy(int strategy) {
        this.loggingStrategy = strategy;
    }

    public String getClassDest() {
        if (this.classDest == null) {
            this.classDest = System.getProperty(CLASS_DEST_DIR_PROPERTY, DEFAULT_CLASS_DEST_DIR_PROPERTY);
        }
        return this.classDest;
    }

    public void setClasscDest(String dest) {
        this.classDest = dest;
    }

    public String getProjectDest() {
        if (this.prjDest == null) {
            this.prjDest = System.getProperty(PRJ_DEST_FILE_PROPERTY, String.valueOf(this.getHome()) + File.separator + DEFAULT_PRJ_DEST_FILE_PROPERTY);
        }
        return this.prjDest;
    }

    public void setProjectDest(String dest) {
        this.prjDest = dest;
    }

    public String getConfig() {
        if (this.config == null) {
            this.config = System.getProperty(CONFIG_FILE_PROPERTY, String.valueOf(this.getHome()) + File.separator + DEFAULT_CONFIG_FILE_PROPERTY);
        }
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getSrcBasePackage() {
        if (this.srcBasePackage == null) {
            this.srcBasePackage = System.getProperty(SRC_BASE_PACKAGE_PROPERTY, DEFAULT_SRC_BASE_PACKAGE_PROPERTY);
        }
        return this.srcBasePackage;
    }

    public void setSrcBasePackage(String base) {
        this.srcBasePackage = base;
    }
}

