/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import java.beans.Beans;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class MultilangualTabbedEditor
extends Composite {
    private MultilingualString mlString;
    private String lang;
    private CTabFolder tabFolder;
    private CTabItem[] tabitems;
    private Text[] textboxes;
    int textLimit;
    int langSize = 0;

    public MultilangualTabbedEditor(Composite parent, int style, MultilingualString mlString, String lang, int textLimit) {
        super(parent, style);
        this.lang = lang;
        this.mlString = mlString;
        this.langSize = MultilingualString.LANGUAGES.size();
        this.textboxes = new Text[this.langSize];
        this.tabitems = new CTabItem[this.langSize];
        this.textLimit = textLimit;
        this.initComponents();
        if (mlString != null) {
            this.syncroData();
        }
    }

    protected void checkSubclass() {
    }

    private void initComponents() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.tabFolder = new CTabFolder((Composite)this, 0);
        this.tabFolder.setSelectionForeground(ComponentsCommons.getColor(0, 0, 128));
        this.tabFolder.setSelectionBackground(new Color[]{Display.getCurrent().getSystemColor(22), Display.getCurrent().getSystemColor(32), Display.getCurrent().getSystemColor(32)}, new int[]{50, 100});
        this.tabFolder.setBorderVisible(true);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
        int i = 0;
        while (i < this.textboxes.length) {
            this.tabitems[i] = new CTabItem(this.tabFolder, 0);
            if (!Beans.isDesignTime()) {
                try {
                    Concept concept = ReferenceServiceFactory.getService().getConcept("LANGUAGE");
                    ReferenceObject langRO = concept.getObject("ISO_2_CODE", MultilingualString.LANGUAGES.get(i));
                    this.tabitems[i].setText(CoreUtils.getCurrentLang((MultilingualString)((MultilingualString)langRO.getAttribute("NAME")), (String)this.lang));
                }
                catch (ReferenceServiceException e) {
                    ComponentsCommons.showExceptionWithStack(e);
                }
            } else {
                this.tabitems[i].setText("lang " + i);
            }
            this.textboxes[i] = new Text((Composite)this.tabFolder, 0);
            GridData gd_text = new GridData(4, 4, true, false, 1, 1);
            gd_text.heightHint = -1;
            this.textboxes[i].setLayoutData((Object)gd_text);
            if (this.textLimit > 0) {
                this.textboxes[i].setTextLimit(this.textLimit);
            }
            this.tabitems[i].setControl((Control)this.textboxes[i]);
            ++i;
        }
        this.tabFolder.setSelection(this.tabitems[0]);
    }

    public MultilingualString getValue() {
        MultilingualString res = new MultilingualString();
        int i = 0;
        while (i < MultilingualString.LANGUAGES.size()) {
            res.setValue((String)MultilingualString.LANGUAGES.get(i), this.textboxes[i].getText().equals("") ? null : this.textboxes[i].getText());
            ++i;
        }
        return res;
    }

    public void syncroData() {
        int i = 0;
        while (i < this.textboxes.length) {
            if (this.textboxes[i] != null) {
                this.textboxes[i].setText(this.mlString.getValue((String)MultilingualString.LANGUAGES.get(i)) != null ? this.mlString.getValue((String)MultilingualString.LANGUAGES.get(i)) : "");
            }
            ++i;
        }
    }

    public void applyData() {
        int i = 0;
        while (i < this.textboxes.length) {
            if (this.textboxes[i] != null && this.textboxes[i].getText() != null) {
                this.mlString.setValue((String)MultilingualString.LANGUAGES.get(i), this.textboxes[i].getText());
            }
            ++i;
        }
    }

    public int getLangSize() {
        return this.langSize;
    }
}

