/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModelImpl;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class WorkspacesComboViewer
extends ComboViewer {
    private String lang;

    public WorkspacesComboViewer(Composite composite, int style, String lang) {
        super(composite, 0x10000000 | style);
        this.lang = lang;
        this.setContentProvider((IContentProvider)new WorkspacesContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new WorkspacesLabelProvider(this.lang));
        this.setComparator(new WorkpacesSorter(this.lang));
    }

    public Relationship getSelectedRelation() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (Relationship)sel.getFirstElement();
    }

    private class WorkpacesSorter
    extends ViewerComparator {
        private String lang;

        public WorkpacesSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof WorkspaceModelImpl && e2 instanceof WorkspaceModelImpl) {
                WorkspaceModelImpl wmd1 = (WorkspaceModelImpl)e1;
                WorkspaceModelImpl wmd2 = (WorkspaceModelImpl)e2;
                return wmd1.getName(this.lang).compareTo(wmd2.getName(this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class WorkspacesContentProvider
    implements IStructuredContentProvider {
        private WorkspacesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof String) {
                WorkspacesManager wsm = CoreCommons.getWorkspacesManager();
                List list = wsm.getWorkspacesByAcronym((String)inputElement);
                return list.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class WorkspacesLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private String lang;

        public WorkspacesLabelProvider(String lang) {
            this.lang = lang;
        }

        public String getText(Object element) {
            if (element instanceof WorkspaceModelImpl) {
                return String.valueOf(((WorkspaceModelImpl)element).getName(this.lang)) + " v" + ((WorkspaceModelImpl)element).getVersion().toString();
            }
            return null;
        }
    }
}

