/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.tables;

import java.beans.Beans;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.providers.CalculatedMesauresProvidersFactory;
import org.fao.fi.fishstat.gui.core.model.functions.CalculatedMeasureDefinitionWrapper;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;

public class CalculatedMeasuresTableViewer
extends Composite
implements Observer {
    private String lang;
    private Table table;
    private TableViewer tableViewer;
    private boolean comments;
    private CalculatedMeasuresProperties properties;

    public CalculatedMeasuresTableViewer(Composite parent, int style, CalculatedMeasuresProperties properties, boolean comments, String lang) {
        super(parent, style);
        this.lang = lang;
        this.properties = properties;
        this.comments = comments;
        this.initComponents();
        if (!Beans.isDesignTime()) {
            properties.addObserver((Observer)this);
        }
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.tableViewer = new TableViewer((Composite)this, 65538);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setForeground(ComponentsCommons.getColor(10));
        if (this.comments) {
            TableColumn nameColumn = new TableColumn(this.table, 0);
            if (!Beans.isDesignTime()) {
                nameColumn.setText(ComponentsActivator.getDefault().getLocalString("label.function.first.upper"));
            }
            nameColumn.setWidth(80);
            TableColumn descColumn = new TableColumn(this.table, 0);
            if (!Beans.isDesignTime()) {
                descColumn.setText(ComponentsActivator.getDefault().getLocalString("label.description.first.upper"));
            }
            descColumn.setWidth(720);
        }
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 346;
        gridData.heightHint = 228;
        this.table.setLayoutData((Object)gridData);
        if (!Beans.isDesignTime()) {
            this.tableViewer.setContentProvider((IContentProvider)CalculatedMesauresProvidersFactory.getContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)CalculatedMesauresProvidersFactory.getLabelProvider(this.lang));
            this.tableViewer.setComparator((ViewerComparator)CalculatedMesauresProvidersFactory.getSorter());
            this.tableViewer.setInput((Object)this.properties);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    protected class FunctionsSorter
    extends ViewerComparator {
        protected FunctionsSorter() {
        }

        public int compare(Viewer viewer, CalculatedMeasureDefinitionWrapper c1, CalculatedMeasureDefinitionWrapper c2) {
            return super.compare(viewer, (Object)c1.getMeasureName(), (Object)c1.getMeasureName());
        }
    }
}

