/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.keyvalue.MultiKey;
import org.apache.commons.collections15.map.AbstractHashedMap;
import org.apache.commons.collections15.map.LRUMap;
import org.apache.commons.collections15.map.MultiKeyMap;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;

public class ReferenceObjectCache {
    public static final int CACHE_MAX_SIZE = 2000;
    private static Map<Concept, ReferenceObjectCache> instances = Collections.synchronizedMap(new HashMap());
    private MultiKeyMap<String, ReferenceObject> cache = MultiKeyMap.decorate((AbstractHashedMap)new LRUMap(2000));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceObjectCache getCache(Concept concept) throws ReferenceServiceException {
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            if (!instances.containsKey(concept)) {
                instances.put(concept, new ReferenceObjectCache(concept));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instances.get(concept);
        }
    }

    private ReferenceObjectCache(Concept concept) throws ReferenceServiceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceObject put(Identifier identifier, ReferenceObject value) {
        if (value == null) {
            throw new IllegalArgumentException("The provided ReferenceObject can not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("The provided ReferenceObject identifier can not be null");
        }
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (ReferenceObject)this.cache.put(new MultiKey((Object[])new String[]{"ID", identifier.stringValue()}), (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceObject put(Attribute codeAttribute, Object codeAttributeValue, ReferenceObject value) {
        if (value == null) {
            throw new IllegalArgumentException("The provided ReferenceObject can not be null");
        }
        if (codeAttribute == null) {
            throw new IllegalArgumentException("The provided ReferenceObject code attribute can not be null");
        }
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return (ReferenceObject)this.cache.put(new MultiKey((Object[])new String[]{codeAttribute.getAcronym(), String.valueOf(codeAttributeValue)}), (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceObject get(Identifier identifier) {
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (ReferenceObject)this.cache.get((Object)new MultiKey((Object[])new String[]{"ID", identifier.stringValue()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceObject get(Attribute codeAttribute, Object codeAttributeValue) {
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (ReferenceObject)this.cache.get((Object)new MultiKey((Object[])new String[]{codeAttribute.getAcronym(), String.valueOf(codeAttributeValue)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceObject remove(Identifier identifier) {
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (ReferenceObject)this.cache.remove((Object)new MultiKey((Object[])new String[]{"ID", identifier.stringValue()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceObject remove(Attribute codeAttribute, Object codeAttributeValue) {
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (ReferenceObject)this.cache.remove((Object)new MultiKey((Object[])new String[]{codeAttribute.getAcronym(), String.valueOf(codeAttributeValue)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Class<ReferenceObjectCache> clazz = ReferenceObjectCache.class;
        synchronized (ReferenceObjectCache.class) {
            this.cache.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

