/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.beans.Statement;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.ISourceProviderService;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.autoupdate.AutoUpdateMain;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.PropertiesFactory;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.core.session.PersistenceFactory;
import org.fao.fi.fishstat.gui.handler.dynamics.SwitchWorkspaceState;
import org.fao.fi.fishstat.gui.views.GrandTotalsView;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class ApplicationAdvisor
implements Observer {
    private IWorkbenchPage activePage;
    private MultiTableView lastActiveMultiTableView;
    private static AutoUpdateMain autoupdate;
    private Vector<GrandTotalsView> activeTotalsViews = new Vector();

    public ApplicationAdvisor() {
        GuiCoreActivator.getDefault().getRegistry().addObserver((Observer)this);
        this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.addSiteListener(this.activePage);
        autoupdate = new AutoUpdateMain();
        autoupdate.doAutoupdate();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof CoreRegistry) {
            String methodName = ((Statement)arg).getMethodName();
            Session session = (Session)((Statement)arg).getTarget();
            if (methodName.equals("new")) {
                this.newSessionView(session);
            }
            if (methodName.equals("focus")) {
                this.focusSessionView(session);
            }
            if (methodName.equals("close")) {
                this.closeSessionView(session);
            }
        }
    }

    private void newSessionView(Session session) {
        try {
            this.activePage.hideView(this.activePage.findView("org.fao.fi.fishstat.gui.display.views.emptyview"));
            this.lastActiveMultiTableView = (MultiTableView)this.activePage.showView("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + session.getUUID(), 1);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.fao.fi.fishstat.gui.display.views.recorddetails");
            if (Activator.getDefault().getPreferenceStore().getBoolean("display.series.on.right")) {
                this.lastActiveMultiTableView.showLastPeriodOnNextRefresh();
            }
            session.setShowSeriesDetails(false);
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            service.executeCommand("org.fao.fi.fishstat.gui.command.view.show.details", null);
            Activator.getDefault().getStatusBarController().activateContributions();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "creating new session", (Throwable)e));
        }
    }

    private void focusSessionView(Session session) {
        IViewReference vr;
        if (session == GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus() && (vr = this.activePage.findViewReference("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + session.getUUID())) != null) {
            this.lastActiveMultiTableView = (MultiTableView)vr.getView(true);
            this.activePage.activate((IWorkbenchPart)this.lastActiveMultiTableView);
        }
        CoreCommons.getWorkspacesManager().refreshMenuHandlers();
    }

    public void closeSessionView(Session session) {
        if (this.activePage == null) {
            return;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), "close session view " + session.getDataset().getAcronym() + "." + session.getTimeseries().getAcronym()));
        try {
            this.hideAllGrandTotalViews();
            IViewReference vr = this.activePage.findViewReference("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + session.getUUID());
            if (vr != null) {
                this.activePage.hideView(vr);
            }
            if (GuiCoreActivator.getDefault().getRegistry().getOpenSessions().isEmpty() && !ApplicationWorkbenchAdvisor.shuttingDown) {
                Display.getDefault().asyncExec(() -> {
                    IViewPart detailsVr = this.activePage.findView("org.fao.fi.fishstat.gui.display.views.recorddetails");
                    if (detailsVr != null && !ApplicationWorkbenchAdvisor.shuttingDown) {
                        this.activePage.setPartState((IWorkbenchPartReference)this.activePage.findViewReference("org.fao.fi.fishstat.gui.display.views.recorddetails"), 0);
                        this.activePage.hideView(detailsVr);
                    }
                    try {
                        this.activePage.showView("org.fao.fi.fishstat.gui.display.views.emptyview");
                    }
                    catch (PartInitException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "showing empty view", (Throwable)e));
                    }
                });
            }
            this.lastActiveMultiTableView = null;
            Activator.getDefault().getStatusBarController().deactivateAllContribtions();
            CoreCommons.getWorkspacesManager().refreshMenuHandlers();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "close session view", (Throwable)e));
        }
        try {
            Thread.sleep(1200L);
        }
        catch (InterruptedException interruptedException) {}
        System.gc();
    }

    public IViewPart getLastActiveDoubleTableView() {
        return this.lastActiveMultiTableView;
    }

    public static AutoUpdateMain getAutoUpdate() {
        return autoupdate;
    }

    public void syncMenus() {
        WorkspacesManager wsm = CoreCommons.getWorkspacesManager();
        boolean isWorkspaceLoaded = wsm.hasCurrentWorkspace();
        ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        SwitchWorkspaceState commandStateService = (SwitchWorkspaceState)sourceProviderService.getSourceProvider("org.fao.fi.fishstat.gui.handler.dynamics.active");
        if (isWorkspaceLoaded) {
            commandStateService.setDisabled();
        } else if (wsm.getNumberOfWorkspaces() == 0) {
            commandStateService.setDisabled();
        } else {
            commandStateService.setEnabled();
        }
    }

    public void syncEditMenus(boolean active) {
        EvaluationContext ec = new EvaluationContext(null, (Object)active);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.getCommand("org.fao.fi.fishstat.gui.command.edit.csv.copy.details").setEnabled((Object)ec);
        commandService.getCommand("org.fao.fi.fishstat.gui.command.edit.csv.save.details").setEnabled((Object)ec);
    }

    private void addSiteListener(IWorkbenchPage activePage) {
        activePage.addPartListener(new IPartListener2(){

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                partRef.getId().equals("org.fao.fi.fishstat.gui.display.views.multitable");
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals("org.fao.fi.fishstat.gui.display.views.multitable")) {
                    MultiTableView multiTableView = (MultiTableView)partRef.getPart(true);
                    GuiSession session = multiTableView.getSession();
                    session.setCalcGrandTotals(false);
                    ApplicationWorkbenchAdvisor.getApplicationAdvisor().hideAllGrandTotalViews();
                    GuiCoreActivator.getDefault().getRegistry().setSessionOnFocus(session.getDescriptor());
                }
            }
        });
    }

    public void hideAllGrandTotalViews() {
        int i = 0;
        while (i < this.activeTotalsViews.size()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.activeTotalsViews.get(i));
            ++i;
        }
        this.activeTotalsViews = new Vector();
        for (Session aSession : GuiCoreActivator.getDefault().getRegistry().getOpenSessions()) {
            aSession.setCalcGrandTotals(false);
        }
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        service.refreshElements("org.fao.fi.fishstat.gui.command.view.show.grandtotals", null);
    }

    public void activateAllGrandTotalViews(Session session) {
        if (!session.getCalcGrandTotals()) {
            return;
        }
        try {
            GrandTotalsView grandTotalsView = null;
            IWorkbenchPart selectedTabID = null;
            for (ReferenceObject measure : session.getTimeseries().getObsMeasures()) {
                String secondaryID = ApplicationAdvisor.getGrandTotalSecondaryId(session, measure);
                String grandTotalName = ((MultilingualString)measure.getAttribute(measure.getConcept().getNameAttribute())).getValue("en");
                grandTotalsView = (GrandTotalsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.fao.fi.fishstat.gui.display.views.grandtotals", secondaryID, 1);
                grandTotalsView.populateView();
                grandTotalsView.loadTotalsCells();
                this.activeTotalsViews.add(grandTotalsView);
                if (grandTotalName.toLowerCase().indexOf("tonnes") == -1) continue;
                selectedTabID = grandTotalsView.getSite().getPart();
            }
            if (selectedTabID != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(selectedTabID);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "grand total view setup", (Throwable)e));
        }
    }

    private static String getGrandTotalSecondaryId(Session session, ReferenceObject measure) {
        if (measure == null || measure == ReferenceObject.ALL) {
            return String.valueOf(session.getDescriptor().getUuid().toString()) + "-[unique]";
        }
        return String.valueOf(session.getDescriptor().getUuid().toString()) + "-" + measure.getId();
    }

    public static void workspaceClose() {
        try {
            WorkspacesManager wsm = CoreCommons.getWorkspacesManager();
            if (Activator.getDefault().getPreferenceStore().getBoolean("core.persist.work.session")) {
                ApplicationAdvisor.persistSessionPreferences(wsm);
            }
            List openSessions = GuiCoreActivator.getDefault().getRegistry().getOpenSessions();
            for (Session activitySession : openSessions) {
                ApplicationWorkbenchAdvisor.getApplicationAdvisor().closeSessionView(activitySession);
            }
            GuiCoreActivator.getDefault().getRegistry().closeAllSessions();
            PropertiesFactory.resetRegistry();
            wsm.closeCurrentWorkspace();
            Activator.getDefault().setApplicationTitlePostfix("");
            Activator.getDefault().getPreferenceStore().setValue("core.current.workspace.id", wsm.hasCurrentWorkspace() ? wsm.getCurrentWorkspace().getWsBaseDir().getAbsolutePath() : "");
            ApplicationWorkbenchAdvisor.getApplicationAdvisor().syncMenus();
            ApplicationAdvisor.resetView();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ApplicationAdvisor.class.getName(), "closing workspace", (Throwable)e));
        }
    }

    private static void persistSessionPreferences(WorkspacesManager wsm) {
        try {
            if (wsm.hasCurrentWorkspace() && PersistenceFactory.getSaveOnExit()) {
                PersistenceFactory.persistWorkingSession();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ApplicationAdvisor.class.getName(), "presisting session", (Throwable)e));
        }
    }

    private static void resetView() throws PartInitException {
        IViewReference[] activePageViewReferences;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePageViewReferences = activePage.getViewReferences();
        int n = activePageViewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            activePage.hideView(viewReference);
            ++n2;
        }
        activePage.showView("org.fao.fi.fishstat.gui.display.views.emptyview");
    }

    public static void workspaceOpen(String workspacePath) {
        try {
            WorkspacesManager wsm = CoreCommons.getWorkspacesManager();
            wsm.switchWorkspace(workspacePath);
            Activator.getDefault().setApplicationTitlePostfix(wsm.getCurrentWorkspace().getName(Activator.getLanguage()));
            if (Activator.getDefault().getPreferenceStore().getBoolean("core.persist.work.session")) {
                ApplicationWorkbenchAdvisor.getPrecedentSession();
            }
            Activator.getDefault().getPreferenceStore().setValue("core.current.workspace.id", workspacePath);
            ApplicationWorkbenchAdvisor.getApplicationAdvisor().syncMenus();
            if (wsm.getCurrentWorkspace().getCompatibility().getMajor() == 4 && wsm.getCurrentWorkspace().getCompatibility().getMinor() < 4) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)(String.valueOf(Activator.getPluginBundle().getString("appadvisor.workspace.text")) + " " + wsm.getCurrentWorkspace().getAcronym() + " v" + wsm.getCurrentWorkspace().getVersion().toString()), (String)(String.valueOf(Activator.getPluginBundle().getString("appadvisor.workspace.outdated.message")) + "\n\nc=" + wsm.getCurrentWorkspace().getCompatibility().toString()));
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, ApplicationAdvisor.class.getName(), "open workspace", (Throwable)e));
        }
    }
}

