/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.aggregation;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;

public class AggregationTreeContentProvider
implements ITreeContentProvider {
    private DimensionAggregation aggregation;
    private char type;

    public AggregationTreeContentProvider(DimensionAggregation aggregation, char type) {
        this.aggregation = aggregation;
        this.type = type;
    }

    public Dimension getDimension() {
        return this.aggregation.getDimension();
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = new ReferenceObject[]{};
        if (parentElement instanceof Concept) {
            if (this.type == 'I') {
                return this.aggregation.getIncludes((Concept)parentElement).toArray(result);
            }
            if (this.type == 'E') {
                return this.aggregation.getExcludes((Concept)parentElement).toArray(result);
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof ReferenceObject) {
            return ((ReferenceObject)element).getConcept();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Concept;
    }

    public Object[] getElements(Object inputElement) {
        Enumeration parents = null;
        if (this.type == 'I') {
            parents = this.aggregation.getIncludeParents();
        } else if (this.type == 'E') {
            parents = this.aggregation.getExcludeParents();
        }
        Vector<Concept> result = new Vector<Concept>(this.aggregation.getAllParentsSize());
        while (parents.hasMoreElements()) {
            result.add((Concept)parents.nextElement());
        }
        return result.toArray(new Concept[0]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

