/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.reference.groups;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModel;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupModelImpl;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.widgets.tables.CustomGroupsTableViewer;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.reference.groups.CustomGroupDialog;

public class DimensionGroupsPanel
extends Composite {
    private Dimension dimension;
    private Table groupsList;
    private CustomGroupsTableViewer groupsTableViewer;
    private Button copyButton;
    private Button editButton;
    private Button deleteButton;
    private Button createButton;
    private Composite compositeRight;
    private Composite compositeLeft;

    public DimensionGroupsPanel(Composite parent, int style, Dimension dimension) {
        super(parent, style);
        this.dimension = dimension;
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.compositeLeft = new Composite((Composite)this, 0);
        this.compositeLeft.setBackground(SWTResourceManager.getColor(1));
        GridData gd_compositeLeft = new GridData(16384, 4, false, true);
        gd_compositeLeft.heightHint = 239;
        gd_compositeLeft.widthHint = 339;
        this.compositeLeft.setLayoutData((Object)gd_compositeLeft);
        GridLayout gl_compositeLeft = new GridLayout();
        gl_compositeLeft.horizontalSpacing = 0;
        gl_compositeLeft.verticalSpacing = 0;
        this.compositeLeft.setLayout((Layout)gl_compositeLeft);
        this.groupsTableViewer = new CustomGroupsTableViewer(this.compositeLeft, 2560, this.dimension, Activator.getLanguage());
        this.groupsTableViewer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.groupsTableViewer.getTableViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection strsel = (StructuredSelection)DimensionGroupsPanel.this.groupsTableViewer.getSelection();
                if (strsel.size() > 0) {
                    CustomGroupModel model = (CustomGroupModel)strsel.getFirstElement();
                    DimensionGroupsPanel.this.groupEditorDialog(model);
                }
            }
        });
        this.groupsList = this.groupsTableViewer.getTableViewer().getTable();
        this.groupsList.setForeground(SWTResourceManager.getColor(10));
        this.groupsList.setFont(ComponentsCommons.getFont((String)"MS Sans Serif", (int)9, (int)1));
        GridData gd_groupsList = new GridData(4, 4, true, true);
        gd_groupsList.heightHint = 209;
        gd_groupsList.widthHint = 300;
        this.groupsList.setLayoutData((Object)gd_groupsList);
        this.compositeRight = new Composite((Composite)this, 0);
        this.compositeRight.setBackground(SWTResourceManager.getColor(255, 255, 255));
        GridData gd_compositeRight = new GridData(4, 4, true, false);
        gd_compositeRight.widthHint = 161;
        this.compositeRight.setLayoutData((Object)gd_compositeRight);
        this.compositeRight.setLayout((Layout)new GridLayout());
        this.createButton = new Button(this.compositeRight, 0x800000);
        this.createButton.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.createButton.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/apps/chart_organisation.png"));
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionGroupsPanel.this.groupEditorDialog(null);
            }
        });
        this.createButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createButton.setText(Activator.getLocalString("label.new.first.upper.dots"));
        this.deleteButton = new Button(this.compositeRight, 0x800000);
        this.deleteButton.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.deleteButton.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/deletecustomgroup.gif"));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionGroupsPanel.this.deleteSelectedGroup();
            }
        });
        this.deleteButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.deleteButton.setText(Activator.getLocalString("label.delete.first.upper.dots"));
        this.editButton = new Button(this.compositeRight, 0x800000);
        this.editButton.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/edit.gif"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection strsel = (StructuredSelection)DimensionGroupsPanel.this.groupsTableViewer.getSelection();
                if (strsel.size() > 0) {
                    CustomGroupModel model = (CustomGroupModel)strsel.getFirstElement();
                    DimensionGroupsPanel.this.groupEditorDialog(model);
                }
            }
        });
        this.editButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.editButton.setText(Activator.getLocalString("label.edit.first.upper.dots"));
        this.copyButton = new Button(this.compositeRight, 0x800000);
        this.copyButton.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/copy.gif"));
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection strsel = (StructuredSelection)DimensionGroupsPanel.this.groupsTableViewer.getSelection();
                if (strsel.size() > 0) {
                    CustomGroupModel model = (CustomGroupModel)strsel.getFirstElement();
                    try {
                        DimensionGroupsPanel.this.groupEditorDialog((CustomGroupModel)model.createCopy(String.valueOf(Activator.getLocalString("label.copy.of")) + " "));
                    }
                    catch (Exception ex) {
                        ComponentsCommons.showExceptionWithStack((Throwable)ex);
                    }
                }
            }
        });
        this.copyButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.copyButton.setText(Activator.getLocalString("label.copy.first.upper.dots"));
    }

    private void groupEditorDialog(CustomGroupModel model) {
        try {
            CustomGroupDialog dlg;
            GuiSession session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
            DatasetProperties properties = session.getDatasetProperties();
            if (model == null) {
                model = new CustomGroupModelImpl(this.dimension.getConcept());
            }
            if ((dlg = new CustomGroupDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), model, properties.getDimensionsProperties(this.dimension))).open() == 0) {
                this.groupsTableViewer.getTableViewer().setInput((Object)this.dimension);
            }
        }
        catch (Exception e) {
            ComponentsCommons.showExceptionWithStack((Throwable)e);
        }
    }

    private void deleteSelectedGroup() {
        try {
            StructuredSelection strsel = (StructuredSelection)this.groupsTableViewer.getSelection();
            if (strsel.size() > 0) {
                CustomGroupModel model = (CustomGroupModel)strsel.getFirstElement();
                CustomGroupFactory.remove((Identifier)model.getId());
            }
        }
        catch (Exception e) {
            ComponentsCommons.showExceptionWithStack((Throwable)e);
        }
        this.groupsTableViewer.getTableViewer().setInput((Object)this.dimension);
    }
}

