/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.api.io.csv;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.fao.fi.fishstat.data.api.io.csv.DenormalisedTimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.NormalisedTimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.TimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.api.io.csv.impl.DenormalisedTimeseriesCSVMetadataImpl;
import org.fao.fi.fishstat.data.api.io.csv.impl.NormalisedTimeseriesCSVMetadataImpl;
import org.fao.fi.fishstat.data.api.io.exceptions.FSIOException;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.csv.ValidationResult;
import org.fao.fi.fishstat.data.common.api.csv.impl.ValidationReporter;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureFactory;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class TimeseriesCSVService {
    private static TimeseriesCSVService instance;

    public static TimeseriesCSVService instance() {
        if (instance == null) {
            instance = new TimeseriesCSVService();
        }
        return instance;
    }

    public void upload(Timeseries timeseries, Reader input, TimeseriesCSVMetadata metadata, boolean truncate) throws FSIOException {
        try {
            if (timeseries == null) {
                throw new FSIOException("Timeseries can not be null");
            }
            if (input == null) {
                throw new FSIOException("Input CSV can not be null");
            }
            if (metadata == null) {
                metadata = this.createDenormalisedMetadata(timeseries);
            }
            List<ObservationSeries> series_list = this._load(timeseries, input, metadata);
            if (truncate) {
                timeseries.clean();
            }
            timeseries.add(series_list);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to load timeseries", e);
        }
    }

    public ValidationResult validate(Timeseries timeseries, Reader input, TimeseriesCSVMetadata metadata) throws FSIOException {
        ValidationReporter reporter;
        block56: {
            reporter = new ValidationReporter();
            try {
                if (timeseries == null) {
                    throw new FSIOException("Timeseries can not be null");
                }
                if (input == null) {
                    throw new FSIOException("Input CSV can not be null");
                }
                if (metadata == null) {
                    throw new FSIOException("CSV metadata can not be null");
                }
                CsvReader reader = new CsvReader(input, ',');
                this.checkHeaders(timeseries, reader, metadata);
                if (metadata instanceof DenormalisedTimeseriesCSVMetadata) {
                    DenormalisedTimeseriesCSVMetadata denormalised_metadata = (DenormalisedTimeseriesCSVMetadata)metadata;
                    while (reader.readRecord()) {
                        try {
                            for (Dimension dimension : timeseries.getDataset().getDimensions()) {
                                Concept concept = dimension.getConcept();
                                ReferenceObject key = null;
                                String code = null;
                                if (denormalised_metadata.useHeaders()) {
                                    String header = denormalised_metadata.getDimensionHeader(concept.getAcronym());
                                    code = reader.get(header);
                                } else {
                                    int column = denormalised_metadata.getDimensionColumn(concept.getAcronym());
                                    code = reader.get(column);
                                }
                                if (code == null || code.length() == 0) {
                                    throw new FSIOException("Null or empty key value read for: " + concept.getAcronym(), reader.getCurrentRecord() + 1L);
                                }
                                String reference_attribute = denormalised_metadata.getDimensionAttribute(concept.getAcronym());
                                if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                                    Identifier id = null;
                                    try {
                                        id = IdentifierFactory.instance((String)code);
                                    }
                                    catch (Exception e) {
                                        throw new FSIOException("Key value is not an identifier: " + code, e, reader.getCurrentRecord() + 1L);
                                    }
                                    key = concept.getObject(id);
                                } else {
                                    try {
                                        Attribute attribute = concept.getAttribute(reference_attribute);
                                        if (attribute != null) {
                                            Constructor constructor = attribute.getType().getRuntimeType().getConstructor(String.class);
                                            Object attribute_value = constructor.newInstance(code);
                                            if (attribute.isCodeAttribute()) {
                                                key = concept.getObject(reference_attribute, attribute_value);
                                            } else {
                                                Collection candidate_keys = concept.getObjects(attribute, attribute_value);
                                                if (candidate_keys.size() == 1) {
                                                    key = (ReferenceObject)new ArrayList(candidate_keys).get(0);
                                                }
                                            }
                                        }
                                    }
                                    catch (ReferenceServiceException e) {
                                        throw new FSIOException("Unable to get reference object for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, e, reader.getCurrentRecord() + 1L);
                                    }
                                }
                                if (key != null) continue;
                                throw new FSIOException("No matching reference object found for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, reader.getCurrentRecord() + 1L);
                            }
                            for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                                String value = null;
                                if (denormalised_metadata.useHeaders()) {
                                    String value_header = denormalised_metadata.getMeasureValueHeader(period.toString());
                                    value = reader.get(value_header);
                                } else {
                                    int value_column = denormalised_metadata.getMeasureValueColumn(period.toString());
                                    value = reader.get(value_column);
                                }
                                if (value == null || value.length() == 0) {
                                    throw new FSIOException("Null or empty value read for period: " + period, reader.getCurrentRecord() + 1L);
                                }
                                try {
                                    Double.valueOf(value);
                                }
                                catch (Exception e) {
                                    throw new FSIOException("Unable to parse the observation value: " + period + "=" + value, e, reader.getCurrentRecord() + 1L);
                                }
                            }
                        }
                        catch (FSIOException te) {
                            reporter.error(te.getCSVRowCount(), te.getPlainMessage());
                        }
                        catch (Exception e) {
                            reporter.fatal(reader.getCurrentRecord() + 1L, "Unexpected fatal error found validating CSV record: " + e.getMessage());
                        }
                    }
                    break block56;
                }
                NormalisedTimeseriesCSVMetadata normalised_metadata = (NormalisedTimeseriesCSVMetadata)metadata;
                while (reader.readRecord()) {
                    try {
                        for (Dimension dimension : timeseries.getDataset().getDimensions()) {
                            Concept concept = dimension.getConcept();
                            ReferenceObject key = null;
                            String code = null;
                            if (normalised_metadata.useHeaders()) {
                                String header = normalised_metadata.getDimensionHeader(concept.getAcronym());
                                code = reader.get(header);
                            } else {
                                int column = normalised_metadata.getDimensionColumn(concept.getAcronym());
                                code = reader.get(column);
                            }
                            if (code == null || code.length() == 0) {
                                throw new FSIOException("Null key value read for: " + concept.getAcronym(), reader.getCurrentRecord() + 1L);
                            }
                            String reference_attribute = normalised_metadata.getDimensionAttribute(concept.getAcronym());
                            if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                                Identifier id = null;
                                try {
                                    id = IdentifierHelper.instance((String)code);
                                }
                                catch (Exception e) {
                                    throw new FSIOException("Key value is not an identifier: " + code, e, reader.getCurrentRecord() + 1L);
                                }
                                key = concept.getObject(id);
                            } else {
                                try {
                                    Attribute attribute = concept.getAttribute(reference_attribute);
                                    switch (attribute.getType().getJdbcType()) {
                                        case -5: {
                                            key = concept.getObject(reference_attribute, (Object)Long.valueOf(code));
                                            break;
                                        }
                                        default: {
                                            key = concept.getObject(reference_attribute, (Object)code);
                                            break;
                                        }
                                    }
                                }
                                catch (ReferenceServiceException e) {
                                    throw new FSIOException("Unable to get reference object for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, e, reader.getCurrentRecord() + 1L);
                                }
                            }
                            if (key != null) continue;
                            throw new FSIOException("No reference object found for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, reader.getCurrentRecord() + 1L);
                        }
                        String period = null;
                        if (normalised_metadata.useHeaders()) {
                            String header = normalised_metadata.getPeriodHeader();
                            period = reader.get(header);
                        } else {
                            int column = normalised_metadata.getPeriodColumn();
                            period = reader.get(column);
                        }
                        if (period == null || period.length() == 0) {
                            throw new FSIOException("Null or empty value read for period", reader.getCurrentRecord() + 1L);
                        }
                        ObservationPeriod observation_period = new ObservationPeriod(period);
                        if (!timeseries.getObservationPeriods().contains(observation_period)) {
                            throw new FSIOException("Period out of bound: " + period, reader.getCurrentRecord() + 1L);
                        }
                        String value = null;
                        if (normalised_metadata.useHeaders()) {
                            String value_header = normalised_metadata.getMeasureValueHeader();
                            value = reader.get(value_header);
                        } else {
                            int value_column = normalised_metadata.getMeasureValueColumn();
                            value = reader.get(value_column);
                        }
                        if (value == null || value.length() == 0) {
                            throw new FSIOException("Null or empty value read for period: " + period, reader.getCurrentRecord() + 1L);
                        }
                        try {
                            Double.valueOf(value);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Unable to parse the observation value: " + period + "=" + value, e, reader.getCurrentRecord() + 1L);
                        }
                    }
                    catch (FSIOException te) {
                        reporter.error(te.getCSVRowCount(), te.getPlainMessage());
                    }
                    catch (Exception e) {
                        reporter.fatal(reader.getCurrentRecord() + 1L, "Unexpected fatal error found validating CSV record: " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                reporter.fatal("T1 Unexpected fatal error found validating CSV file: " + e.getMessage());
            }
        }
        return reporter.getResult();
    }

    private void checkHeaders(Timeseries timeseries, CsvReader reader, TimeseriesCSVMetadata metadata) throws Exception {
        List<String> headers = null;
        if (metadata.useHeaders()) {
            if (!reader.readHeaders()) {
                throw new FSIOException("CSV header could not be read");
            }
            headers = Arrays.asList(reader.getHeaders());
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        for (Concept concept : timeseries.getDataset().getConcepts()) {
            String reference_attribute;
            if (metadata.useHeaders()) {
                String header = metadata.getDimensionHeader(concept.getAcronym());
                if (header == null) {
                    throw new FSIOException("No CSV metadata header provided for dimension: " + concept.getAcronym());
                }
                if (!headers.contains(header)) {
                    throw new FSIOException("Expected CSV metadata header not found: " + header);
                }
            } else {
                int column = metadata.getDimensionColumn(concept.getAcronym());
                if (column == -1) {
                    throw new FSIOException("No CSV metadata column provided for dimension: " + concept.getAcronym());
                }
                if (column >= reader.getColumnCount()) {
                    throw new FSIOException("CSV metadata column provided for dimension: " + concept.getAcronym() + " is out of bound: " + column);
                }
            }
            if ((reference_attribute = metadata.getDimensionAttribute(concept.getAcronym())) != null) continue;
            throw new FSIOException("No CSV metadata reference attribute provided for dimension: " + concept.getAcronym());
        }
        if (metadata instanceof DenormalisedTimeseriesCSVMetadata) {
            DenormalisedTimeseriesCSVMetadata denormalised_metadata = (DenormalisedTimeseriesCSVMetadata)metadata;
            for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                if (denormalised_metadata.useHeaders()) {
                    String value_header = denormalised_metadata.getMeasureValueHeader(period.toString());
                    if (value_header == null) {
                        throw new FSIOException("No CSV metadata value header provided for period: " + period);
                    }
                    if (headers.contains(value_header)) continue;
                    throw new FSIOException("Expected CSV metadata value header not found: " + value_header);
                }
                int value_column = denormalised_metadata.getMeasureValueColumn(period.toString());
                if (value_column == -1) {
                    throw new FSIOException("No CSV metadata value column provided for period: " + period);
                }
                if (value_column < reader.getColumnCount()) continue;
                throw new FSIOException("CSV metadata column provided for period: " + period + " is out of bound: " + value_column);
            }
        } else {
            NormalisedTimeseriesCSVMetadata normalised_metadata = (NormalisedTimeseriesCSVMetadata)metadata;
            if (normalised_metadata.useHeaders()) {
                String header = normalised_metadata.getPeriodHeader();
                if (header == null) {
                    throw new FSIOException("No CSV metadata header provided for period");
                }
                if (!headers.contains(header)) {
                    throw new FSIOException("Expected CSV metadata header not found: " + header);
                }
            } else {
                int column = normalised_metadata.getPeriodColumn();
                if (column == -1) {
                    throw new FSIOException("No CSV metadata column provided for period");
                }
                if (column >= reader.getColumnCount()) {
                    throw new FSIOException("CSV metadata column provided for period is out of bound: " + column);
                }
            }
            if (normalised_metadata.useHeaders()) {
                String value_header = normalised_metadata.getMeasureValueHeader();
                if (value_header == null) {
                    throw new FSIOException("No CSV metadata value header provided", 0L);
                }
                if (!headers.contains(value_header)) {
                    throw new FSIOException("Expected CSV metadata value header not found: " + value_header);
                }
            } else {
                int value_column = normalised_metadata.getMeasureValueColumn();
                if (value_column == -1) {
                    throw new FSIOException("No CSV metadata value column provided", 0L);
                }
                if (value_column >= reader.getColumnCount()) {
                    throw new FSIOException("CSV metadata column provided for value is out of bound: " + value_column);
                }
            }
        }
    }

    private List<ObservationSeries> _load(Timeseries timeseries, Reader input, TimeseriesCSVMetadata metadata) throws Exception {
        ArrayList<ObservationSeries> series_list = new ArrayList<ObservationSeries>();
        CsvReader reader = new CsvReader(input, ',');
        if (metadata.useHeaders()) {
            reader.readHeaders();
        }
        if (metadata.useTextQualifier()) {
            reader.setTextQualifier(metadata.getTextQualifier());
        }
        if (metadata instanceof DenormalisedTimeseriesCSVMetadata) {
            DenormalisedTimeseriesCSVMetadata denormalised_metadata = (DenormalisedTimeseriesCSVMetadata)metadata;
            while (reader.readRecord()) {
                ObservationSeries series = timeseries.create();
                ArrayList<ReferenceObject> keys = new ArrayList<ReferenceObject>();
                for (Dimension dimension : timeseries.getDataset().getDimensions()) {
                    Concept concept = dimension.getConcept();
                    ReferenceObject key = null;
                    String code = null;
                    if (denormalised_metadata.useHeaders()) {
                        String header = denormalised_metadata.getDimensionHeader(concept.getAcronym());
                        code = reader.get(header);
                    } else {
                        int column = denormalised_metadata.getDimensionColumn(concept.getAcronym());
                        code = reader.get(column);
                    }
                    if (code == null || code.length() == 0) {
                        throw new FSIOException("Null or empty key value read for: " + concept.getAcronym(), reader.getCurrentRecord() + 1L);
                    }
                    String reference_attribute = denormalised_metadata.getDimensionAttribute(concept.getAcronym());
                    if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                        Identifier id = null;
                        try {
                            id = IdentifierFactory.instance((String)code);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Key value is not an identifier: " + code, e, reader.getCurrentRecord() + 1L);
                        }
                        key = concept.getObject(id);
                    } else {
                        try {
                            Attribute attribute = concept.getAttribute(reference_attribute);
                            if (attribute != null) {
                                Constructor constructor = attribute.getType().getRuntimeType().getConstructor(String.class);
                                Object attribute_value = constructor.newInstance(code);
                                if (attribute.isCodeAttribute()) {
                                    key = concept.getObject(reference_attribute, attribute_value);
                                } else {
                                    Collection candidate_keys = concept.getObjects(attribute, attribute_value);
                                    if (candidate_keys.size() == 1) {
                                        key = (ReferenceObject)new ArrayList(candidate_keys).get(0);
                                    }
                                }
                            }
                        }
                        catch (ReferenceServiceException e) {
                            throw new FSIOException("Unable to get reference object for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, e, reader.getCurrentRecord() + 1L);
                        }
                    }
                    if (key == null) {
                        throw new FSIOException("No matching reference object found for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + code, reader.getCurrentRecord() + 1L);
                    }
                    keys.add(key);
                }
                series.setKeys(new MultiReferenceObject(keys));
                LinkedHashMap<ObservationPeriod, Measure> measures = new LinkedHashMap<ObservationPeriod, Measure>();
                for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                    String value = null;
                    String status = null;
                    if (denormalised_metadata.useHeaders()) {
                        String value_header = denormalised_metadata.getMeasureValueHeader(period.toString());
                        value = reader.get(value_header);
                        String status_header = denormalised_metadata.getMeasureStatusHeader(period.toString());
                        if (status_header != null) {
                            status = reader.get(status_header);
                        }
                    } else {
                        int value_column = denormalised_metadata.getMeasureValueColumn(period.toString());
                        value = reader.get(value_column);
                        int status_column = denormalised_metadata.getMeasureStatusColumn(period.toString());
                        if (status_column != -1 && status_column < reader.getColumnCount()) {
                            status = reader.get(status_column);
                        }
                    }
                    if (value == null || value.length() == 0) {
                        throw new FSIOException("Null or empty value read for period: " + period, reader.getCurrentRecord() + 1L);
                    }
                    Measure measure = MeasureFactory.create();
                    measure.setStatus(new MeasureStatus(status));
                    Double d_value = null;
                    try {
                        d_value = Double.valueOf(value);
                    }
                    catch (Exception e) {
                        throw new FSIOException("Unable to parse the observation value: " + period + "=" + value, e, reader.getCurrentRecord() + 1L);
                    }
                    measure.setValue(d_value.doubleValue());
                    measures.put(period, measure);
                }
                series.setMeasures(measures);
                series_list.add(series);
            }
        } else {
            NormalisedTimeseriesCSVMetadata normalised_metadata = (NormalisedTimeseriesCSVMetadata)metadata;
            HashMap<MultiReferenceObject, ObservationSeries> series_map = new HashMap<MultiReferenceObject, ObservationSeries>();
            while (reader.readRecord()) {
                ArrayList<ReferenceObject> keys = new ArrayList<ReferenceObject>();
                for (Dimension dimension : timeseries.getDataset().getDimensions()) {
                    Concept concept = dimension.getConcept();
                    ReferenceObject key = null;
                    Object code = null;
                    if (normalised_metadata.useHeaders()) {
                        String header = normalised_metadata.getDimensionHeader(concept.getAcronym());
                        code = reader.get(header);
                    } else {
                        int column = normalised_metadata.getDimensionColumn(concept.getAcronym());
                        code = reader.get(column);
                    }
                    if (code == null || ((String)code).length() == 0) {
                        throw new FSIOException("Null key value read for: " + concept.getAcronym(), reader.getCurrentRecord() + 1L);
                    }
                    String reference_attribute = normalised_metadata.getDimensionAttribute(concept.getAcronym());
                    if (reference_attribute == null || reference_attribute.equalsIgnoreCase("ID")) {
                        Identifier id = null;
                        try {
                            id = IdentifierHelper.instance((String)code);
                        }
                        catch (Exception e) {
                            throw new FSIOException("Key value is not an identifier: " + (String)code, e, reader.getCurrentRecord() + 1L);
                        }
                        key = concept.getObject(id);
                    } else {
                        try {
                            Attribute attribute = concept.getAttribute(reference_attribute);
                            switch (attribute.getType().getJdbcType()) {
                                case -5: {
                                    key = concept.getObject(reference_attribute, (Object)Long.valueOf((String)code));
                                    break;
                                }
                                default: {
                                    key = concept.getObject(reference_attribute, code);
                                    break;
                                }
                            }
                        }
                        catch (ReferenceServiceException e) {
                            throw new FSIOException("Unable to get reference object for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + (String)code, e, reader.getCurrentRecord() + 1L);
                        }
                    }
                    if (key == null) {
                        throw new FSIOException("No reference object found for dimension: " + concept.getAcronym() + ", " + reference_attribute + "=" + (String)code, reader.getCurrentRecord() + 1L);
                    }
                    keys.add(key);
                }
                MultiReferenceObject multi_key = new MultiReferenceObject(keys);
                ObservationSeries series = (ObservationSeries)series_map.get(multi_key);
                if (series == null) {
                    series = timeseries.create();
                    series.setKeys(multi_key);
                    LinkedHashMap<ObservationPeriod, Measure> measures = new LinkedHashMap<ObservationPeriod, Measure>();
                    for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                        measures.put(period, MeasureFactory.create());
                    }
                    series.setMeasures(measures);
                    series_map.put(multi_key, series);
                }
                String period = null;
                if (normalised_metadata.useHeaders()) {
                    String header = normalised_metadata.getPeriodHeader();
                    period = reader.get(header);
                } else {
                    int column = normalised_metadata.getPeriodColumn();
                    period = reader.get(column);
                }
                if (period == null || period.length() == 0) {
                    throw new FSIOException("Null or empty value read for period", reader.getCurrentRecord() + 1L);
                }
                ObservationPeriod observation_period = new ObservationPeriod(period);
                if (!timeseries.getObservationPeriods().contains(observation_period)) {
                    throw new FSIOException("Period out of bound: " + period, reader.getCurrentRecord() + 1L);
                }
                Measure measure = series.getMeasure(observation_period);
                String value = null;
                String status = null;
                if (normalised_metadata.useHeaders()) {
                    String value_header = normalised_metadata.getMeasureValueHeader();
                    value = reader.get(value_header);
                    String status_header = normalised_metadata.getMeasureStatusHeader();
                    if (status_header != null) {
                        status = reader.get(status_header);
                    }
                } else {
                    int value_column = normalised_metadata.getMeasureValueColumn();
                    value = reader.get(value_column);
                    int status_column = normalised_metadata.getMeasureStatusColumn();
                    if (status_column != -1 && status_column < reader.getColumnCount()) {
                        status = reader.get(status_column);
                    }
                }
                if (value == null || value.length() == 0) {
                    throw new FSIOException("Null or empty value read for period: " + period, reader.getCurrentRecord() + 1L);
                }
                measure.setStatus(new MeasureStatus(status));
                Double d_value = null;
                try {
                    d_value = Double.valueOf(value);
                }
                catch (Exception e) {
                    throw new FSIOException("Unable to parse the observation value: " + period + "=" + value, e, reader.getCurrentRecord() + 1L);
                }
                measure.setValue(d_value.doubleValue());
            }
            series_list.addAll(series_map.values());
        }
        reader.close();
        return series_list;
    }

    public void download(Timeseries timeseries, Writer output, TimeseriesCSVMetadata metadata) throws FSIOException {
        try {
            if (timeseries == null) {
                throw new FSIOException("Timeseries can not be null");
            }
            if (output == null) {
                throw new FSIOException("Output CSV can not be null");
            }
            if (metadata == null) {
                metadata = new DenormalisedTimeseriesCSVMetadataImpl(timeseries);
            }
            this._download(timeseries, output, metadata);
        }
        catch (FSIOException csve) {
            throw csve;
        }
        catch (Exception e) {
            throw new FSIOException("Unable to download timeseries", e);
        }
    }

    private void _download(Timeseries timeseries, Writer output, TimeseriesCSVMetadata metadata) throws Exception {
        CsvWriter writer = new CsvWriter(output, ',');
        ArrayList<Object> headers = new ArrayList<Object>();
        for (Concept concept : timeseries.getDataset().getConcepts()) {
            Iterator header = metadata.getDimensionHeader(concept.getAcronym());
            int column = metadata.getDimensionColumn(concept.getAcronym());
            if (column != -1) {
                headers.add(column, header == null || ((String)((Object)header)).length() == 0 ? concept.getAcronym() : header);
                continue;
            }
            headers.add(header == null || ((String)((Object)header)).length() == 0 ? concept.getAcronym() : header);
        }
        if (metadata.useTextQualifier()) {
            writer.setTextQualifier(metadata.getTextQualifier());
        }
        if (metadata instanceof DenormalisedTimeseriesCSVMetadata) {
            int status_column;
            DenormalisedTimeseriesCSVMetadata denormalised_metadata = (DenormalisedTimeseriesCSVMetadata)metadata;
            if (denormalised_metadata.useHeaders()) {
                for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                    String value_header = denormalised_metadata.getMeasureValueHeader(period.toString());
                    int value_column = denormalised_metadata.getMeasureValueColumn(period.toString());
                    String status_header = denormalised_metadata.getMeasureStatusHeader(period.toString());
                    status_column = denormalised_metadata.getMeasureStatusColumn(period.toString());
                    if (value_column != -1) {
                        headers.add(value_column, value_header == null || value_header.length() == 0 ? "VALUE_" + period.toString() : value_header);
                    } else {
                        headers.add(value_header == null || value_header.length() == 0 ? "VALUE_" + period.toString() : value_header);
                    }
                    if (status_column != -1) {
                        headers.add(status_column, status_header == null || status_header.length() == 0 ? "SYMBOL_" + period.toString() : status_header);
                        continue;
                    }
                    headers.add(status_header == null || status_header.length() == 0 ? "SYMBOL_" + period.toString() : status_header);
                }
            }
            writer.writeRecord(headers.toArray(new String[headers.size()]));
            for (ObservationSeries series : timeseries.getObservations()) {
                ArrayList<String> record = new ArrayList<String>();
                ReferenceObject[] referenceObjectArray = series.getKeys().elements();
                status_column = referenceObjectArray.length;
                int n = 0;
                while (n < status_column) {
                    String key_value;
                    ReferenceObject key = referenceObjectArray[n];
                    int column = metadata.getDimensionColumn(key.getConcept().getAcronym());
                    String attribute = denormalised_metadata.getDimensionAttribute(key.getConcept().getAcronym());
                    String string = key_value = attribute == null || attribute.equalsIgnoreCase("ID") ? String.valueOf(key.getId().intValue()) : String.valueOf(key.getAttribute(attribute));
                    if (column != -1) {
                        record.add(column, key_value);
                    } else {
                        record.add(key_value);
                    }
                    ++n;
                }
                for (Map.Entry entry : series.getMeasures().entrySet()) {
                    int column = denormalised_metadata.getMeasureValueColumn(((ObservationPeriod)entry.getKey()).toString());
                    if (column != -1) {
                        record.add(column, String.valueOf(((Measure)entry.getValue()).getValue()));
                    } else {
                        record.add(String.valueOf(((Measure)entry.getValue()).getValue()));
                    }
                    column = denormalised_metadata.getMeasureStatusColumn(((ObservationPeriod)entry.getKey()).toString());
                    if (column != -1) {
                        record.add(column, String.valueOf(((Measure)entry.getValue()).getStatus()));
                        continue;
                    }
                    record.add(String.valueOf(((Measure)entry.getValue()).getStatus()));
                }
                writer.writeRecord(record.toArray(new String[record.size()]));
            }
        } else {
            NormalisedTimeseriesCSVMetadata normalised_metadata = (NormalisedTimeseriesCSVMetadata)metadata;
            if (normalised_metadata.useHeaders()) {
                String header = normalised_metadata.getPeriodHeader() == null ? "PERIOD" : normalised_metadata.getPeriodHeader();
                int column = normalised_metadata.getPeriodColumn();
                if (column != -1) {
                    headers.add(column, header);
                } else {
                    headers.add(header);
                }
                header = normalised_metadata.getMeasureValueHeader() == null ? "VALUE" : normalised_metadata.getMeasureValueHeader();
                column = normalised_metadata.getMeasureValueColumn();
                if (column != -1) {
                    headers.add(column, header);
                } else {
                    headers.add(header);
                }
                header = normalised_metadata.getMeasureStatusHeader() == null ? "STATUS" : normalised_metadata.getMeasureStatusHeader();
                column = normalised_metadata.getMeasureStatusColumn();
                if (column != -1) {
                    headers.add(column, header);
                } else {
                    headers.add(header);
                }
            }
            writer.writeRecord(headers.toArray(new String[headers.size()]));
            for (ObservationSeries series : timeseries.getObservations()) {
                Vector<String> keys_and_attributes = new Vector<String>();
                ReferenceObject[] referenceObjectArray = series.getKeys().elements();
                int column = referenceObjectArray.length;
                int n = 0;
                while (n < column) {
                    String key_value;
                    ReferenceObject key = referenceObjectArray[n];
                    int column2 = metadata.getDimensionColumn(key.getConcept().getAcronym());
                    String attribute = String.valueOf(normalised_metadata.getDimensionAttribute(key.getConcept().getAcronym()));
                    String string = key_value = attribute == null || attribute.equalsIgnoreCase("ID") ? String.valueOf(key.getId().intValue()) : String.valueOf(key.getAttribute(attribute));
                    if (column2 != -1) {
                        keys_and_attributes.add(column2, key_value);
                    } else {
                        keys_and_attributes.add(key_value);
                    }
                    ++n;
                }
                for (Map.Entry entry : series.getMeasures().entrySet()) {
                    Vector<String> record = new Vector<String>(keys_and_attributes);
                    int column3 = normalised_metadata.getPeriodColumn();
                    if (column3 != -1) {
                        record.add(column3, ((ObservationPeriod)entry.getKey()).toString());
                    } else {
                        record.add(((ObservationPeriod)entry.getKey()).toString());
                    }
                    column3 = normalised_metadata.getMeasureValueColumn();
                    if (column3 != -1) {
                        record.add(column3, String.valueOf(((Measure)entry.getValue()).getValue()));
                    } else {
                        record.add(String.valueOf(((Measure)entry.getValue()).getValue()));
                    }
                    column3 = normalised_metadata.getMeasureStatusColumn();
                    if (column3 != -1) {
                        record.add(column3, String.valueOf(((Measure)entry.getValue()).getStatus()));
                    } else {
                        record.add(String.valueOf(((Measure)entry.getValue()).getStatus()));
                    }
                    writer.writeRecord(record.toArray(new String[record.size()]));
                }
            }
        }
        writer.flush();
        writer.close();
    }

    public DenormalisedTimeseriesCSVMetadata createDenormalisedMetadata(Timeseries timeseries) {
        return new DenormalisedTimeseriesCSVMetadataImpl(timeseries);
    }

    public NormalisedTimeseriesCSVMetadata createNormalisedMetadata(Timeseries timeseries) {
        return new NormalisedTimeseriesCSVMetadataImpl(timeseries);
    }
}

