/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.csv.test;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceRelationshipCSVMetadata;
import org.fao.fi.fishstat.data.common.api.csv.ValidationResult;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReferenceRelationshipCSVTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void testValidateQuarterMonthCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("QUARTER_MONTH");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("CODE");
        metadata.setChildAttribute("CODE");
        metadata.setParentHeader("PARENT_CODE");
        metadata.setChildHeader("CODE");
        ValidationResult result = ReferenceCSVService.instance().validate(relationship, (Reader)new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/period/ref_month.csv"))), metadata, null);
        System.out.println(result.toString());
        Assert.assertTrue((String)"Validation check failed", (boolean)result.isValid());
    }

    @Test
    public void testValidateInvalidQuarterMonthCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("QUARTER_MONTH");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("CODE");
        metadata.setChildAttribute("CODE");
        metadata.setParentHeader("PARENT_CODE");
        metadata.setChildHeader("CODE");
        ValidationResult result = ReferenceCSVService.instance().validate(relationship, (Reader)new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/period/ref_month_faulty.csv"))), metadata, null);
        System.out.println(result.toString());
        Assert.assertFalse((String)"Validation check succeeded", (boolean)result.isValid());
    }

    @Test
    public void testLoadRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("TEST_TEST");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setParentAttribute("CODE");
        metadata.setChildAttribute("CODE");
        metadata.setParentHeader("PARENT_CODE");
        metadata.setChildHeader("CHILD_CODE");
        ValidationResult result = ReferenceCSVService.instance().validate(relationship, (Reader)new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/test/rel_test_test.csv"))), metadata, null);
        System.out.println(result.toString());
        Assert.assertTrue((String)"Validation check failed", (boolean)result.isValid());
        if (result.isValid()) {
            ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/test/rel_test_test.csv"))), metadata, true, null);
        } else {
            System.out.println(result.toString());
        }
    }
}

