/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.fao.fi.fishstat.core.CoreCache;
import org.fao.fi.fishstat.core.FSDimensionColumnDescriptor;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.csv.ValidationLevel;
import org.fao.fi.fishstat.data.common.api.csv.ValidationMessage;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceService;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoreUtils {
    public static final int FULL_COVERAGE = 1;
    public static final int PART_COVERAGE = 0;
    public static final int NONE_COVERAGE = -1;
    public static String VERSION_ID_DATE_FORMAT = "yyyy-MM-dd";

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c <= '/' || c >= ':') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int countFileLines(File file) throws Exception {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        lineNumberReader.skip(Long.MAX_VALUE);
        int res = lineNumberReader.getLineNumber();
        lineNumberReader.close();
        return res;
    }

    public static Concept getConcept(String acronym) {
        return ReferenceServiceFactory.getService().getConcept(acronym);
    }

    public static Attribute getConceptAttribute(String concept, String acronym) {
        return ReferenceServiceFactory.getService().getConcept(acronym).getAttribute(acronym);
    }

    public static Attribute getConceptAttribute(Concept concept, String acronym) {
        return concept.getAttribute(acronym);
    }

    public static List<ReferenceObject> getReferenceObjectsCustomGroups(Concept dimension) throws ReferenceServiceException {
        LinkedList<ReferenceObject> result = new LinkedList<ReferenceObject>();
        for (CustomGroup customGroup : CustomGroupFactory.get((Concept)dimension)) {
            result.add(customGroup.getObject());
        }
        return result;
    }

    public static List<Concept> getChilds(Concept dimension) {
        Vector<Concept> result = null;
        try {
            LinkedList rels = new LinkedList(dimension.getParentRelationships());
            result = new Vector<Concept>(rels.size());
            int i = 0;
            while (i < rels.size()) {
                result.add(((Relationship)rels.get(i)).getParentConcept());
                ++i;
            }
        }
        catch (ReferenceServiceException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Concept[] getDimensionParents(Dimension dimension, boolean dimensionIncluded) throws ReferenceServiceException {
        LinkedList rels = new LinkedList(dimension.getConcept().getParentRelationships());
        Concept[] res = new Concept[rels.size() + (dimensionIncluded ? 1 : 0)];
        int i = 0;
        while (i < rels.size()) {
            res[i] = ((Relationship)rels.get(i)).getParentConcept();
            ++i;
        }
        if (dimensionIncluded) {
            res[i] = dimension.getConcept();
        }
        return res;
    }

    public static String getTextualValue(ReferenceObject ro, FSDimensionColumnDescriptor cp, String lang) throws ReferenceServiceException {
        if (!ro.getConcept().equals(cp.getConcept())) {
            return CoreUtils.getAttributeLabel(ro.getAttributes().values().toArray(new Object[0])[0], lang);
        }
        String result = null;
        Attribute att = cp.getAttribute();
        result = CoreUtils.getAttributeTextualValue(ro, att, lang);
        if ((result == null || result.trim().equals("") || result.trim().equals("...")) && cp.hasAlternate()) {
            result = "[" + CoreUtils.getAttributeTextualValue(ro, cp.getAlternate(), lang) + "]";
        }
        if (result != null) {
            return result;
        }
        return "";
    }

    public static ReferenceObject calcColumnReferenceObject(FSDimensionColumnDescriptor descr, ReferenceObject ro) {
        if (descr.hasRelationship() && descr.getRelationship().getChildConcept().equals(ro.getConcept())) {
            Set parents = descr.getRelationship().getParents(ro);
            if (parents.size() == 1) {
                return parents.toArray(new ReferenceObject[0])[0];
            }
            return ReferenceObject.NULL;
        }
        return ro;
    }

    public static boolean isDimension(Concept concept, Dataset dataset) {
        return dataset.getConcepts().contains(concept);
    }

    public static boolean isDimension(Concept concept, Timeseries timeseries) {
        return timeseries.getDataset().getDimensions().contains(concept);
    }

    public static String getCurrentLang(MultilingualString mls, String lang) {
        String res = mls.getValue(lang);
        return res != null ? res : "";
    }

    public static String getCurrentLang(MultilingualStringWrapper mlsw, String lang) {
        String res = mlsw.getValue(lang);
        return res != null ? res : "";
    }

    public static String getCurrentLangName(Object o, String lang) throws Error {
        Object method_result = null;
        try {
            Method method = o.getClass().getMethod("getName", new Class[0]);
            method_result = method.invoke(o, new Object[0]);
            if (method_result instanceof MultilingualString) {
                return CoreUtils.getCurrentLang((MultilingualString)method_result, lang);
            }
            if (method_result instanceof MultilingualStringWrapper) {
                return CoreUtils.getCurrentLang((MultilingualStringWrapper)method_result, lang);
            }
            throw new Error("Invalid multilangual object");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Invalid multilangual object");
        }
    }

    public static String getAttributeLabel(Object a, String lang) {
        if (a != null) {
            if (a instanceof MultilingualString) {
                return ((MultilingualString)a).getValue(lang) != null ? ((MultilingualString)a).getValue(lang) : "";
            }
            return a.toString();
        }
        return "";
    }

    public static String getAttributeTextualValue(ReferenceObject refobj, Attribute att, String lang) throws ReferenceServiceException {
        if (refobj == null || att == null) {
            return null;
        }
        String result = null;
        Object value = refobj.getAttribute(att);
        if (value == null) {
            return "";
        }
        if (!att.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
            return value != null ? value.toString() : "";
        }
        result = CoreUtils.getCurrentLang((MultilingualString)value, lang);
        return result;
    }

    public static String getAttributeTextualValue(ReferenceObject refobj, String attname, String lang) throws ReferenceServiceException {
        Object refatt = refobj.getAttribute(attname);
        if (refobj.getConcept().getAttribute(attname).getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
            return CoreUtils.getCurrentLang((MultilingualString)refatt, lang);
        }
        return refatt.toString();
    }

    public static Relationship getRelationship(Concept parent, Concept child) {
        if (parent.getChildrenConcepts().contains(child)) {
            Collection relationships = parent.getChildrenRelationships();
            for (Relationship relationship : relationships) {
                if (!relationship.getChildConcept().equals(child)) continue;
                return relationship;
            }
        }
        return null;
    }

    public static List<String> getConceptFieldsNameList(Concept concept, String lang) {
        try {
            Collection attributes = concept.getAttributes();
            Vector<String> res = new Vector<String>(attributes.size());
            Iterator iterator = attributes.iterator();
            while (iterator.hasNext()) {
                res.add(((Attribute)iterator.next()).getName().getValue(lang));
            }
            return res;
        }
        catch (ReferenceServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Set<ReferenceObject> filetrSet(Set<ReferenceObject> all, Set<ReferenceObject> set) {
        if (all.containsAll(set)) {
            return set;
        }
        HashSet<ReferenceObject> intersection = new HashSet<ReferenceObject>(set);
        intersection.retainAll(all);
        return intersection;
    }

    public static int getCoverage(Relationship rel, ReferenceObject ro, Set<ReferenceObject> set) {
        if (set == null) {
            return 1;
        }
        Set<ReferenceObject> children = CoreCache.getChildren(rel, ro);
        if (set.containsAll(children)) {
            return 1;
        }
        for (ReferenceObject referenceObject : children) {
            if (!set.contains(referenceObject)) continue;
            return 0;
        }
        return -1;
    }

    public static String toCsv(List<?> list) {
        return CoreUtils.toCsv(new TreeSet(list));
    }

    public static String toCsv(Set<?> set) {
        StringBuffer res = new StringBuffer(set.size() * 10);
        for (Object object : set) {
            if (object instanceof ReferenceObject) {
                res.append(((ReferenceObject)object).getId().stringValue());
            } else if (object instanceof ObservationPeriod) {
                res.append(((ObservationPeriod)object).toString());
            } else {
                res.append(object.toString());
            }
            res.append(',');
        }
        if (set.size() > 0) {
            res.trimToSize();
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString();
    }

    public static ReferenceObject[] fromCsv(Concept concept, String csv) {
        CsvReader reader = new CsvReader((Reader)new StringReader(csv));
        try {
            csv = csv.trim();
            if (csv.equals("")) {
                return new ReferenceObject[0];
            }
            reader.setDelimiter(',');
            reader.readRecord();
            String[] ids = reader.getValues();
            ReferenceObject[] res = new ReferenceObject[ids.length];
            int i = 0;
            while (i < ids.length) {
                res[i] = concept.getObject(IdentifierFactory.instance((String)ids[i]));
                ++i;
            }
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object fromCsv(String csv, Class<?> clss) {
        CsvReader reader = new CsvReader((Reader)new StringReader(csv));
        try {
            csv = csv.trim();
            if (csv.equals("")) {
                return Array.newInstance(clss, 0);
            }
            reader.setDelimiter(',');
            reader.readRecord();
            String[] ids = reader.getValues();
            Object res = Array.newInstance(clss, ids.length);
            int i = 0;
            while (i < ids.length) {
                if (clss.equals(ObservationPeriod.class)) {
                    ((Object[])res)[i] = new ObservationPeriod(ids[i]);
                }
                ++i;
            }
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Array.newInstance(clss, 0);
        }
    }

    public static String getNameOrFirstAttribute(ReferenceObject ro, String lang) {
        Object attValue;
        Object object = attValue = ro.getAttribute("NAME") != null ? ro.getAttribute("NAME") : ro.getAttributes().values().toArray()[0];
        if (attValue instanceof MultilingualString) {
            return CoreUtils.getCurrentLang((MultilingualString)attValue, lang);
        }
        return attValue.toString();
    }

    public static String marshallReferenceObjects(List<ReferenceObject> input) {
        StringBuffer res = new StringBuffer(input.size() * 15);
        for (ReferenceObject referenceObject : input) {
            res.append('[');
            res.append(referenceObject.getConcept().getId());
            res.append('|');
            res.append(referenceObject.getId());
            res.append(']');
        }
        return res.toString();
    }

    public static List<ReferenceObject> unMarshallReferenceObjects(String source) {
        ReferenceService service = ReferenceServiceFactory.getService();
        String[] objects = source.substring(1, source.length() - 1).split("][");
        LinkedList<ReferenceObject> res = new LinkedList<ReferenceObject>();
        String[] stringArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            String single_object = stringArray[n2];
            String[] cohords = single_object.split("|");
            Concept concept = service.getConcept(IdentifierFactory.instance((String)cohords[0]));
            ReferenceObject refObject = concept.getObject(IdentifierFactory.instance((String)cohords[0]));
            res.add(refObject);
            ++n2;
        }
        return res;
    }

    public static String getTextualNumber(Number number, char filler, int digits) {
        String strnum = number.toString();
        if (strnum.length() < digits) {
            char[] res = new char[digits - strnum.length()];
            int i = 0;
            while (i < res.length) {
                res[i] = filler;
                ++i;
            }
            return String.valueOf(new String(res)) + strnum;
        }
        return strnum;
    }

    public static MultilingualString cloneMultilingualString(MultilingualString original) {
        MultilingualString res = new MultilingualString();
        Iterator iterator = MultilingualString.LANGUAGES.iterator();
        while (iterator.hasNext()) {
            String lang;
            res.setValue(lang, original.getValue(lang = (String)iterator.next()) != null ? new String(original.getValue(lang)) : null);
        }
        return res;
    }

    public static void copyDirectory(File sourceDir, File destDir) throws IOException {
        File[] children;
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        File[] fileArray = children = sourceDir.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceChild = fileArray[n2];
            String name = sourceChild.getName();
            File destChild = new File(destDir, name);
            if (sourceChild.isDirectory()) {
                CoreUtils.copyDirectory(sourceChild, destChild);
            } else {
                CoreUtils.copyDirContent(sourceChild, destChild, false);
            }
            ++n2;
        }
    }

    public static void copyFile(String from, String to, Boolean overwrite) throws IOException {
        File fromFile = new File(from);
        File toFile = new File(to);
        if (!fromFile.exists()) {
            throw new IOException("File not found: " + from);
        }
        if (!fromFile.isFile()) {
            throw new IOException("Can't copy directories: " + from);
        }
        if (!fromFile.canRead()) {
            throw new IOException("Can't read file: " + from);
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        CoreUtils.copyDirContent(fromFile, toFile, overwrite);
    }

    public static void copyDirContent(File fromFile, File toFile, Boolean overwrite) throws IOException {
        int bytesRead;
        File dir;
        if (toFile.exists() && !overwrite.booleanValue()) {
            throw new IOException("File already exists.");
        }
        String parent = toFile.getParent();
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (!(dir = new File(parent)).exists()) {
            throw new IOException("Destination directory does not exist: " + parent);
        }
        if (dir.isFile()) {
            throw new IOException("Destination is not a valid directory: " + parent);
        }
        if (!dir.canWrite()) {
            throw new IOException("Can't write on destination: " + parent);
        }
        FileInputStream fis = new FileInputStream(fromFile);
        FileOutputStream fos = new FileOutputStream(toFile);
        byte[] buffer = new byte[4096];
        while ((bytesRead = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, bytesRead);
        }
        fos.close();
        fis.close();
    }

    public static boolean copySingleFile(File source, File dest) throws Exception {
        if (source == null || dest == null) {
            throw new Exception("copySingleFile() must specify source and dest");
        }
        if (source != null && source.isFile() && source.exists() && dest != null && !dest.isDirectory() && dest.canWrite()) {
            AbstractInterruptibleChannel inputChannel = null;
            AbstractInterruptibleChannel outputChannel = null;
            FileInputStream fin = null;
            FileOutputStream fout = null;
            try {
                fin = new FileInputStream(source);
                inputChannel = fin.getChannel();
                if (!dest.exists()) {
                    dest.createNewFile();
                }
                fout = new FileOutputStream(dest);
                outputChannel = fout.getChannel();
                ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
            }
            finally {
                try {
                    inputChannel.close();
                }
                catch (Exception exception) {}
                try {
                    fin.close();
                }
                catch (Exception exception) {}
                try {
                    outputChannel.close();
                }
                catch (Exception exception) {}
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static boolean removeDirectory(File directoryPath) {
        if (directoryPath == null) {
            return false;
        }
        if (!directoryPath.exists()) {
            return false;
        }
        if (!directoryPath.isDirectory()) {
            return false;
        }
        System.out.println("CoreUtils.removeDirectory(" + directoryPath.getAbsolutePath() + ")");
        String[] list = directoryPath.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File entry = new File(directoryPath, list[i]);
                if (entry.isDirectory()) {
                    CoreUtils.removeDirectory(entry);
                } else if (!entry.delete()) {
                    System.out.println("file cannot be deleted (in use): " + entry.getAbsolutePath());
                }
                ++i;
            }
        }
        return directoryPath.delete();
    }

    public static String fillNumericString(int val, int length, char pattern) {
        String strval = Integer.toString(val);
        if (length <= strval.length()) {
            return strval;
        }
        char[] rest = new char[length - strval.length()];
        Arrays.fill(rest, pattern);
        return String.valueOf(new String(rest)) + strval;
    }

    public static File proposeEmptyFolder() {
        File res = null;
        int i = 0;
        while (i < 100) {
            res = new File(String.valueOf(Platform.getLocation().toString()) + File.separatorChar + "workspace_" + CoreUtils.fillNumericString(i, 3, '0'));
            if (!res.exists()) {
                return res;
            }
            ++i;
        }
        return res;
    }

    public static String unzipFileWithProgressDescriptor(File wsRootDir, File wsZipFile, IProgressMonitor progressDescriptor, String taskName) throws Exception {
        ZipFile zipFile = new ZipFile(wsZipFile);
        int wsNumOfEntries = zipFile.size();
        zipFile.close();
        if (wsZipFile == null) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(wsZipFile);
        return CoreUtils.unzipFileWithProgressDescriptor(wsRootDir, fileInputStream, progressDescriptor, wsNumOfEntries, taskName);
    }

    public static String unzipFileWithProgressDescriptor(File wsRootDir, InputStream inputStream, IProgressMonitor progressDescriptor, int maxNumEntries, String taskName) throws Exception {
        if (progressDescriptor != null) {
            progressDescriptor.beginTask(taskName, maxNumEntries);
        }
        String ws_root_dir_path = wsRootDir.getAbsolutePath();
        byte[] buf = new byte[1024];
        ZipInputStream zinstream = new ZipInputStream(inputStream);
        ZipEntry zentry = zinstream.getNextEntry();
        while (zentry != null) {
            if (progressDescriptor != null) {
                progressDescriptor.worked(1);
            }
            String entryName = zentry.getName();
            File dest_file = new File(wsRootDir, entryName);
            if (zentry.isDirectory()) {
                if (!dest_file.exists()) {
                    dest_file.mkdir();
                }
            } else {
                int n;
                File file_dir = new File(dest_file.getParent());
                if (!file_dir.exists()) {
                    file_dir.mkdirs();
                }
                dest_file.createNewFile();
                FileOutputStream outstream = new FileOutputStream(dest_file);
                while ((n = zinstream.read(buf, 0, 1024)) > -1) {
                    outstream.write(buf, 0, n);
                }
                outstream.close();
            }
            zinstream.closeEntry();
            zentry = zinstream.getNextEntry();
        }
        zinstream.close();
        if (progressDescriptor != null) {
            progressDescriptor.done();
        }
        return ws_root_dir_path;
    }

    public static String zipFileWithProgressDescriptor(File wsRootDir, File zipFile, List<File> files, List<File> dirs, IProgressMonitor progressDescriptor, String taskName) throws Exception {
        if (zipFile == null) {
            return null;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
        return CoreUtils.zipFileWithProgressDescriptor(wsRootDir, fileOutputStream, files, dirs, progressDescriptor, taskName) ? zipFile.getAbsolutePath() : null;
    }

    public static boolean zipFileWithProgressDescriptor(File ws_dir, FileOutputStream fileOutputStream, List<File> files, List<File> dirs, IProgressMonitor progressDescriptor, String taskName) throws Exception {
        try {
            LinkedList<File> fileList = new LinkedList<File>();
            for (File file : files) {
                fileList.add(file);
                if (progressDescriptor == null) continue;
                progressDescriptor.worked(1);
            }
            for (File dir : dirs) {
                fileList.add(dir);
                CoreUtils.addTree(dir, fileList);
                if (progressDescriptor == null) continue;
                progressDescriptor.worked(2);
            }
            byte[] buf = new byte[1024];
            ZipOutputStream out = new ZipOutputStream(fileOutputStream);
            for (File file : fileList) {
                if (file.isFile()) {
                    int len;
                    String zipEntry = file.getName().equals("fishstatj-jdbc-dao.jar") ? "jar/fishstatj-jdbc-dao.jar" : file.getAbsolutePath().substring(ws_dir.getAbsolutePath().length() + 1);
                    out.putNextEntry(new ZipEntry(zipEntry));
                    FileInputStream in = new FileInputStream(file);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    in.close();
                } else {
                    out.putNextEntry(new ZipEntry(String.valueOf(file.getName()) + '/'));
                }
                out.closeEntry();
                if (progressDescriptor == null) continue;
                progressDescriptor.worked(1);
            }
            out.close();
            if (progressDescriptor != null) {
                progressDescriptor.done();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void addTree(File file, List<File> all) {
        File[] children = file.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (file.isDirectory()) {
                    CoreUtils.addTree(child, all);
                }
                ++n2;
            }
        } else {
            all.add(file);
        }
    }

    public static int mapValidationMessage(ValidationMessage message) {
        if (message.getLevel().equals((Object)ValidationLevel.INFO)) {
            return 1;
        }
        if (message.getLevel().equals((Object)ValidationLevel.WARN)) {
            return 2;
        }
        if (message.getLevel().equals((Object)ValidationLevel.ERROR)) {
            return 4;
        }
        if (message.getLevel().equals((Object)ValidationLevel.FATAL)) {
            return 4;
        }
        return -1;
    }

    public static MultilingualString toMultilingualString(Element rootElement, String tagname) {
        MultilingualString res = new MultilingualString();
        NodeList stringList = rootElement.getElementsByTagName(tagname);
        int i = 0;
        while (i < stringList.getLength()) {
            Element nameElement = (Element)stringList.item(i);
            if (nameElement.getParentNode() == rootElement) {
                res.setValue(nameElement.getAttribute("xml:lang"), nameElement.getTextContent());
            }
            ++i;
        }
        return res;
    }

    public static void toMultilingualString(MultilingualString mls, Element rootElement, String tagname) {
        NodeList stringList = rootElement.getElementsByTagName(tagname);
        int i = 0;
        while (i < stringList.getLength()) {
            Element nameElement = (Element)stringList.item(i);
            if (nameElement.getParentNode() == rootElement) {
                mls.setValue(nameElement.getAttribute("xml:lang"), nameElement.getTextContent());
            }
            ++i;
        }
    }

    public static MultilingualStringWrapper toMultilingualStringWrapper(Element rootElement, String tagname) {
        MultilingualStringWrapper res = new MultilingualStringWrapper();
        NodeList stringList = rootElement.getElementsByTagName(tagname);
        int i = 0;
        while (i < stringList.getLength()) {
            Element nameElement = (Element)stringList.item(i);
            if (nameElement.getParentNode() == rootElement) {
                res.setValue(nameElement.getAttribute("xml:lang"), nameElement.getTextContent());
            }
            ++i;
        }
        return res;
    }

    public static void toMultilingualString(MultilingualStringWrapper mlsw, Element rootElement, String tagname) {
        NodeList stringList = rootElement.getElementsByTagName(tagname);
        int i = 0;
        while (i < stringList.getLength()) {
            Element nameElement = (Element)stringList.item(i);
            if (nameElement.getParentNode() == rootElement) {
                mlsw.setValue(nameElement.getAttribute("xml:lang"), nameElement.getTextContent());
            }
            ++i;
        }
    }
}

