/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.concept.relationship;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CompareInteger;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.concept.relationship.ConceptRelationshipModel;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.model.persistence.ReferencePersistenceService;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class ConceptRelationshipModelImpl
implements ConceptRelationshipModel,
PropertyChangeListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Relationship instance;
    private String acronym;
    private Integer sortorder;
    private MultilingualStringWrapper name;
    private MultilingualStringWrapper description;
    private Concept child;
    private Concept parent;
    private boolean isSystemConceptRelationship = false;

    public ConceptRelationshipModelImpl(Relationship relationship, boolean clone) {
        if (!clone) {
            this.instance = relationship;
        }
        this.syncInstance(relationship);
    }

    public ConceptRelationshipModelImpl() {
        this.acronym = ConceptRelationshipModelImpl.getNewRelationshipAcronym();
    }

    private void syncInstance(Relationship relationship) {
        this.acronym = relationship.getAcronym();
        this.name = new MultilingualStringWrapper("name", new MultilingualString(relationship.getName()), this);
        this.description = new MultilingualStringWrapper("description", new MultilingualString(relationship.getDescription()), this);
        this.parent = relationship.getParentConcept();
        this.child = relationship.getChildConcept();
        this.sortorder = relationship.getSortorder();
        this.isSystemConceptRelationship = CoreCommons.getWorkspaceSystemEntities().isSystemRelationship(relationship);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public Relationship getInstance() {
        return this.instance;
    }

    @Override
    public void setInstance(Relationship instance2) {
        this.instance = instance2;
    }

    @Override
    public boolean isNative() {
        return this.instance != null;
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        String oldAcronym = this.acronym;
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", oldAcronym, acronym);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        MultilingualStringWrapper oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldName, name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        MultilingualStringWrapper oldDescription = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldDescription, description);
    }

    @Override
    public Concept getChild() {
        return this.child;
    }

    @Override
    public void setChild(Concept child) {
        Concept oldChild = this.child;
        this.child = child;
        this.propertyChangeSupport.firePropertyChange("child", oldChild, child);
    }

    @Override
    public Concept getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Concept parent) {
        Concept oldParent = this.parent;
        this.parent = parent;
        this.propertyChangeSupport.firePropertyChange("parent", oldParent, parent);
    }

    @Override
    public void setSortorder(Integer sortorder) {
        Integer oldSortorder = this.sortorder;
        this.sortorder = sortorder;
        this.propertyChangeSupport.firePropertyChange("sortorder", oldSortorder, sortorder);
    }

    @Override
    public Integer getSortorder() {
        return this.sortorder;
    }

    @Override
    public boolean isSystemConceptRelationship() {
        return this.isSystemConceptRelationship;
    }

    @Override
    public boolean isSynchronised() {
        if (this.instance == null) {
            return false;
        }
        if (!this.instance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.instance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.instance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (!this.instance.getParentConcept().equals(this.parent)) {
            return false;
        }
        if (!this.instance.getChildConcept().equals(this.child)) {
            return false;
        }
        return CompareInteger.compare(this.sortorder, this.instance.getSortorder());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public static String getNewRelationshipAcronym() {
        String base = "NEW_RELATIONSHIP";
        int i = 0;
        while (i <= 100) {
            if (ReferenceServiceFactory.getService().getRelationship(String.valueOf(base) + "_" + i) == null) {
                return String.valueOf(base) + "_" + i;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        ReferencePersistenceService service = PersistenceServiceFactory.getReferenceService();
        service.setMonitor(progressMonitor);
        this.setInstance(service.persistConceptRelationship(this));
    }
}

