/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.ICoreConstants;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.dataset.DatasetModel;
import org.fao.fi.fishstat.core.model.dataset.DimensionModel;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.model.persistence.ReferencePersistenceService;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DimensionDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.impl.DimensionDescriptorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DimensionModelImpl
implements DimensionModel,
ICoreConstants,
Cloneable,
PropertyChangeListener {
    private Dimension originalInstance;
    private DatasetModel dataset;
    private String acronym;
    private Attribute attribute;
    private Concept concept;
    private MultilingualStringWrapper description;
    private boolean measure;
    private MultilingualStringWrapper name;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected DimensionModelImpl(DatasetModel dataset) {
        this.dataset = dataset;
        this.setDefaults();
    }

    public DimensionModelImpl(DatasetModel dataset, Dimension dimension, boolean clone) {
        this.originalInstance = dimension;
        this.dataset = dataset;
        this.syncInstance(dimension);
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public void setConcept(Concept concept) {
        this.concept = concept;
        this.propertyChangeSupport.firePropertyChange("concept", this.concept, this.concept);
    }

    @Override
    public boolean getMeasure() {
        return this.measure;
    }

    @Override
    public void setMeasure(boolean isMeasure) {
        this.measure = isMeasure;
        this.propertyChangeSupport.firePropertyChange("isMeasure", this.measure, this.measure);
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
        this.propertyChangeSupport.firePropertyChange("attribute", this.attribute, this.attribute);
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.originalInstance == null) {
            return false;
        }
        if (!this.originalInstance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.originalInstance.getAttribute().equals(this.attribute)) {
            return false;
        }
        if (!this.originalInstance.getConcept().equals(this.concept)) {
            return false;
        }
        if (!this.originalInstance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (!this.originalInstance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        return !this.originalInstance.isObservedMeasure() != this.measure;
    }

    @Override
    public Dimension getInstance() {
        return this.originalInstance;
    }

    @Override
    public DimensionDescriptor getDimensionDescriptor() {
        return new DimensionDescriptorImpl(this.acronym, this.name.getInstance(), this.description.getInstance(), this.concept, this.attribute, this.measure);
    }

    public void setInstance(Dimension instance) {
        this.originalInstance = instance;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        ReferencePersistenceService service = PersistenceServiceFactory.getReferenceService();
        service.setMonitor(progressMonitor);
    }

    private void syncInstance(Dimension dimension) {
        this.acronym = new String(dimension.getAcronym());
        this.concept = dimension.getConcept();
        this.attribute = dimension.getAttribute();
        this.description = new MultilingualStringWrapper("description", dimension.getDescription(), this);
        this.measure = dimension.isObservedMeasure();
        this.name = new MultilingualStringWrapper("name", dimension.getName(), this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    protected DimensionModelImpl clone() throws CloneNotSupportedException {
        DimensionModelImpl res = new DimensionModelImpl(this.dataset);
        if (this.acronym != null) {
            res.acronym = new String(this.acronym);
        }
        if (this.concept != null) {
            res.concept = this.concept;
        }
        if (this.attribute != null) {
            res.attribute = this.attribute;
        }
        if (this.name != null) {
            res.name = this.name.clone();
        }
        if (this.description != null) {
            res.description = this.description.clone();
        }
        res.measure = this.measure;
        return res;
    }

    private void setDefaults() {
        this.acronym = this.getNewDomensionAcronym();
        this.name = new MultilingualStringWrapper();
        this.concept = null;
        this.attribute = null;
        this.description = new MultilingualStringWrapper();
        this.measure = false;
    }

    private String getNewDomensionAcronym() {
        String base = "NEW_DIMENSION";
        int i = 0;
        while (i <= 100) {
            String candidate_acronym = String.valueOf(base) + "_" + i;
            if (!this.dataset.hasDimension(candidate_acronym)) {
                return candidate_acronym;
            }
            ++i;
        }
        return null;
    }

    public Document toXml(String protocol) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document res = documentBuilder.newDocument();
        Element rootElement = res.createElement("dimension");
        this.buildXmlElement(rootElement);
        res.appendChild(rootElement);
        return res;
    }

    public void buildXmlElement(Element rootElement) {
        Document document = rootElement.getOwnerDocument();
        rootElement.setAttribute("acronym", this.acronym);
        rootElement.setAttribute("isMeasure", this.measure ? "true" : "false");
        this.name.toXml(rootElement, "name");
        this.description.toXml(rootElement, "description");
        Element conceptElement = document.createElement("concept");
        rootElement.appendChild(conceptElement);
        Element attributeElement = document.createElement("attribute");
        rootElement.appendChild(attributeElement);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

