/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.ICoreConstants;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesAttributeModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModelImpl;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.model.persistence.ReferencePersistenceService;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeseriesAttributeModelImpl
implements TimeseriesAttributeModel,
ICoreConstants,
Cloneable,
PropertyChangeListener {
    private TimeseriesModelImpl timeseries;
    private Attribute originalInstance;
    private String acronym;
    private MultilingualStringWrapper name;
    private MultilingualStringWrapper description;
    private String value;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public TimeseriesAttributeModelImpl(TimeseriesModelImpl timeseries) {
        this.timeseries = timeseries;
        this.name = new MultilingualStringWrapper();
        this.description = new MultilingualStringWrapper();
        this.propertyChangeSupport.addPropertyChangeListener(timeseries);
        this.setDefaults();
    }

    public TimeseriesAttributeModelImpl(TimeseriesModelImpl timeseries, Attribute attribute) {
        this.timeseries = timeseries;
        this.originalInstance = attribute;
        this.syncInstance(attribute);
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.propertyChangeSupport.firePropertyChange("value", this.value, this.value);
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public boolean isSynchronised() {
        return false;
    }

    @Override
    public Attribute getInstance() {
        return this.originalInstance;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        ReferencePersistenceService service = PersistenceServiceFactory.getReferenceService();
        service.setMonitor(progressMonitor);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void setDefaults() {
        this.acronym = this.getNewAttributeAcronym();
    }

    private String getNewAttributeAcronym() {
        String base = "NEW_ATTRIBUTE";
        int i = 0;
        while (i <= 100) {
            String candidate_acronym = String.valueOf(base) + "_" + i;
            if (!this.timeseries.hasAttribute(candidate_acronym)) {
                return candidate_acronym;
            }
            ++i;
        }
        return null;
    }

    private void syncInstance(Attribute attribute) {
        this.acronym = attribute.getAcronym();
        this.name = new MultilingualStringWrapper("name", attribute.getName(), this);
        this.description = new MultilingualStringWrapper("description", attribute.getDescription(), this);
        this.value = (String)this.timeseries.getInstance().getAttributes().get(attribute);
    }

    public Document toXml(String protocol) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document res = documentBuilder.newDocument();
        Element rootElement = res.createElement("Timeseries");
        this.buildXmlElement(rootElement);
        res.appendChild(rootElement);
        return res;
    }

    public void buildXmlElement(Element rootElement) {
        Document document = rootElement.getOwnerDocument();
        rootElement.setAttribute("acronym", this.acronym);
        this.name.toXml(rootElement, "name");
        this.description.toXml(rootElement, "description");
        Element valueElement = document.createElement("value");
        valueElement.setTextContent(this.value);
        rootElement.appendChild(valueElement);
    }
}

