/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.ICoreConstants;
import org.fao.fi.fishstat.core.MultilingualStringWrapper;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesAttributeModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesAttributeModelImpl;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModel;
import org.fao.fi.fishstat.core.model.persistence.PersistenceServiceFactory;
import org.fao.fi.fishstat.core.model.persistence.TimeseriesPersistenceService;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeseriesModelImpl
implements TimeseriesModel,
ICoreConstants,
Cloneable,
PropertyChangeListener {
    private String datasetAcronym;
    private Timeseries instance;
    private String acronym;
    private MultilingualStringWrapper name;
    private MultilingualStringWrapper description;
    private DataSource datasource;
    private TimeResolution timeResolution;
    private ObservationPeriod firstObservationPeriod;
    private ObservationPeriod lastObservationPeriod;
    private VersionId version;
    protected List<TimeseriesAttributeModel> attributes;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public TimeseriesModelImpl(String dataset) {
        this.datasetAcronym = dataset;
        this.attributes = new LinkedList<TimeseriesAttributeModel>();
        this.name = new MultilingualStringWrapper();
        this.description = new MultilingualStringWrapper();
    }

    public TimeseriesModelImpl(Timeseries timeseries, boolean clone) {
        if (!clone) {
            this.instance = timeseries;
        }
        this.datasetAcronym = timeseries.getDataset().getAcronym();
        this.attributes = new LinkedList<TimeseriesAttributeModel>();
        this.syncInstance(timeseries);
        Set collection = timeseries.getAttributes().keySet();
        for (Attribute attribute : collection) {
            this.attributes.add(new TimeseriesAttributeModelImpl(this, attribute));
        }
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public void setAcronym(String acronym) {
        this.acronym = acronym;
        this.propertyChangeSupport.firePropertyChange("acronym", this.acronym, this.acronym);
    }

    @Override
    public void setDatasetAcronym(String datasetAcronym) {
        this.datasetAcronym = datasetAcronym;
        this.propertyChangeSupport.firePropertyChange("datasetAcronym", this.datasetAcronym, this.datasetAcronym);
    }

    @Override
    public MultilingualStringWrapper getName() {
        return this.name;
    }

    @Override
    public void setName(MultilingualStringWrapper name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public MultilingualStringWrapper getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(MultilingualStringWrapper description) {
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", this.description, this.description);
    }

    @Override
    public DataSource getDatasource() {
        return this.datasource;
    }

    @Override
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
        this.propertyChangeSupport.firePropertyChange("datasource", this.datasource, this.datasource);
    }

    @Override
    public TimeResolution getTimeResolution() {
        return this.timeResolution;
    }

    @Override
    public void setTimeResolution(TimeResolution timeResolution) {
        this.timeResolution = timeResolution;
        this.propertyChangeSupport.firePropertyChange("timeResolution", this.timeResolution, this.timeResolution);
    }

    @Override
    public ObservationPeriod getFirstObservationPeriod() {
        return this.firstObservationPeriod;
    }

    @Override
    public void setFirstObservationPeriod(ObservationPeriod firstPeriod) {
        this.firstObservationPeriod = firstPeriod;
        this.propertyChangeSupport.firePropertyChange("firstPeriod", this.firstObservationPeriod, this.firstObservationPeriod);
    }

    @Override
    public ObservationPeriod getLastObservationPeriod() {
        return this.lastObservationPeriod;
    }

    @Override
    public void setLastObservationPeriod(ObservationPeriod lastPeriod) {
        this.lastObservationPeriod = lastPeriod;
        this.propertyChangeSupport.firePropertyChange("lastPeriod", this.lastObservationPeriod, this.lastObservationPeriod);
    }

    @Override
    public VersionId getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(VersionId version) {
        this.version = version;
        this.propertyChangeSupport.firePropertyChange("version", this.version, this.version);
    }

    @Override
    public boolean isNative() {
        return this.instance != null;
    }

    @Override
    public boolean isSynchronised() {
        if (this.instance == null) {
            return false;
        }
        if (!this.instance.getAcronym().equals(this.acronym)) {
            return false;
        }
        if (!this.instance.getDataSource().equals((Object)this.datasource)) {
            return false;
        }
        if (!this.instance.getName().equals((Object)this.name.getInstance())) {
            return false;
        }
        if (!this.instance.getDescription().equals((Object)this.description.getInstance())) {
            return false;
        }
        if (!this.instance.getTimeResolution().equals((Object)this.timeResolution)) {
            return false;
        }
        if (!this.instance.getFirstObservationPeriod().equals((Object)this.firstObservationPeriod)) {
            return false;
        }
        return this.instance.getLastObservationPeriod().equals((Object)this.lastObservationPeriod);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    @Override
    public Timeseries getInstance() {
        return this.instance;
    }

    public void setInstance(Timeseries instance) {
        this.instance = instance;
    }

    @Override
    public void persistModel(IProgressMonitor progressMonitor) throws Exception {
        TimeseriesPersistenceService service = PersistenceServiceFactory.getTimeseriesService();
        service.setMonitor(progressMonitor);
        this.setInstance(service.persistTimeseries(this.datasetAcronym, this));
    }

    @Override
    public void addAttribute(TimeseriesAttributeModel attribute) {
        int old_size = this.attributes.size();
        this.attributes.add(attribute);
        this.propertyChangeSupport.firePropertyChange("attributes_size", old_size, old_size + 1);
    }

    public void removeAttribute(TimeseriesAttributeModel attribute) {
        if (this.attributes.contains(attribute)) {
            int old_size = this.attributes.size();
            this.attributes.remove(attribute);
            this.propertyChangeSupport.firePropertyChange("attributes_size", old_size, old_size - 1);
        }
    }

    @Override
    public boolean hasAttribute(String acronym) {
        for (TimeseriesAttributeModel attributeModel : this.attributes) {
            if (!attributeModel.getAcronym().equals(acronym)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public TimeseriesAttributeModel createNewAttribute() {
        return new TimeseriesAttributeModelImpl(this);
    }

    @Override
    public TimeseriesAttributeModel getAttribute(String acronym) {
        for (TimeseriesAttributeModel attributeModel : this.attributes) {
            if (!attributeModel.getAcronym().equals(acronym)) continue;
            return attributeModel;
        }
        return null;
    }

    @Override
    public Integer getRowCount() {
        return this.instance != null ? Integer.valueOf(this.instance.getRowCount()) : null;
    }

    @Override
    public String getDatasetAcronym() {
        return this.datasetAcronym;
    }

    @Override
    public Collection<TimeseriesAttributeModel> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getAttributesSize() {
        return this.attributes != null ? this.attributes.size() : 0;
    }

    protected TimeseriesModelImpl clone() throws CloneNotSupportedException {
        TimeseriesModelImpl res = new TimeseriesModelImpl(this.datasetAcronym);
        if (this.acronym != null) {
            res.acronym = new String(this.acronym);
        }
        if (this.datasource != null) {
            res.datasource = new DataSource(this.datasource.getName());
        }
        if (this.description != null) {
            res.description = this.description.clone();
        }
        if (this.firstObservationPeriod != null) {
            res.firstObservationPeriod = new ObservationPeriod(this.firstObservationPeriod.toString());
        }
        if (this.lastObservationPeriod != null) {
            res.lastObservationPeriod = new ObservationPeriod(this.lastObservationPeriod.toString());
        }
        if (this.name != null) {
            res.name = this.name.clone();
        }
        if (this.timeResolution != null) {
            res.timeResolution = this.timeResolution;
        }
        if (this.version != null) {
            res.version = this.version.clone();
        }
        return res;
    }

    private void syncInstance(Timeseries timeseries) {
        this.acronym = timeseries.getAcronym();
        this.name = new MultilingualStringWrapper("name", timeseries.getName(), this);
        this.description = new MultilingualStringWrapper("description", timeseries.getDescription(), this);
        this.datasource = timeseries.getDataSource();
        this.firstObservationPeriod = new ObservationPeriod(timeseries.getFirstObservationPeriod().getISO8601());
        this.lastObservationPeriod = new ObservationPeriod(timeseries.getLastObservationPeriod().getISO8601());
        this.timeResolution = timeseries.getTimeResolution();
    }

    public Document toXml(String protocol) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document res = documentBuilder.newDocument();
        Element rootElement = res.createElement("Timeseries");
        this.buildXmlElement(rootElement);
        res.appendChild(rootElement);
        return res;
    }

    public void buildXmlElement(Element rootElement) {
        Document document = rootElement.getOwnerDocument();
        rootElement.setAttribute("acronym", this.acronym);
        rootElement.setAttribute("version", this.version.toString());
        rootElement.setAttribute("timeResolution", this.timeResolution != null ? this.timeResolution.toString() : "");
        rootElement.setAttribute("firstPeriod", this.firstObservationPeriod != null ? this.firstObservationPeriod.toString() : "");
        rootElement.setAttribute("lastPeriod", this.lastObservationPeriod != null ? this.lastObservationPeriod.toString() : "");
        this.name.toXml(rootElement, "name");
        this.description.toXml(rootElement, "description");
        Element datasourceElement = document.createElement("datasource");
        datasourceElement.setTextContent(this.datasource != null ? this.datasource.getName() : "");
        rootElement.appendChild(datasourceElement);
        Element urlElement = document.createElement("url");
        rootElement.appendChild(urlElement);
    }
}

